/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2010, Yanone (http://yanone.de/typedesign/). All rights reserved.
 * This Font Software is licensed under the SIL Open Font License, Version 1.1.
 * This license is available with a FAQ at: http://scripts.sil.org/OFL
 * 
 * Trademark:
 * Yanone Kaffeesatz is a trademark of Yanone
 * 
 * Description:
 * Yanone Kaffeesatz was first published in 2004 and is Yanone's first ever
 * finished typeface. Its Bold is reminiscent of 1920s coffee house typography,
 * while the rather thin fonts bridge the gap to present times. Lacking self
 * confidence and knowledge about the type scene Yanone decided to publish the
 * family for free under a Creative Commons License. A decision that should turn
 * out one of the best he ever made. It has been downloaded over 100,000 times to
 * date from this website alone, and you can witness Kaffeesatz use on German
 * fresh-water gyms, Dubai mall promos and New Zealand McDonald's ads. And of
 * course on coffee and foodstuff packaging and cafe design around the globe. In
 * 2009 he reworked much of the typeface and it got published in FontShop's
 * FontFont Library under the new name FF Kava. You can read more about it in an
 * extensive article by Yves Peters on the FontFeed.
 * 
 * Manufacturer:
 * Yanone
 * 
 * Designer:
 * Yanone
 * 
 * Vendor URL:
 * http://yanone.de/typedesign/
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":150,"face":{"font-family":"Yanone Kaffeesatz","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 0 0 0 0 0 0 0 0 0","ascent":"288","descent":"-72","x-height":"4","bbox":"-37.0108 -345 308.15 73.6924","underline-thickness":"25.56","underline-position":"-1.44","stemh":"23","stemv":"35","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":56},"!":{"d":"15,-18v0,-11,7,-21,20,-21v15,0,20,8,20,21v0,11,-7,21,-20,21v-15,0,-20,-8,-20,-21xm21,-77r-5,-169v0,-8,6,-8,40,-8r-6,163v-1,13,-7,14,-29,14","w":70},"\"":{"d":"16,-210v5,-6,-22,-85,7,-73v6,0,13,0,17,1v-6,28,8,82,-24,72xm84,-282v-6,29,9,83,-24,72v4,-7,-22,-86,8,-73v6,0,12,0,16,1","w":95,"k":{"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":47,"+":8,"C":20,"G":13,"T":-5,"V":-6,"W":-6,"Y":-7,"d":40,"f":16,"t":6,"u":26,"v":25,"w":25,"y":26,"c":34,"e":37,"o":33,"O":7,")":-7,"]":-7,"A":43,"J":48,"x":23,"a":26,"z":25,"g":39,"n":35,"p":36,"s":33,"(":28,"[":28}},"#":{"d":"140,-91v3,31,-5,21,-25,23v-2,21,7,34,-27,29r1,-29r-34,0v-2,21,7,34,-27,29r2,-29r-20,0v-1,-28,3,-23,21,-23r2,-39r-23,0v-2,-30,5,-22,24,-23v2,-21,-6,-31,27,-28r-1,28r34,0v2,-21,-6,-31,27,-28r-1,28r20,0v2,29,-3,22,-22,23r-2,39r24,0xm58,-130r-1,39r34,0r2,-39r-35,0"},"$":{"d":"59,44r0,-41v-45,-4,-46,-13,-32,-40v15,16,76,17,71,-20v-6,-47,-79,-70,-79,-119v0,-26,17,-41,46,-45v1,-25,-8,-48,26,-44r0,43v42,6,44,9,30,33v-11,-8,-75,-14,-70,13v10,47,79,63,80,119v0,27,-11,52,-46,58v-1,25,9,47,-26,43"},"%":{"d":"16,-189v0,-45,19,-66,51,-66v32,0,48,15,48,66v0,46,-18,67,-50,67v-32,0,-49,-10,-49,-67xm44,-188v0,37,8,43,22,43v13,0,22,-10,22,-44v0,-36,-7,-43,-21,-43v-14,0,-23,9,-23,44xm134,-64v0,-45,19,-66,51,-66v32,0,48,15,48,66v0,46,-18,67,-50,67v-32,0,-49,-10,-49,-67xm162,-62v0,37,7,43,21,43v13,0,23,-10,23,-44v0,-36,-7,-43,-21,-43v-14,0,-23,9,-23,44xm60,3v0,0,-18,-5,-18,-11r145,-247v0,0,16,5,16,12v0,5,-143,246,-143,246","w":248},"&":{"d":"82,-254v46,0,65,10,47,38v-24,-14,-76,-26,-76,15v0,26,35,85,70,129v9,-43,-2,-91,-19,-107v25,-4,48,-2,70,-1v2,10,3,24,-15,23r-17,0v12,16,18,77,3,111v12,13,23,23,30,26v-10,31,-23,30,-45,1v-12,13,-29,23,-54,23v-94,0,-76,-106,-26,-133v-36,-53,-47,-125,32,-125xm111,-41v-16,-19,-33,-43,-48,-67v-27,16,-40,83,12,84v17,0,28,-7,36,-17","w":180},"'":{"d":"16,-210v5,-6,-22,-85,7,-73v6,0,13,0,17,1v-6,28,8,82,-24,72","w":50,"k":{"z":25,"y":26,"x":23,"Y":-7,"W":-6,"V":-6,"T":-5,"O":7,"w":25,"v":25,"u":26,"t":6,"s":33,"p":36,"o":33,"n":35,"g":39,"f":16,"e":37,"d":40,"c":34,"a":26,"]":-7,"[":28,"J":48,"G":13,"C":20,"A":43,")":-7,"(":28,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8}},"(":{"d":"53,-116v0,83,26,144,45,165v-3,13,-7,21,-17,21v-6,0,-58,-56,-58,-185v0,-120,53,-174,58,-174v9,0,14,5,17,19v-22,28,-45,78,-45,154","w":105,"k":{"\u2019":-7,"\u2018":-7,"\u2014":12,"\u2013":12,"\u00ff":-6,"\u00fd":-6,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":12,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00f1":10,"\u00ef":-5,"\u00ed":6,"\u00ec":-9,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"\u00e6":9,"\u00e4":9,"\u00e3":9,"\u00e2":9,"\u00e1":9,"\u00e0":9,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00cf":-4,"\u00ce":-21,"\u00c7":10,"\u00c6":9,"\u00c5":9,"\u00c4":9,"\u00c3":9,"\u00c2":9,"\u00c1":9,"\u00c0":9,"\u00a2":21,"r":10,"q":11,"m":10,"]":-19,"\\":-9,"[":18,"Q":7,"\/":6,"+":17,"*":8,"'":-7,"C":10,"G":7,"d":11,"t":5,"u":11,"v":13,"w":13,"y":-6,"c":11,"e":11,"o":12,"\"":-7,"-":12,"\u201c":-7,"\u201d":-7,"\u00ab":6,"O":7,"A":9,"x":8,"a":9,"\u00e5":9,"z":9,"Z":5,"n":10,"j":-44}},")":{"d":"52,-116v0,-71,-21,-126,-44,-154v3,-14,7,-19,16,-19v5,0,58,51,58,174v0,122,-52,185,-58,185v-10,0,-13,-8,-16,-21v19,-26,44,-80,44,-165","w":105,"k":{"\u2019":27,"\u2018":27,"'":27,"\"":27,"\u201c":27,"\u201d":27}},"*":{"d":"100,-244r-7,57v-1,5,-3,9,-13,6r-9,-59v1,-12,21,-8,29,-4xm102,-178r53,-29v7,6,12,24,3,30r-57,13v-6,-8,-4,-11,1,-14xm6,-181v8,-52,44,-2,66,6v1,9,-4,12,-9,10xm118,-88r-28,-57v-2,-5,-1,-7,8,-11r41,48v7,8,-10,18,-21,20xm24,-108r43,-44v4,-4,9,-3,14,3r-32,56v-6,10,-20,-5,-25,-15","w":169,"k":{"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"o":4,"g":11,"e":7,"d":7,"c":7,"]":8,"Z":6,"X":3,"T":3,"Q":3,"O":3,"J":46,"A":17,")":8,"\u00e7":10,"\u00c6":40,"\u00c5":17,"\u00c4":17,"\u00c3":17,"\u00c2":17,"\u00c1":17,"\u00c0":17,"q":4,"4":10,"\/":20}},"+":{"d":"138,-114v7,42,-25,19,-50,25v-5,25,17,59,-25,50r0,-50r-51,0v-7,-43,26,-19,51,-25v5,-25,-16,-58,25,-51r0,51r50,0","k":{"\u201d":8,"\u201c":8,"]":15,")":15,"\"":8,"\u2019":8,"\u2018":8,"'":8}},",":{"d":"24,-2v-15,-9,-10,-38,10,-37v13,0,20,7,20,22v0,30,-25,71,-40,46v8,-14,9,-21,10,-31","w":65,"k":{"\u00f8":7,"y":17,"w":12,"v":16,"u":9,"t":17,"o":7,"j":-17,"f":14,"e":7,"d":7,"c":3,"Y":22,"W":11,"V":17,"U":3,"T":32,"O":10,"G":5,"C":11,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"\/":-3}},"-":{"d":"81,-89r-68,0v0,-18,0,-25,6,-25r68,0v0,18,0,25,-6,25","w":100,"k":{"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30,"T":38,"V":13,"W":10,"Y":23,"f":11,"t":10,"v":9,"w":7,"y":12,")":11,"]":11,"A":12,"J":44,"X":23,"x":27,"S":33,"z":22,"\u00bb":11,"Z":17}},".":{"d":"13,-18v0,-11,7,-21,20,-21v15,0,21,9,21,21v0,12,-8,20,-21,20v-15,0,-20,-7,-20,-20","w":65,"k":{"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"\/":-3,"C":11,"G":5,"T":32,"V":17,"W":11,"Y":22,"d":7,"f":14,"t":17,"u":9,"v":16,"w":12,"y":17,"c":3,"e":7,"o":7,"\u00f8":7,"O":10,"U":3}},"\/":{"d":"117,-275r-81,275v-2,7,-3,7,-32,7r81,-274v2,-7,3,-8,32,-8","w":120,"k":{"\u201d":-12,"\u201c":-12,"\u00ff":9,"\u00df":7,"\u00d3":8,"\u00bb":14,"\u00ab":22,"z":12,"y":9,"x":16,"w":7,"v":5,"u":14,"t":6,"s":21,"p":19,"o":22,"n":18,"j":4,"i":2,"g":21,"f":6,"e":24,"d":24,"c":25,"a":14,"Z":8,"Y":-5,"X":6,"W":-6,"V":-4,"T":-6,"O":8,"J":28,"G":9,"C":14,"A":22,":":22,".":60,")":-13,"\"":-12,"\u2026":63,"\u2019":-14,"\u2018":-12,"\u2014":11,"\u2013":22,"\u00fd":5,"\u00fc":15,"\u00fb":16,"\u00fa":16,"\u00f9":18,"\u00f8":26,"\u00f7":22,"\u00f6":16,"\u00f5":15,"\u00f4":14,"\u00f3":19,"\u00f2":15,"\u00f1":6,"\u00ef":-19,"\u00ee":-4,"\u00ed":5,"\u00ec":-16,"\u00eb":18,"\u00ea":19,"\u00e9":18,"\u00e8":20,"\u00e7":26,"\u00e6":19,"\u00e5":13,"\u00e4":9,"\u00e3":5,"\u00e2":13,"\u00e1":17,"\u00e0":13,"\u00dd":-5,"\u00dc":-1,"\u00d8":12,"\u00d7":22,"\u00d6":5,"\u00d5":10,"\u00d4":5,"\u00d2":6,"\u00d1":6,"\u00cf":-3,"\u00ce":-9,"\u00cb":3,"\u00ca":4,"\u00c7":12,"\u00c6":56,"\u00c5":22,"\u00c4":20,"\u00c3":22,"\u00c2":20,"\u00c1":27,"\u00c0":18,"\u00bf":18,"\u00b7":21,"\u00a2":31,"\u00a1":13,"r":18,"q":26,"m":18,"_":51,"]":-4,"\\":-5,"[":16,"Q":4,"B":2,"@":14,"?":-11,"=":23,";":21,"9":14,"8":8,"7":4,"6":13,"5":8,"4":31,"3":15,"2":15,"1":15,"0":18,"\/":48,",":60,"'":-12,"%":10}},"0":{"d":"10,-107v0,-71,20,-109,66,-109v46,0,64,34,64,101v0,78,-16,118,-66,118v-50,0,-64,-39,-64,-110xm42,-104v0,59,8,81,33,81v24,0,34,-28,34,-93v0,-49,-7,-74,-32,-74v-27,0,-35,32,-35,86","k":{"\u201d":16,"\u201c":16,"\u00dd":14,"Y":14,"X":11,"W":8,"V":8,"T":22,"J":11,"\"":16,"\u2019":16,"\u2018":16,"_":23,"]":24,"\\":13,"'":16}},"1":{"d":"25,-179v-3,-5,-4,-12,-4,-19v3,-5,62,-23,76,-16r-4,186r47,-1v0,20,0,29,-6,29r-123,0v-10,-32,16,-26,51,-28r4,-158v-12,0,-41,7,-41,7","k":{"\u201d":32,"\u201c":32,"\"":32,"\u2019":32,"\u2018":32,"\/":-1,"*":21,"'":32}},"2":{"d":"10,-9v14,-64,92,-109,92,-154v0,-38,-62,-24,-81,-12v-13,-38,12,-41,60,-41v41,0,54,18,54,49v0,50,-51,85,-86,139r91,-2v0,22,0,30,-6,30r-122,0v-1,-3,-2,-7,-2,-9","k":{"\u201d":8,"\u201c":8,"\"":8,"\u2019":8,"\u2018":8,"\/":-3,"'":8}},"3":{"d":"88,-108v26,3,48,17,48,53v0,60,-35,91,-82,91v-40,0,-42,-16,-34,-39v35,27,84,2,84,-51v0,-31,-27,-37,-57,-37r-1,-19v31,-14,48,-35,48,-55v0,-33,-57,-24,-75,-10v-14,-36,6,-41,58,-41v79,0,50,88,11,108","k":{"\u201d":10,"\u201c":10,"\"":10,"\u2019":10,"\u2018":10,"_":10,"\/":-2,"'":10}},"4":{"d":"10,-73v5,-20,46,-133,88,-145v7,0,13,2,17,4r-1,140v23,3,27,-11,28,9v1,18,-11,20,-28,18v-7,27,21,54,-29,47r0,-47r-66,0v-8,-7,-9,-18,-9,-26xm35,-74r50,0r4,-104v-18,20,-46,72,-54,104","k":{"\u201d":10,"\u201c":10,"\"":10,"\u2019":10,"\u2018":10,"*":10,"'":10}},"5":{"d":"26,-216r110,0v0,22,-2,26,-16,26v-12,0,-70,-1,-70,-1r-5,54v41,-5,91,-4,91,67v0,64,-26,106,-83,106v-44,0,-45,-13,-38,-39v8,8,20,12,35,12v40,0,55,-36,55,-73v0,-56,-50,-54,-90,-46","k":{"_":11}},"6":{"d":"129,-220v-57,-16,-86,3,-90,88v30,-43,102,-36,102,44v0,62,-24,91,-69,91v-55,0,-61,-45,-61,-114v0,-107,36,-142,82,-142v32,0,47,6,36,33xm112,-82v4,-61,-54,-62,-73,-20v-12,103,73,99,73,20","k":{"\u201d":-1,"\u201c":-1,"\"":-1,"\u2019":-1,"\u2018":-1,"_":13,"'":-1}},"7":{"d":"16,-216r129,0v-44,86,-76,166,-86,248v-22,0,-30,-1,-30,-8v0,-77,48,-171,76,-215v-14,1,-44,1,-81,1v-6,0,-8,-13,-8,-26","k":{"\u00c6":27,"q":22,"g":22,"e":17,"d":22,"a":13,"]":8,"X":9,"J":37,"A":27,";":17,":":17,")":8,"\u00ff":13,"\u00fc":13,"\u00fb":13,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00dc":27,"\u00db":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d1":27,"\u00cb":27,"\u00ca":27,"\u00c5":27,"\u00c4":27,"\u00c3":27,"\u00c2":27,"\u00c1":27,"\u00c0":27,"_":59,"@":11,"\/":21}},"8":{"d":"52,-135v-19,-12,-38,-29,-38,-57v0,-41,28,-62,61,-62v33,0,64,12,64,58v0,31,-20,50,-39,63v21,14,41,36,41,67v0,38,-21,69,-63,69v-87,0,-82,-112,-26,-138xm112,-66v-1,-31,-18,-39,-36,-53v-43,10,-53,92,0,94v22,0,36,-15,36,-41xm79,-226v-34,0,-48,44,-22,61v5,5,13,11,22,17v18,-12,33,-27,33,-47v0,-22,-16,-31,-33,-31","k":{"_":8}},"9":{"d":"20,6v62,15,88,-25,91,-88v-31,45,-101,29,-101,-47v0,-62,23,-90,68,-90v51,0,62,28,62,112v0,98,-28,144,-90,144v-31,0,-38,-9,-30,-31xm39,-132v0,59,49,61,73,23v0,-53,-5,-84,-34,-84v-24,0,-39,20,-39,61","k":{"\u201d":8,"\u201c":8,"\"":8,"\u2019":8,"\u2018":8,"_":9,"'":8}},":":{"d":"13,-139v0,-11,7,-21,20,-21v15,0,21,9,21,21v0,12,-8,21,-21,21v-15,0,-20,-8,-20,-21xm13,-18v0,-11,7,-21,20,-21v15,0,21,9,21,21v0,12,-8,20,-21,20v-15,0,-20,-7,-20,-20","w":65,"k":{"\/":-3,"T":19,"V":2}},";":{"d":"13,-139v0,-11,7,-21,20,-21v15,0,20,9,20,21v0,12,-7,21,-20,21v-15,0,-20,-8,-20,-21xm22,-2v-14,-9,-8,-38,10,-37v13,0,20,7,20,22v0,31,-24,71,-40,46v8,-14,9,-21,10,-31","w":65,"k":{"j":-23,"T":19,"\/":-4,"V":2}},"=":{"d":"132,-122r-120,0v0,-18,0,-26,6,-26r120,0v0,18,0,26,-6,26xm132,-55r-120,0v0,-18,0,-26,6,-26r120,0v0,18,0,26,-6,26","k":{"\/":-2}},"?":{"d":"27,-18v0,-11,7,-21,20,-21v15,0,20,9,20,21v0,12,-7,20,-20,20v-15,0,-20,-7,-20,-20xm33,-75v-21,-45,38,-90,38,-123v0,-37,-47,-30,-60,-19v-14,-28,6,-39,41,-39v30,0,50,17,50,50v1,61,-55,72,-42,128v-3,4,-19,4,-27,3","w":106,"k":{"\u201d":-8,"\u201c":-8,"\u00c6":19,"J":9,"A":19,"\"":-8,"\u2019":-8,"\u2018":-8,"\u00dc":19,"\u00db":19,"\u00d6":19,"\u00d5":19,"\u00d4":19,"\u00d1":19,"\u00cb":19,"\u00ca":19,"\u00c5":19,"\u00c4":19,"\u00c3":19,"\u00c2":19,"\u00c1":19,"\u00c0":19,"'":-8}},"@":{"d":"95,-144v-11,-31,10,-31,46,-34v62,-4,34,92,36,150v31,8,42,-15,42,-94v0,-73,-19,-98,-78,-98v-62,0,-94,30,-94,129v0,108,29,131,85,131v38,0,63,-7,84,-16v5,6,8,14,8,21v0,11,-34,23,-89,23v-66,0,-118,-16,-118,-163v0,-107,50,-151,125,-151v70,0,107,31,107,117v0,118,-37,128,-57,128v-9,0,-17,-3,-22,-8v-29,13,-91,24,-85,-47v5,-56,29,-64,67,-55v2,-15,3,-49,-21,-42v-15,0,-25,3,-36,9xm132,-22v27,1,17,-47,20,-71v-25,-3,-38,0,-39,38v0,26,6,33,19,33","w":265,"k":{"\u201d":14,"\u201c":14,"\u00dd":6,"x":3,"j":-18,"Y":6,"X":4,"V":5,"T":10,"J":8,"\"":14,"\u2019":14,"\u2018":14,"7":4,"\/":-2,"'":14}},"A":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120","w":157,"k":{"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-9,"*":21,"'":38}},"B":{"d":"15,0r0,-245v2,-13,32,-7,46,-7v29,0,60,10,60,56v0,40,-19,56,-34,58v17,1,42,9,42,52v0,81,-43,91,-114,86xm45,-226r0,77v31,3,44,-4,44,-41v0,-39,-15,-36,-44,-36xm45,-124r0,98v36,3,50,-7,50,-57v0,-46,-18,-41,-50,-41","w":135,"k":{"\u2026":8,"\u2019":5,"\u2018":5,"\u00ff":6,"\u00fd":6,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00e7":2,"\u00dd":6,"\u00dc":6,"\u00db":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d1":6,"\u00cb":6,"\u00ca":6,"\u00c6":6,"\u00c5":6,"\u00c4":6,"\u00c3":6,"\u00c2":6,"\u00c1":6,"\u00c0":6,"_":14,",":8,"'":5,"T":6,"V":3,"Y":6,"t":6,"v":6,"w":3,"y":6,"\"":5,"\u201c":5,"\u201d":5,")":3,"]":3,"A":6,".":8,"J":7,"X":11,"x":11}},"C":{"d":"82,-257v38,1,38,18,29,38v-43,-21,-67,-9,-69,102v-1,96,25,99,69,78v14,25,-3,43,-40,44v-34,0,-60,-16,-60,-121v0,-123,39,-141,71,-141","w":122,"k":{"\u2026":-2,"\u2019":-2,"\u2018":-2,"\u2014":30,"\u2013":30,"\u00ff":23,"\u00fd":23,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":4,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00c7":4,"q":4,"Q":8,"@":2,"0":9,"\/":-6,",":-2,"*":4,"'":-2,"C":4,"G":5,"d":4,"f":9,"t":7,"u":7,"v":21,"w":19,"y":23,"c":4,"e":6,"o":5,"\u00f8":5,"\"":-2,"-":30,"\u201c":-2,"\u201d":-2,"\u00ab":8,"O":8,".":-2,"x":5,"S":2,"a":4,"z":1}},"D":{"d":"16,-245v1,-13,30,-7,44,-7v47,0,71,26,71,113v0,130,-24,145,-115,139r0,-245xm98,-142v0,-77,-8,-85,-53,-83r0,197r16,0v19,0,37,-14,37,-114","w":141,"k":{"\u2026":13,"\u2019":12,"\u2018":12,"\u00ff":2,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f3":2,"\u00f2":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"\u00dd":10,"\u00dc":13,"\u00db":13,"\u00d6":13,"\u00d5":13,"\u00d4":13,"\u00d1":13,"\u00cb":13,"\u00ca":13,"\u00c6":13,"\u00c5":13,"\u00c4":13,"\u00c3":13,"\u00c2":13,"\u00c1":13,"\u00c0":13,"q":2,"_":26,",":13,"'":12,"T":9,"V":5,"W":7,"Y":10,"o":2,"\u00f8":2,"\"":12,"\u201c":12,"\u201d":12,")":7,"]":7,"A":13,".":13,"J":18,"x":3,"a":2}},"E":{"d":"45,-26r62,0v0,24,0,26,-6,26r-85,0r0,-246v0,0,0,-6,6,-6r86,0v0,24,0,26,-5,26r-58,0r0,76r54,0v8,49,-27,19,-54,27r0,97","w":115,"k":{"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4,"d":6,"u":3,"w":5,"y":5,"c":2,"e":5,"o":7,"\u00f8":7,"\"":-4,"-":10,"\u201c":-4,"\u201d":-4,"x":3,"a":4,"z":1}},"F":{"d":"45,-6v1,9,-19,5,-29,6r0,-246v0,0,0,-6,6,-6r86,0v0,24,0,25,-5,25r-58,0r0,77r54,0v0,22,0,26,-5,26r-49,0r0,118","w":112,"k":{"\u2026":44,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":7,"\u00fd":7,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e7":8,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00dc":24,"\u00db":24,"\u00d6":24,"\u00d5":24,"\u00d4":24,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":6,"q":10,"_":48,"@":4,"0":6,"\/":17,",":44,"'":-4,"d":10,"t":3,"u":7,"v":5,"w":5,"y":7,"c":8,"e":10,"o":10,"\"":-4,"-":10,"\u201c":-4,"\u201d":-4,"\u00ab":10,"A":24,".":44,"J":36,"x":16,"a":6,"z":5,"g":6,"\u00bb":8}},"G":{"d":"87,-255v35,1,44,14,34,36v-51,-24,-80,0,-80,97v0,85,14,97,37,97v13,0,19,-6,21,-9r0,-89r-26,0v1,-10,-5,-25,7,-25r47,0r-1,135v-8,7,-24,16,-49,16v-48,0,-67,-22,-67,-123v0,-113,29,-135,77,-135","w":138,"k":{"\u00ff":6,"\u00fd":6,"\u00dd":3,"\/":-2,"Y":3,"v":4,"y":6,")":1,"]":1,"x":3}},"H":{"d":"102,0r0,-122r-57,0r0,116v0,6,1,6,-29,6r0,-246v0,-6,-1,-6,29,-6r0,103r57,0r0,-97v0,-6,-1,-6,29,-6r0,246v0,6,1,6,-29,6","w":147,"k":{"\/":-2}},"I":{"d":"15,0r0,-239v0,-13,1,-13,30,-13r0,246v0,6,-1,6,-30,6","w":60,"k":{"\/":-4}},"J":{"d":"65,-66r0,-173v0,-13,0,-13,30,-13r0,193v0,36,-11,62,-50,62v-41,0,-43,-18,-33,-38v21,20,53,17,53,-31","w":110,"k":{"\u2026":5,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":13,"\/":-2,",":5,")":1,"]":1,"A":8,".":5,"J":6,"x":4}},"K":{"d":"15,0r0,-246v0,-6,0,-6,30,-6r0,109r57,-107v11,-2,36,-6,30,6r-57,101v28,22,48,68,57,137v1,11,-21,7,-32,6v-14,-65,-19,-102,-55,-124r0,118v0,6,0,6,-30,6","w":141,"k":{"\u2019":-1,"\u2018":-1,"\u2014":13,"\u2013":13,"\u00ff":13,"\u00fd":13,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":8,"q":5,"Q":6,"\/":-5,"*":13,"'":-1,"C":8,"d":5,"f":12,"t":10,"u":6,"v":15,"w":11,"y":13,"c":5,"e":8,"o":6,"\u00f8":6,"\"":-1,"-":13,"\u201c":-1,"\u201d":-1,"\u00ab":3,"O":6,"J":4,"a":6}},"L":{"d":"45,-252r0,225r62,0v-1,9,5,27,-6,27r-86,0r0,-244v0,-8,1,-8,30,-8","w":114,"k":{"\u2019":49,"\u2018":49,"\u2014":38,"\u2013":38,"\u00ff":19,"\u00fd":19,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":7,"\u00ef":7,"\u00ee":7,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":8,"\u00e6":7,"\u00e5":7,"\u00e4":7,"\u00e3":7,"\u00e2":7,"\u00e1":7,"\u00e0":7,"\u00dd":27,"\u00d8":12,"\u00d6":12,"\u00d5":12,"\u00d4":12,"\u00d3":12,"\u00d2":12,"\u00c7":10,"r":9,"q":9,"Q":12,"?":12,"0":8,"\/":-3,"*":48,"'":49,"C":10,"G":10,"T":27,"V":27,"W":24,"Y":27,"d":9,"f":16,"t":9,"u":6,"v":12,"w":19,"y":19,"c":8,"e":9,"o":10,"\u00f8":10,"\"":49,"-":38,"\u201c":49,"\u201d":49,"\u00ab":19,"O":12,")":6,"]":6,"S":3,"a":7}},"M":{"d":"15,0r0,-246v2,-12,18,-4,28,-6r46,149v10,-42,29,-100,42,-143v1,-11,19,-4,29,-6r0,246v0,6,0,6,-30,6v-1,-57,4,-155,8,-194v-8,27,-20,73,-23,81v-8,19,-11,43,-23,58r-13,0r-42,-139v4,20,9,141,8,188v0,6,-3,6,-30,6","w":176},"N":{"d":"116,0r-41,-99v-6,-16,-25,-74,-34,-102r4,195v0,6,-1,6,-30,6r0,-246v1,-10,19,-4,29,-6r40,97v7,19,25,74,34,101v-5,-62,-2,-130,-3,-192v0,-6,0,-6,29,-6r0,246v0,11,-18,4,-28,6","w":159},"O":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,99,-20,132,-68,132v-46,0,-65,-26,-65,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105","w":154,"k":{"\u2026":12,"\u2019":4,"\u2018":4,"\u00e7":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":19,",":12,"*":3,"'":4,"T":8,"V":4,"W":5,"Y":8,"c":2,"\"":4,"\u201c":4,"\u201d":4,"O":1,"Q":1,")":7,"]":7,"A":8,".":12,"J":12,"X":8,"x":7}},"P":{"d":"15,0r0,-246v3,-12,29,-6,42,-6v45,0,66,21,66,71v0,64,-31,81,-78,79r0,96v0,6,-1,6,-30,6xm91,-184v1,-34,-13,-46,-46,-42r0,97v35,3,44,-7,46,-55","w":129,"k":{"\u2026":52,"\u2014":17,"\u2013":17,"\u00ff":4,"\u00fc":4,"\u00fb":4,"\u00f8":8,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":8,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":5,"\u00dc":26,"\u00db":26,"\u00d6":26,"\u00d5":26,"\u00d4":26,"\u00d1":26,"\u00cb":26,"\u00ca":26,"\u00c6":26,"\u00c5":26,"\u00c4":26,"\u00c3":26,"\u00c2":26,"\u00c1":26,"\u00c0":26,"\u00b7":7,"q":8,"_":70,"@":8,"\/":9,",":52,"Y":5,"d":8,"c":8,"e":8,"o":8,"-":17,"\u00ab":11,")":11,"]":11,"A":26,".":52,"J":40,"X":16,"x":3,"a":4,"Z":12}},"Q":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,79,-13,116,-42,128v3,30,21,30,41,20v15,19,-6,30,-28,30v-25,0,-39,-14,-47,-46v-41,-3,-57,-32,-57,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105","w":154,"k":{"\u201d":4,"\u201c":4,"x":9,"]":3,"Y":11,"X":9,"V":3,"T":6,"J":12,"A":3,".":11,")":3,"\"":4,"\u2026":11,"\u2019":4,"\u2018":4,"\u00dd":11,"\u00dc":3,"\u00db":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d1":3,"\u00cb":3,"\u00ca":3,"\u00c6":19,"\u00c5":3,"\u00c4":3,"\u00c3":3,"\u00c2":3,"\u00c1":3,"\u00c0":3,"_":-9,",":11,"'":4}},"R":{"d":"15,0r0,-246v3,-10,29,-5,42,-6v45,0,66,21,66,71v0,39,-12,61,-31,71v11,15,30,47,34,104v2,10,-21,6,-32,6v-4,-61,-21,-91,-30,-103r-19,1r0,96v0,6,-1,6,-30,6xm91,-182v1,-35,-12,-48,-46,-44r0,97v35,3,44,-7,46,-53","w":134,"k":{"\u2014":9,"\u2013":9,"\u00ff":4,"\u00fd":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":8,"\u00d8":2,"\u00d6":2,"\u00d5":2,"\u00d4":2,"\u00d3":2,"\u00d2":2,"\u00c7":4,"\u00c6":31,"q":3,"C":4,"T":6,"V":4,"W":4,"Y":8,"d":3,"y":4,"e":5,"o":5,"\u00f8":5,"-":9,"O":2,"Q":2,"X":2,"x":3}},"S":{"d":"71,-256v46,1,56,11,40,35v-13,-13,-75,-13,-70,16v8,52,80,82,80,141v0,36,-16,68,-65,68v-47,0,-56,-17,-39,-43v19,21,76,17,72,-24v-5,-53,-80,-86,-80,-141v0,-30,22,-52,62,-52","w":128,"k":{"\u2019":-6,"\u2018":-6,"\u00ff":12,"\u00fd":12,"\u00c6":16,"_":7,"'":-6,"f":11,"v":10,"w":12,"y":12,"\"":-6,"\u201c":-6,"\u201d":-6,"J":4,"x":9}},"T":{"d":"125,-225r-44,0r0,219v0,6,0,6,-29,6r0,-225r-49,0v1,-10,-5,-27,6,-27r122,0v-2,9,5,27,-6,27","w":134,"k":{"\u2026":34,"\u2019":-5,"\u2018":-5,"\u2014":38,"\u2013":38,"\u00ff":37,"\u00fd":37,"\u00fc":35,"\u00fb":35,"\u00fa":35,"\u00f9":35,"\u00f8":36,"\u00f6":36,"\u00f5":36,"\u00f4":36,"\u00f3":36,"\u00f2":36,"\u00f1":32,"\u00ef":6,"\u00ee":6,"\u00ed":6,"\u00ec":6,"\u00eb":36,"\u00ea":36,"\u00e9":36,"\u00e8":36,"\u00e7":33,"\u00e6":35,"\u00e5":35,"\u00e4":35,"\u00e3":35,"\u00e2":35,"\u00e1":35,"\u00e0":35,"\u00dc":24,"\u00db":24,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":15,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":32,"q":35,"m":32,"_":31,"Q":8,"@":17,";":25,"0":24,"\/":22,",":34,"*":3,"'":-5,"C":15,"G":13,"d":35,"f":16,"t":15,"u":35,"v":33,"w":32,"y":37,"c":33,"e":36,"o":36,"\"":-5,"-":38,"\u201c":-5,"\u201d":-5,"\u00ab":25,"O":8,"A":24,".":34,"J":31,"x":36,"a":35,"z":33,"g":35,"\u00bb":34,":":25,"n":32,"p":39,"s":33,"h":9,"k":9,"i":6,"j":6}},"U":{"d":"46,-252r0,179v0,29,4,50,34,50v13,0,26,-4,32,-7r0,-216v0,-6,0,-6,29,-6r0,243v-9,6,-33,13,-61,13v-58,0,-65,-35,-65,-77r0,-173v0,-6,1,-6,31,-6","w":157},"V":{"d":"3,-243v-4,-14,18,-8,30,-9r30,139v6,32,10,65,14,88v7,-69,29,-151,40,-218v3,-15,20,-7,33,-9r-56,253v-19,4,-36,4,-41,-19v-12,-59,-50,-225,-50,-225","w":151,"k":{"\u2026":17,"\u2019":-6,"\u2018":-6,"\u2014":18,"\u2013":18,"\u00ff":6,"\u00fd":6,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":15,"\u00f6":15,"\u00f5":15,"\u00f4":15,"\u00f3":15,"\u00f2":15,"\u00f1":11,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":17,"\u00e6":14,"\u00e5":14,"\u00e4":14,"\u00e3":14,"\u00e2":14,"\u00e1":14,"\u00e0":14,"\u00dc":24,"\u00db":24,"\u00d8":4,"\u00d6":4,"\u00d5":4,"\u00d4":4,"\u00d3":4,"\u00d2":4,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":8,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":11,"q":18,"m":11,"_":30,"Q":4,"@":10,"0":12,"\/":19,",":17,"'":-6,"C":8,"G":6,"d":18,"f":4,"t":4,"u":14,"v":10,"w":8,"y":6,"c":17,"e":18,"o":15,"\"":-6,"-":18,"\u201c":-6,"\u201d":-6,"\u00ab":12,"O":4,"A":24,".":17,"J":32,"x":9,"a":14,"z":11,"g":19,"\u00bb":8,":":10,";":10,"n":11,"p":14,"s":13,"i":5,"j":8}},"W":{"d":"3,-243v-4,-15,19,-7,30,-9r26,139v6,32,7,58,10,81r3,0v3,-73,31,-132,31,-199v0,-14,16,-8,28,-9r26,127v6,32,7,58,10,81r3,0v5,-71,23,-144,32,-211v2,-15,19,-7,32,-9r-47,253v-21,3,-35,6,-40,-19v-10,-52,-25,-101,-30,-162v-6,67,-18,122,-30,181v-21,3,-38,5,-42,-21v-10,-60,-42,-223,-42,-223","w":235,"k":{"\u2026":13,"\u2019":-7,"\u2018":-7,"\u2014":12,"\u2013":12,"\u00ff":8,"\u00fd":8,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f8":13,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00f1":14,"\u00ef":14,"\u00ee":14,"\u00ec":-22,"\u00eb":14,"\u00ea":14,"\u00e9":14,"\u00e8":14,"\u00e7":13,"\u00e6":14,"\u00e5":14,"\u00e4":14,"\u00e3":14,"\u00e2":14,"\u00e1":14,"\u00e0":14,"\u00dc":19,"\u00db":19,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":19,"\u00cb":19,"\u00ca":19,"\u00c7":9,"\u00c6":19,"\u00c5":19,"\u00c4":19,"\u00c3":19,"\u00c2":19,"\u00c1":19,"\u00c0":19,"r":14,"q":13,"m":14,"_":25,"Q":5,"@":4,"0":6,"\/":15,",":13,"'":-7,"C":9,"G":6,"d":13,"u":10,"v":4,"w":7,"y":8,"c":13,"e":14,"o":13,"\"":-7,"-":12,"\u201c":-7,"\u201d":-7,"\u00ab":9,"O":5,"A":19,".":13,"J":29,"x":10,"a":14,"z":10,"g":12,"\u00bb":4,"Z":9,":":10,";":10,"n":14,"p":13,"s":7}},"X":{"d":"143,-252r-47,120r52,127v2,3,1,5,-3,5r-32,0r-38,-101v-9,27,-27,69,-40,97v-4,8,-21,2,-32,4r55,-130r-45,-117v-2,-5,0,-5,35,-5r32,95r31,-90v1,-5,1,-5,32,-5","w":152,"k":{"\u2019":-4,"\u2018":-4,"\u2014":20,"\u2013":20,"\u00ff":21,"\u00fd":21,"\u00fc":12,"\u00fb":12,"\u00fa":12,"\u00f9":12,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":5,"\u00ef":5,"\u00ee":5,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":6,"\u00e6":5,"\u00e5":5,"\u00e4":5,"\u00e3":5,"\u00e2":5,"\u00e1":5,"\u00e0":5,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00c7":8,"\u00c6":31,"q":9,"Q":8,"@":2,"0":9,"*":3,"'":-4,"C":8,"G":7,"d":9,"f":11,"t":9,"u":12,"v":16,"w":17,"y":21,"c":6,"e":9,"o":7,"\u00f8":7,"\"":-4,"-":20,"\u201c":-4,"\u201d":-4,"\u00ab":6,"O":8,"a":5,"p":8}},"Y":{"d":"52,0r0,-102r-50,-145v-1,-5,-1,-5,33,-5v11,32,29,96,32,125v3,-26,21,-89,31,-120v2,-5,2,-5,32,-5r-49,148r0,98v0,6,1,6,-29,6","w":131,"k":{"\u2026":22,"\u2019":-7,"\u2018":-7,"\u2014":23,"\u2013":23,"\u00ff":16,"\u00fd":16,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":25,"\u00f5":25,"\u00f4":25,"\u00f3":25,"\u00f2":25,"\u00f1":23,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":25,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":28,"\u00db":28,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":28,"\u00cb":28,"\u00ca":28,"\u00c7":12,"\u00c5":28,"\u00c4":28,"\u00c3":28,"\u00c2":28,"\u00c1":28,"\u00c0":28,"r":23,"q":28,"m":23,"_":26,"Q":8,"@":5,"0":17,"\/":25,",":22,"'":-7,"C":12,"G":10,"d":28,"f":10,"t":12,"u":21,"v":14,"w":15,"y":16,"c":25,"e":27,"o":25,"\u00f8":25,"\"":-7,"-":23,"\u201c":-7,"\u201d":-7,"\u00ab":21,"O":8,"A":28,"\u00c6":28,".":22,"J":31,"x":16,"S":3,"a":22,"z":18,"g":24,"\u00bb":16,":":19,";":19,"n":23,"p":26,"s":24,"i":5,"j":10}},"Z":{"d":"16,-225v1,-10,-5,-27,6,-27r108,0v3,6,3,16,0,23r-92,203v30,-1,66,3,91,-3v-2,11,6,28,-7,29r-112,0v-6,-5,-6,-16,-2,-24r91,-202","w":138,"k":{"\u2019":-5,"\u2018":-5,"\u2014":36,"\u2013":36,"\u00ff":13,"\u00fd":13,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e7":7,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"r":10,"q":9,"0":4,"'":-5,"d":9,"f":10,"t":6,"u":10,"w":11,"y":13,"c":7,"e":10,"o":7,"\u00f8":7,"\"":-5,"-":36,"\u201c":-5,"\u201d":-5,"\u00ab":3,")":5,"]":5,"x":7,"a":6,"g":5,"p":5}},"[":{"d":"66,-296r69,0v0,24,0,27,-9,27r-53,0r0,313r62,0v0,27,-2,28,-10,28r-81,0r0,-359v0,-8,0,-9,22,-9","w":138,"k":{"j":-44,")":-16,"\u2019":-7,"\u2018":-7,"\u2014":12,"\u2013":12,"\u00ff":-6,"\u00fd":-6,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":12,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00f1":10,"\u00ef":-5,"\u00ed":6,"\u00ec":-9,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"\u00e6":9,"\u00e4":9,"\u00e3":9,"\u00e2":9,"\u00e1":9,"\u00e0":9,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00cf":-4,"\u00ce":-21,"\u00c7":10,"\u00c6":9,"\u00c5":9,"\u00c4":9,"\u00c3":9,"\u00c2":9,"\u00c1":9,"\u00c0":9,"\u00a2":21,"r":10,"q":11,"m":10,"]":-19,"\\":-9,"[":18,"Q":7,"0":24,"\/":14,"+":17,"*":8,"'":-7,"C":10,"G":7,"d":11,"t":5,"u":11,"v":13,"w":13,"y":-6,"c":11,"e":11,"o":12,"\"":-7,"-":12,"\u201c":-7,"\u201d":-7,"\u00ab":6,"O":7,"A":9,"x":8,"a":9,"\u00e5":9,"z":9,"Z":5,"n":10}},"\\":{"d":"33,-275r81,279v2,7,0,7,-29,7r-81,-278v-3,-7,0,-8,29,-8","w":118,"k":{"\u201d":46,"\u201c":46,"\u00c6":-15,"]":6,"A":-15,".":-12,")":6,"\"":46,"\u2026":-12,"\u2019":46,"\u2018":46,"\u00dc":-15,"\u00db":-15,"\u00d6":-15,"\u00d5":-15,"\u00d4":-15,"\u00d1":-15,"\u00cb":-15,"\u00ca":-15,"\u00c5":-15,"\u00c4":-15,"\u00c3":-15,"\u00c2":-15,"\u00c1":-15,"\u00c0":-15,"\/":-5,",":-12,"'":46}},"]":{"d":"72,72r-69,0v0,-24,1,-27,10,-27r53,0r0,-314r-62,0v0,-27,1,-27,9,-27r82,0r0,359v0,8,-1,9,-23,9","w":138,"k":{"]":15,")":15,"\u2019":27,"\u2018":27,"'":27,"\"":27,"\u201c":27,"\u201d":27}},"_":{"d":"125,39r-120,0v0,-18,0,-25,6,-25r120,0v0,18,0,25,-6,25","w":135,"k":{"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":11,"\u00f6":11,"\u00f5":11,"\u00f4":11,"\u00f3":11,"\u00f2":11,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":13,"\u00dd":28,"\u00d8":15,"\u00d6":15,"\u00d5":15,"\u00d4":15,"\u00d3":15,"\u00d2":15,"\u00c7":19,"w":18,"v":24,"u":11,"t":21,"o":11,"j":-27,"g":-4,"f":10,"e":8,"d":6,"c":13,"Y":28,"W":22,"V":28,"T":26,"O":15,"G":7,"C":19,"q":13,"Q":9,"9":-5,"8":13,"6":13,"5":-4,"4":49,"0":17,"\/":-18}},"`":{"d":"50,-206v-3,0,-44,-29,-50,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-5,16,-12,16","w":61},"a":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58","w":127,"k":{"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,"f":3,"t":6,"y":3,"\"":30,"\u201c":30,"\u201d":30,")":9,"]":9,"x":3}},"b":{"d":"17,-7r0,-244v0,-14,5,-14,29,-14r0,94v39,-25,83,-18,83,58v0,104,-40,117,-70,117v-19,0,-33,-4,-42,-11xm46,-147r0,120v32,13,46,5,50,-79v2,-56,-22,-60,-50,-41","w":137,"k":{"\u2026":7,"\u2019":28,"\u2018":28,"_":14,"\/":4,",":7,"'":28,"t":3,"w":1,"\"":28,"\u201c":28,"\u201d":28,")":10,"]":10,".":7,"z":1}},"c":{"d":"76,-184v25,0,36,12,27,33v-37,-13,-58,-16,-61,65v-2,69,27,72,60,55v10,25,-4,35,-37,35v-34,0,-54,-14,-54,-90v0,-86,35,-98,65,-98","w":112,"k":{"\u2019":16,"\u2018":16,"\u2014":13,"\u2013":13,"\u00ff":-1,"\u00fd":-1,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"q":6,"\/":-6,"'":16,"d":6,"t":-2,"w":-1,"y":-1,"c":5,"e":6,"o":4,"\u00f8":4,"\"":16,"-":13,"\u201c":16,"\u201d":16,"\u00ab":10,")":3,"]":3}},"d":{"d":"93,-28r0,-125v-32,-14,-49,-3,-49,66v0,68,14,70,49,59xm93,-176r0,-75v0,-13,5,-14,29,-14r0,258v-54,17,-112,31,-110,-77v2,-84,32,-116,81,-92","w":138,"k":{"\u00ef":-5,"\u00ee":-5,"\u00ec":-5,"\/":-2}},"e":{"d":"75,-184v47,0,52,61,42,105v-25,5,-59,6,-76,6v-2,61,41,53,75,37v10,31,-9,40,-47,40v-33,0,-58,-15,-58,-85v0,-90,32,-103,64,-103xm72,-158v-15,0,-28,12,-30,61v14,0,35,0,48,-4v4,-22,3,-62,-18,-57","w":129,"k":{"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-2,"'":22,"t":1,"w":1,"e":4,"\"":22,"\u201c":22,"\u201d":22,")":7,"]":7,"x":3}},"f":{"d":"29,-155r-25,0v-2,-34,5,-23,25,-25r0,-22v0,-56,34,-64,61,-64v32,0,38,10,30,31v-30,-7,-61,-11,-62,31r0,24r33,0v4,40,-11,20,-33,25r0,149v0,9,-20,5,-29,6r0,-155","w":91,"k":{"\u2122":-34,"\u2026":17,"\u2019":-44,"\u2018":-44,"\u2014":17,"\u2013":17,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f8":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":5,"\u00ae":-23,"\u00a9":-22,"r":3,"q":8,"m":1,"_":18,"]":-40,"\\":-36,"?":-40,"8":-7,",":17,"*":-12,"'":-44,"&":-13,"!":-31,"d":8,"u":3,"c":5,"e":7,"o":6,"\"":-44,"-":17,"\u201c":-44,"\u201d":-44,"\u00ab":8,"b":-1,")":-40,".":17,"g":7,"p":12,"h":-1,"k":-1}},"g":{"d":"14,-118v1,-76,53,-66,121,-63v7,12,1,33,-20,24v33,38,7,121,-61,100v-5,5,-9,11,-9,16v0,6,18,8,42,11v28,4,48,14,48,42v0,31,-21,59,-69,59v-79,0,-66,-58,-31,-83v-35,-10,-23,-34,1,-52v-17,-11,-22,-31,-22,-54xm73,-162v-15,0,-28,12,-28,44v0,26,5,40,27,40v19,0,27,-16,27,-47v0,-26,-9,-37,-26,-37xm105,16v0,-18,-18,-21,-47,-24v-19,15,-39,53,10,52v26,0,37,-15,37,-28","w":141,"k":{"\u2019":15,"\u2018":15,"\u00ff":-2,"\u00fd":-2,"\u00f8":3,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00eb":2,"\u00ea":2,"\u00e9":2,"\u00e8":2,"\u00e7":3,"q":2,"\/":-3,"'":15,"d":2,"y":-2,"c":3,"e":2,"o":3,"\"":15,"\u201c":15,"\u201d":15,"x":3,"z":-1,"j":-33,"\u00df":3}},"h":{"d":"16,0r0,-251v0,-13,5,-14,29,-14r0,95v29,-25,78,-19,78,34r0,130v0,6,-1,6,-30,6r0,-128v4,-30,-28,-37,-48,-19r0,141v0,6,0,6,-29,6","w":136,"k":{"\u201d":32,"\u201c":32,"y":4,"w":1,"t":3,"\"":32,"\u2019":32,"\u2018":32,"\u00ff":4,"\u00fd":4,"\/":-5,"'":32,")":10,"]":10,"x":1}},"i":{"d":"46,-180r0,174v0,6,1,6,-29,6r0,-167v0,-13,5,-13,29,-13xm17,-237v0,-13,5,-22,17,-22v11,0,14,6,14,21v0,15,-5,23,-16,23v-9,0,-15,-5,-15,-22","w":63,"k":{"\/":-8}},"j":{"d":"49,-180r0,193v0,32,-9,58,-48,58v-36,0,-45,-14,-33,-35v21,13,51,16,51,-28r0,-175v0,-13,6,-13,30,-13xm19,-237v0,-13,5,-22,17,-22v11,0,14,6,14,21v0,15,-6,23,-17,23v-9,0,-14,-5,-14,-22","w":66,"k":{"\/":-9,"j":-21}},"k":{"d":"17,0r0,-251v0,-13,5,-14,29,-14r0,98v21,-22,76,-26,76,14v0,30,-21,49,-30,56v23,8,41,49,35,91v-1,6,-1,6,-33,6v6,-44,-10,-103,-48,-75r0,69v0,6,1,6,-29,6xm89,-143v0,-25,-32,-13,-43,3r0,45v25,-10,43,-25,43,-48","w":137,"k":{"\u2019":27,"\u2018":27,"\u2014":7,"\u2013":7,"\u00ff":7,"\u00fd":7,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00eb":3,"\u00ea":3,"\u00e9":3,"\u00e8":3,"\u00e7":3,"q":3,"\/":-5,"'":27,"w":4,"y":7,"c":3,"e":3,"o":3,"\u00f8":3,"\"":27,"-":7,"\u201c":27,"\u201d":27,")":3,"]":3,"p":3}},"l":{"d":"46,-265r0,259v0,6,0,6,-29,6r0,-251v0,-13,6,-14,29,-14","w":62},"m":{"d":"88,0r0,-140v3,-24,-27,-20,-42,-12r0,146v0,6,-1,6,-29,6r0,-172v24,-11,68,-20,86,0v34,-21,97,-17,85,39r0,127v0,6,-1,6,-29,6r0,-133v3,-30,-24,-29,-42,-18r0,145v0,6,1,6,-29,6","w":202,"k":{"\u201d":32,"\u201c":32,"y":2,"x":1,"w":1,"f":1,"]":10,")":10,"\"":32,"\u2019":32,"\u2018":32,"\u00ff":2,"\u00fd":2,"\/":-8,"'":32}},"n":{"d":"16,0r0,-171v36,-17,108,-26,108,36r0,129v0,6,0,6,-30,6r0,-127v4,-37,-26,-34,-49,-25r0,146v0,6,-1,6,-29,6","w":137,"k":{"\u2019":32,"\u2018":32,"\/":-11,"'":32,"\"":32,"\u201c":32,"\u201d":32,")":10,"]":10,"x":1}},"o":{"d":"9,-90v0,-66,21,-94,59,-94v38,0,56,20,56,93v0,67,-20,95,-59,95v-37,0,-56,-13,-56,-94xm40,-89v0,59,9,68,26,68v15,0,27,-14,27,-70v0,-57,-9,-67,-26,-67v-16,0,-27,13,-27,69","w":132,"k":{"\u2026":7,"\u2019":30,"\u2018":30,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"_":16,"\/":-6,",":7,"*":4,"'":30,"f":4,"t":5,"v":4,"w":4,"y":7,"\"":30,"\u201c":30,"\u201d":30,")":12,"]":12,".":7,"x":9,"z":3}},"p":{"d":"17,58r0,-227v48,-26,111,-26,111,60v0,97,-30,113,-54,113v-13,0,-23,-5,-28,-10r0,74v-11,4,-29,7,-29,-10xm46,-151r0,116v5,8,12,12,19,12v11,0,30,-7,30,-82v0,-57,-20,-60,-49,-46","w":137,"k":{"\u2026":7,"\u2019":35,"\u2018":35,"\u00ff":8,"\u00fd":8,"\u00fc":4,"\u00fb":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":4,"\u00ea":4,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"_":21,"?":2,"\/":-2,",":7,"*":4,"'":35,"f":3,"t":4,"v":4,"w":4,"y":8,"\"":35,"\u201c":35,"\u201d":35,")":12,"]":12,".":7,"x":5,"a":3,"z":4,"j":1}},"q":{"d":"123,-172r0,231v4,15,-17,12,-29,11r0,-82v-7,10,-18,16,-34,16v-23,0,-49,-11,-49,-82v-1,-99,54,-124,112,-94xm94,-40r0,-113v-35,-15,-49,5,-50,74v0,68,30,70,50,39","w":140,"k":{"\u201d":23,"\u201c":23,"\"":23,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"r":{"d":"16,0r0,-167v14,-10,31,-17,49,-17v27,0,29,13,22,33v-13,-8,-29,-6,-41,4r0,141v0,6,-1,6,-30,6","w":94,"k":{"\u2026":27,"\u2019":14,"\u2018":14,"\u2014":26,"\u2013":26,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":7,"r":1,"q":8,"_":32,"\/":4,",":27,"'":14,"d":8,"c":7,"e":8,"o":7,"\"":14,"-":26,"\u201c":14,"\u201d":14,"\u00ab":17,")":9,"]":9,".":27,"x":5,"g":8,"p":3}},"s":{"d":"70,-184v46,0,52,15,39,35v-16,-11,-63,-15,-64,8v7,34,69,50,69,95v0,32,-22,50,-59,50v-36,0,-54,-10,-39,-36v18,13,66,15,65,-13v-2,-40,-71,-55,-70,-96v0,-25,19,-43,59,-43","w":124,"k":{"\u2019":20,"\u2018":20,"\u2014":12,"\u2013":12,"\u00ff":1,"\u00fd":1,"\/":-3,"'":20,"y":1,"\"":20,"-":12,"\u201c":20,"\u201d":20,")":3,"]":3,"x":3}},"t":{"d":"31,-50r0,-105r-25,0v-1,-34,4,-23,25,-25v7,-30,-22,-74,29,-65r0,65r37,0v5,42,-14,19,-37,25r0,105v-5,28,16,34,34,23v8,19,-7,31,-28,31v-31,0,-35,-22,-35,-54","w":104,"k":{"\u2026":-2,"\u2019":12,"\u2018":12,"\u2014":23,"\u2013":23,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":8,"q":6,"0":2,"\/":-5,",":-2,"'":12,"d":6,"t":19,"u":3,"c":8,"e":8,"o":6,"\u00f8":6,"\"":12,"-":23,"\u201c":12,"\u201d":12,"\u00ab":12,")":3,"]":3,".":-2,"g":4}},"u":{"d":"123,-180r0,171v-14,8,-34,13,-53,13v-85,4,-45,-108,-54,-178v0,-6,0,-6,30,-6r0,126v-3,35,24,38,48,26r0,-146v0,-6,0,-6,29,-6","w":140,"k":{"\u2019":23,"\u2018":23,"\/":-6,"'":23,"\"":23,"\u201c":23,"\u201d":23,")":11,"]":11}},"v":{"d":"43,-15r-37,-156v-2,-9,0,-9,32,-9r26,149v0,-9,15,-114,23,-143v1,-6,1,-6,31,-6r-41,181v-18,2,-29,3,-34,-16","w":123,"k":{"\u2026":18,"\u2019":21,"\u2018":21,"\u2014":9,"\u2013":9,"\u00ff":4,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":6,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":8,"m":5,"k":3,"_":27,"@":4,"0":3,"\/":8,",":18,"'":21,"d":8,"t":3,"u":5,"c":6,"e":9,"o":7,"\u00f8":7,"\"":21,"-":9,"\u201c":21,"\u201d":21,")":10,"]":10,".":18,"a":4,"g":9,":":2,";":2,"p":5,"s":4}},"w":{"d":"5,-174v-1,-6,2,-6,32,-6v10,47,12,102,26,146r21,-135v0,-10,19,-5,29,-6v10,46,13,99,27,141v2,-40,13,-100,21,-140v1,-6,1,-6,28,-6v0,0,-38,181,-39,181v-10,2,-31,3,-34,-18r-17,-113v-4,36,-13,94,-22,131v-11,1,-38,5,-37,-16","w":194,"k":{"\u2026":14,"\u2019":23,"\u2018":23,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":8,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":21,"@":2,"\/":2,",":14,"'":23,"d":6,"t":3,"u":5,"c":8,"e":9,"o":7,"\"":23,"-":7,"\u201c":23,"\u201d":23,")":13,"]":13,".":14,"x":4,"a":4,"z":5,"g":9,":":3,";":3,"p":5,"s":4}},"x":{"d":"139,-180r-46,84r48,89v3,7,2,7,-33,7v-12,-21,-28,-51,-36,-72v-8,17,-21,48,-33,66v-3,6,-7,6,-34,6r51,-94r-43,-81v-3,-5,-3,-5,30,-5v12,18,26,48,33,66v6,-14,19,-45,30,-61v3,-5,3,-5,33,-5","w":147,"k":{"\u2019":17,"\u2018":17,"\u2014":27,"\u2013":27,"\u00ff":4,"\u00fd":4,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f8":9,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":6,"q":9,"m":3,"k":5,"@":2,"0":2,"\/":-5,"'":17,"d":9,"f":4,"t":5,"u":3,"w":9,"y":4,"c":5,"e":8,"o":9,"\"":17,"-":27,"\u201c":17,"\u201d":17,")":7,"]":7,"x":3,"a":4,"z":3,"g":5,"p":4,"s":5}},"y":{"d":"52,6r-43,-178v-2,-8,-3,-8,28,-8v10,39,26,112,29,149v2,-27,18,-107,25,-140v2,-9,1,-9,31,-9r-44,190v-11,46,-24,59,-50,59v-32,0,-33,-12,-25,-30v26,11,42,10,49,-33","w":128,"k":{"\u2026":20,"\u2019":22,"\u2018":22,"\u2014":10,"\u2013":10,"\u00ff":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":9,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":19,"\/":11,",":20,"'":22,"d":6,"t":3,"u":5,"c":9,"e":8,"o":7,"\"":22,"-":10,"\u201c":22,"\u201d":22,")":13,"]":13,".":20,"x":3,"a":4,"z":3,"g":9,":":3,";":3,"p":5,"s":4}},"z":{"d":"18,-180r92,0v3,4,5,14,-1,23r-67,130v21,0,59,0,69,-4v2,13,3,31,-11,31r-88,0v-3,0,-8,-20,-2,-26r70,-129r-70,2v-1,-13,-4,-27,8,-27","w":120,"k":{"\u2019":17,"\u2018":17,"\u2014":13,"\u2013":13,"\u00ff":3,"\u00fd":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"q":6,"'":17,"d":6,"t":3,"u":5,"w":3,"y":3,"c":5,"e":6,"o":4,"\"":17,"-":13,"\u201c":17,"\u201d":17,")":9,"]":9,"x":5,"g":4,"p":3}},"|":{"d":"73,-293r0,358v0,7,-1,7,-29,7r0,-357v0,-8,0,-8,29,-8","w":116},"\u00a1":{"d":"57,-162v0,11,-7,21,-20,21v-15,0,-20,-8,-20,-21v0,-11,7,-21,20,-21v15,0,20,8,20,21xm51,-105r5,167v0,8,-6,9,-40,9r6,-163v1,-13,7,-13,29,-13","w":70,"k":{"j":-33,"\/":-11}},"\u00a2":{"d":"103,-225r0,42v23,6,24,9,18,33v-37,-12,-60,-14,-62,67v-3,73,28,65,62,51v7,23,-1,32,-26,35v-1,26,9,50,-27,45r0,-46v-24,-4,-38,-19,-38,-84v0,-70,22,-93,46,-99v1,-26,-7,-48,27,-44","k":{"\u201d":9,"\u201c":9,"]":11,")":11,"\"":9,"\u2019":9,"\u2018":9,"'":9}},"\u00a5":{"d":"60,0r0,-63r-46,0v-5,-36,21,-22,46,-25v1,-15,-4,-24,-7,-35r-39,0v-3,-29,10,-24,31,-24r-34,-100v-1,-5,-1,-5,33,-5r31,118v3,-25,23,-83,32,-113v2,-5,1,-5,31,-5r-34,105r32,0v4,34,-17,22,-40,24v-3,10,-7,20,-6,35r46,0v5,36,-21,22,-46,25r0,57v0,6,0,6,-30,6","k":{"\/":5}},"\u00a8":{"d":"0,-230v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm51,-230v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-18,-6,-18,-18","w":86},"\u00a9":{"d":"90,-240v15,0,19,4,14,17v-19,-5,-30,-8,-31,32v0,33,12,27,30,23v6,13,-1,18,-16,18v-21,0,-30,-4,-30,-41v0,-44,18,-49,33,-49xm13,-195v0,-54,27,-79,74,-79v47,0,70,21,70,79v0,51,-26,80,-73,80v-47,0,-71,-21,-71,-80xm35,-195v0,44,18,59,49,59v28,0,51,-17,51,-60v0,-40,-16,-57,-48,-57v-31,0,-52,14,-52,58","w":169,"k":{"\/":33}},"\u00ab":{"d":"6,-91v0,-13,53,-89,53,-89v12,0,17,15,17,15v0,14,-42,74,-42,74v0,0,43,61,43,74v0,0,-6,17,-17,17v0,0,-54,-78,-54,-91xm68,-90v0,-12,52,-82,52,-82v11,0,17,14,17,14v0,13,-41,68,-41,68v-1,8,74,69,25,81v0,0,-53,-68,-53,-81","w":149,"k":{"T":23,"V":9,"W":10,"Y":14,"\u00dd":14}},"\u00ae":{"d":"13,-195v0,-54,27,-79,74,-79v47,0,70,21,70,79v0,51,-26,80,-73,80v-47,0,-71,-21,-71,-80xm35,-195v0,44,18,59,49,59v28,0,51,-17,51,-60v0,-40,-16,-57,-48,-57v-31,0,-52,14,-52,58xm63,-239v21,-7,48,0,48,24v0,12,-5,20,-12,25v5,5,12,15,14,37v1,5,-9,2,-14,3v-6,-27,-4,-37,-22,-36v-5,15,13,41,-14,36r0,-89xm96,-216v1,-11,-7,-14,-19,-13r0,31v13,1,18,-2,19,-18","w":169,"k":{"\/":30}},"\u00b4":{"d":"11,-205v-6,0,-11,-16,-11,-16v28,-25,52,-68,62,-21v-6,7,-39,30,-51,37","w":61},"\u00b7":{"d":"19,-97v0,-11,7,-21,20,-21v15,0,20,9,20,21v0,12,-7,21,-20,21v-15,0,-20,-8,-20,-21","w":79},"\u00b8":{"d":"13,-1r17,0r-5,22v15,-1,22,3,24,23v3,28,-32,35,-49,26v0,0,2,-13,5,-15v4,-1,30,11,27,-9v4,-16,-21,-10,-26,-10","w":48},"\u00bb":{"d":"143,-91v0,13,-54,91,-54,91v0,0,-17,-5,-17,-17v0,-13,43,-74,43,-74v0,0,-42,-60,-42,-74v0,-10,17,-15,17,-15v0,0,53,76,53,89xm81,-90v0,13,-54,82,-54,82v0,0,-15,-5,-15,-17v0,-13,41,-65,41,-65v3,-4,-68,-75,-25,-83v0,0,53,71,53,83","w":149,"k":{"\u2014":-4,"\u2013":-4,"T":23,"V":11,"W":11,"Y":20,"\u00dd":20,"v":3,"w":1,"y":1,"\u00fd":1,"\u00ff":1,"-":-4,")":5,"]":5,"J":15,"X":10,"x":5,"z":9,"Z":3}},"\u00bf":{"d":"80,-162v0,11,-7,21,-20,21v-15,0,-20,-9,-20,-21v0,-12,7,-20,20,-20v15,0,20,7,20,20xm73,-110v23,42,-36,90,-36,123v0,37,46,30,59,19v14,29,-6,37,-41,38v-30,0,-50,-17,-50,-50v-1,-61,55,-71,42,-127v4,-4,18,-4,26,-3","w":110,"k":{"\u201d":22,"\u201c":22,"\u00c6":4,"j":-39,"]":-1,"A":4,")":-1,"\"":22,"\u2019":22,"\u2018":22,"\u00dc":4,"\u00db":4,"\u00d6":4,"\u00d5":4,"\u00d4":4,"\u00d1":4,"\u00cb":4,"\u00ca":4,"\u00c5":4,"\u00c4":4,"\u00c3":4,"\u00c2":4,"\u00c1":4,"\u00c0":4,"'":22}},"\u00c0":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120xm87,-278v-3,0,-45,-29,-51,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":157,"k":{"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\"":38,"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-6,"*":17,"'":38}},"\u00c1":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120xm73,-277v-6,0,-11,-16,-11,-16v27,-25,53,-69,61,-21v-6,7,-38,30,-50,37","w":157,"k":{"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\"":38,"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-4,"*":17,"'":38}},"\u00c2":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120xm73,-330v19,-10,40,32,50,44v0,5,-10,9,-20,9v0,0,-19,-19,-24,-28v0,0,-21,27,-27,27v-10,0,-16,-3,-19,-8","w":157,"k":{"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\"":38,"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-6,"*":17,"'":38}},"\u00c3":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120xm26,-297v12,-20,27,-27,40,-27v15,0,17,17,32,17v17,0,17,-13,23,-13v23,17,1,41,-29,41v-19,0,-18,-17,-31,-17v-13,0,-16,14,-21,14v-8,0,-14,-15,-14,-15","w":157,"k":{"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\"":38,"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-9,"*":17,"'":38}},"\u00c4":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120xm36,-302v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm87,-302v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-18,-6,-18,-18","w":157,"k":{"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\"":38,"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-4,"*":17,"'":38}},"\u00c5":{"d":"125,0r-15,-64r-62,0r-14,59v0,8,-20,6,-32,5r64,-248v2,-7,17,-5,25,-4r64,247v0,8,-17,6,-30,5xm79,-211v-4,34,-17,85,-25,120r50,0v-9,-35,-22,-85,-25,-120xm43,-309v0,-24,14,-36,36,-36v23,0,34,8,34,35v0,23,-13,36,-36,36v-22,0,-34,-8,-34,-35xm64,-309v0,9,4,15,13,15v9,0,15,-5,15,-16v0,-10,-4,-14,-12,-14v-10,0,-16,4,-16,15","w":157,"k":{"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\"":38,"\u2122":8,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-6,"*":17,"'":38}},"\u00c6":{"d":"151,-26r62,0v0,24,0,26,-6,26r-85,0r0,-64r-59,0r-25,59v-2,8,-20,6,-32,5r106,-247v1,-4,5,-5,9,-5r93,0v0,24,0,26,-5,26r-58,0r0,76r55,0v8,49,-28,19,-55,27r0,97xm122,-221v-13,45,-30,90,-48,130r48,0r0,-130","w":221,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"g":5,"e":5,"d":6,"c":2,"a":4,"-":10,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4}},"\u00c7":{"d":"82,-257v38,1,38,18,29,38v-43,-21,-67,-9,-69,102v-1,96,25,99,69,78v13,23,-1,40,-32,43r-3,17v15,-1,21,3,23,23v3,29,-32,34,-49,26v0,0,2,-13,5,-15v4,-1,30,11,27,-9v5,-16,-21,-10,-25,-10r6,-32v-30,-3,-52,-24,-52,-120v0,-123,39,-141,71,-141","w":122,"k":{"\u201d":-2,"\u201c":-2,"\u00f8":5,"z":1,"y":23,"x":5,"w":19,"v":21,"u":7,"t":7,"o":5,"f":9,"e":6,"d":4,"c":4,"a":4,"S":2,"O":8,"G":5,"C":4,".":-2,"-":30,"\"":-2,"\u2026":-2,"\u2019":-2,"\u2018":-2,"\u2014":30,"\u2013":30,"\u00ff":23,"\u00fd":23,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":4,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00c7":4,"q":4,"Q":8,"@":2,"0":9,"\/":-6,",":-2,"*":4,"'":-2,"\u00ab":8}},"\u00c8":{"d":"45,-26r62,0v0,24,0,26,-6,26r-85,0r0,-246v0,0,0,-6,6,-6r86,0v0,24,0,26,-5,26r-58,0r0,76r54,0v8,49,-27,19,-54,27r0,97xm74,-278v-3,0,-45,-29,-51,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":115,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"e":5,"d":6,"c":2,"a":4,"-":10,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4}},"\u00c9":{"d":"45,-26r62,0v0,24,0,26,-6,26r-85,0r0,-246v0,0,0,-6,6,-6r86,0v0,24,0,26,-5,26r-58,0r0,76r54,0v8,49,-27,19,-54,27r0,97xm60,-277v-6,0,-11,-16,-11,-16v28,-25,52,-68,62,-21v-6,7,-39,30,-51,37","w":115,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"e":5,"d":6,"c":2,"a":4,"-":10,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4}},"\u00ca":{"d":"45,-26r62,0v0,24,0,26,-6,26r-85,0r0,-246v0,0,0,-6,6,-6r86,0v0,24,0,26,-5,26r-58,0r0,76r54,0v8,49,-27,19,-54,27r0,97xm61,-330v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-18,-19,-23,-28v0,0,-21,27,-27,27v-10,0,-17,-3,-20,-8","w":115,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"\u00ab":4,"z":1,"y":5,"x":3,"w":5,"v":18,"u":3,"t":14,"s":2,"o":7,"f":8,"e":5,"d":6,"c":2,"b":2,"a":4,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":10,"\"":-4,"\u2122":8,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"r":3,"q":6,"\\":25,"Q":4,"7":7,"0":2,"\/":-8,"'":-4}},"\u00cb":{"d":"45,-26r62,0v0,24,0,26,-6,26r-85,0r0,-246v0,0,0,-6,6,-6r86,0v0,24,0,26,-5,26r-58,0r0,76r54,0v8,49,-27,19,-54,27r0,97xm23,-302v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm75,-302v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":115,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"\u00ab":4,"z":1,"y":5,"x":3,"w":5,"v":18,"u":3,"t":14,"s":2,"o":7,"f":8,"e":5,"d":6,"c":2,"b":2,"a":4,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":10,"\"":-4,"\u2122":8,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"r":3,"q":6,"\\":25,"Q":4,"7":7,"0":2,"\/":-13,"'":-4}},"\u00cc":{"d":"15,0r0,-239v0,-13,1,-13,30,-13r0,246v0,6,-1,6,-30,6xm39,-278v-3,0,-45,-29,-51,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":60,"k":{"\/":-4}},"\u00cd":{"d":"15,0r0,-239v0,-13,1,-13,30,-13r0,246v0,6,-1,6,-30,6xm25,-277v-6,0,-11,-16,-11,-16v27,-25,53,-69,61,-21v-6,7,-38,30,-50,37","w":60,"k":{"]":-1,")":-1,"\/":-4}},"\u00ce":{"d":"15,0r0,-239v0,-13,1,-13,30,-13r0,246v0,6,-1,6,-30,6xm25,-330v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-18,-19,-23,-28v0,0,-21,27,-27,27v-10,0,-16,-3,-19,-8","w":60,"k":{"\u201d":-19,"\u201c":-19,"]":-22,")":-22,"\"":-19,"\u2019":-19,"\u2018":-19,"\/":-4,"'":-19}},"\u00cf":{"d":"15,0r0,-239v0,-13,1,-13,30,-13r0,246v0,6,-1,6,-30,6xm-12,-302v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-17,-6,-17,-18xm39,-302v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-18,-6,-18,-18","w":60,"k":{"\u201d":-7,"\u201c":-7,"]":-4,")":-4,"\"":-7,"\u2019":-7,"\u2018":-7,"\/":-4,"'":-7}},"\u00d1":{"d":"116,0r-41,-99v-6,-16,-25,-74,-34,-102r4,195v0,6,-1,6,-30,6r0,-246v1,-10,19,-4,29,-6r40,97v7,19,25,74,34,101v-5,-62,-2,-130,-3,-192v0,-6,0,-6,29,-6r0,246v0,11,-18,4,-28,6xm30,-297v12,-20,27,-27,40,-27v15,0,17,17,32,17v17,0,17,-13,23,-13v23,17,1,41,-29,41v-19,0,-18,-17,-31,-17v-13,0,-16,14,-21,14v-8,0,-14,-15,-14,-15","w":159,"k":{"\u201d":-1,"\u201c":-1,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"\"":-1,"\u2122":8,"\u2019":-1,"\u2018":-1,"\u2014":7,"\u2013":7,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-13,"'":-1}},"\u00d2":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,99,-20,132,-68,132v-46,0,-65,-26,-65,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105xm87,-278v-3,0,-44,-29,-50,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-5,16,-12,16","w":154,"k":{"\u201d":4,"\u201c":4,"x":7,"c":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,")":7,"\"":4,"\u2026":12,"\u2019":4,"\u2018":4,"\u00e7":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":19,",":12,"*":3,"'":4}},"\u00d3":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,99,-20,132,-68,132v-46,0,-65,-26,-65,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105xm74,-277v-6,0,-11,-16,-11,-16v27,-25,53,-69,61,-21v-6,7,-38,30,-50,37","w":154,"k":{"\u201d":4,"\u201c":4,"x":7,"c":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,")":7,"\"":4,"\u2026":12,"\u2019":4,"\u2018":4,"\u00e7":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":19,",":12,"*":3,"'":4}},"\u00d4":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,99,-20,132,-68,132v-46,0,-65,-26,-65,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105xm75,-330v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-19,-19,-24,-28v0,0,-21,27,-27,27v-10,0,-16,-3,-19,-8","w":154,"k":{"\u201d":4,"\u201c":4,"\u00f8":5,"\u00ab":4,"y":17,"x":7,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"O":1,"J":12,"G":6,"C":9,"A":8,".":12,")":7,"\"":4,"\u2122":8,"\u2026":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":9,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":19,"\\":25,"Q":1,"7":7,"\/":3,",":12,"*":3,"'":4}},"\u00d5":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,99,-20,132,-68,132v-46,0,-65,-26,-65,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105xm27,-297v12,-20,27,-27,40,-27v15,0,17,17,32,17v17,0,17,-13,23,-13v23,17,1,41,-29,41v-19,0,-18,-17,-31,-17v-13,0,-16,14,-21,14v-8,0,-14,-15,-14,-15","w":154,"k":{"\u201d":4,"\u201c":4,"\u00f8":5,"\u00ab":4,"y":17,"x":7,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"O":1,"J":12,"G":6,"C":9,"A":8,".":12,")":7,"\"":4,"\u2122":8,"\u2026":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":9,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":19,"\\":25,"Q":1,"7":7,"\/":4,",":12,"*":3,"'":4}},"\u00d6":{"d":"11,-127v0,-96,23,-128,69,-128v47,0,64,29,64,126v0,99,-20,132,-68,132v-46,0,-65,-26,-65,-130xm44,-120v0,67,7,93,33,93v26,0,35,-28,35,-101v0,-72,-7,-97,-33,-97v-25,0,-35,27,-35,105xm37,-302v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm89,-302v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":154,"k":{"\u201d":4,"\u201c":4,"\u00f8":5,"\u00ab":4,"y":17,"x":7,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"O":1,"J":12,"G":6,"C":9,"A":8,".":12,")":7,"\"":4,"\u2122":8,"\u2026":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":9,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":19,"\\":25,"Q":1,"7":7,"\/":2,",":12,"*":3,"'":4}},"\u00d7":{"d":"125,-66v-27,35,-31,-3,-50,-16v-19,13,-23,51,-49,16r32,-35r-32,-36v26,-35,30,3,49,16v19,-13,24,-51,50,-16r-32,35","k":{"\/":6}},"\u00d8":{"d":"31,6v-29,-1,-14,-21,-5,-43v-6,-20,-9,-49,-9,-90v0,-96,21,-129,68,-129v18,0,32,5,42,17v4,-9,8,-17,9,-20v0,0,17,2,18,9v0,3,-7,27,-12,40v5,19,8,46,8,81v0,99,-20,133,-68,133v-19,0,-33,-5,-43,-17v-3,9,-7,17,-8,19xm50,-120v0,23,0,42,2,56r53,-151v-5,-7,-11,-11,-20,-11v-25,0,-35,28,-35,106xm118,-128v0,-24,-1,-42,-3,-57r-53,150v5,6,11,8,19,8v23,0,37,-15,37,-101","w":166,"k":{"\u201d":4,"\u201c":4,"z":7,"y":7,"x":7,"w":7,"u":5,"t":5,"s":5,"p":5,"h":3,"g":7,"e":7,"d":7,"c":2,"a":8,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,"-":7,")":7,"\"":4,"\u2026":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u00ff":9,"\u00fd":7,"\u00fc":7,"\u00fb":7,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f1":8,"\u00ef":8,"\u00ee":8,"\u00eb":9,"\u00ea":9,"\u00e9":7,"\u00e8":7,"\u00e7":2,"\u00e6":8,"\u00e5":8,"\u00e4":8,"\u00e3":8,"\u00e2":8,"\u00e1":8,"\u00e0":8,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"r":7,"q":5,"k":3,"_":19,"0":6,",":12,"*":3,"'":4}},"\u00d9":{"d":"46,-252r0,179v0,29,4,50,34,50v13,0,26,-4,32,-7r0,-216v0,-6,0,-6,29,-6r0,243v-9,6,-33,13,-61,13v-58,0,-65,-35,-65,-77r0,-173v0,-6,1,-6,31,-6xm87,-278v-3,0,-44,-29,-50,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-5,16,-12,16","w":157},"\u00da":{"d":"46,-252r0,179v0,29,4,50,34,50v13,0,26,-4,32,-7r0,-216v0,-6,0,-6,29,-6r0,243v-9,6,-33,13,-61,13v-58,0,-65,-35,-65,-77r0,-173v0,-6,1,-6,31,-6xm74,-277v-6,0,-11,-16,-11,-16v27,-25,53,-69,61,-21v-6,7,-38,30,-50,37","w":157},"\u00db":{"d":"46,-252r0,179v0,29,4,50,34,50v13,0,26,-4,32,-7r0,-216v0,-6,0,-6,29,-6r0,243v-9,6,-33,13,-61,13v-58,0,-65,-35,-65,-77r0,-173v0,-6,1,-6,31,-6xm75,-330v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-19,-19,-24,-28v0,0,-21,27,-27,27v-10,0,-16,-3,-19,-8","w":157,"k":{"\u201d":2,"\u201c":2,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"\"":2,"\u2122":8,"\u2019":2,"\u2018":2,"\u2014":7,"\u2013":7,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-8,"'":2}},"\u00dc":{"d":"46,-252r0,179v0,29,4,50,34,50v13,0,26,-4,32,-7r0,-216v0,-6,0,-6,29,-6r0,243v-9,6,-33,13,-61,13v-58,0,-65,-35,-65,-77r0,-173v0,-6,1,-6,31,-6xm37,-302v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm89,-302v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":157,"k":{"\u201d":5,"\u201c":5,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"\"":5,"\u2122":8,"\u2019":5,"\u2018":5,"\u2014":7,"\u2013":7,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-4,"'":5}},"\u00dd":{"d":"52,0r0,-102r-50,-145v-1,-5,-1,-5,33,-5v11,32,29,96,32,125v3,-26,21,-89,31,-120v2,-5,2,-5,32,-5r-49,148r0,98v0,6,1,6,-29,6xm62,-277v-6,0,-12,-16,-12,-16v27,-24,54,-69,62,-21v-6,7,-38,30,-50,37","w":131,"k":{"\u201d":-7,"\u201c":-7,"\u00f8":25,"\u00c6":28,"z":18,"y":16,"x":16,"w":15,"v":14,"u":21,"t":12,"s":24,"p":26,"o":25,"n":23,"j":10,"i":5,"g":24,"f":10,"e":27,"d":28,"c":25,"a":22,"S":3,"O":8,"J":31,"G":10,"C":12,"A":28,";":19,":":19,".":22,"-":23,"\"":-7,"\u2026":22,"\u2019":-7,"\u2018":-7,"\u2014":23,"\u2013":23,"\u00ff":16,"\u00fd":16,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":25,"\u00f5":25,"\u00f4":25,"\u00f3":25,"\u00f2":25,"\u00f1":23,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":25,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":28,"\u00db":28,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":28,"\u00cb":28,"\u00ca":28,"\u00c7":12,"\u00c5":28,"\u00c4":28,"\u00c3":28,"\u00c2":28,"\u00c1":28,"\u00c0":28,"r":23,"q":28,"m":23,"_":26,"Q":8,"@":5,"0":17,"\/":18,",":22,"'":-7,"\u00ab":21,"\u00bb":16}},"\u00df":{"d":"14,-1v9,-53,3,-136,3,-197v0,-39,23,-56,58,-56v53,0,72,27,72,52v0,33,-39,34,-39,57v0,23,56,42,56,95v0,33,-21,53,-54,53v-44,0,-50,-16,-35,-36v10,12,56,18,56,-16v0,-37,-55,-58,-55,-95v0,-32,40,-36,40,-58v0,-13,-13,-24,-39,-24v-23,0,-31,13,-31,45r2,165v7,22,-28,20,-34,15","w":167,"k":{"]":3,")":3,"\/":-3}},"\u00e0":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58xm72,-206v-3,0,-44,-29,-50,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-5,16,-12,16","w":127,"k":{"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e1":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58xm58,-205v-6,0,-11,-16,-11,-16v28,-25,52,-68,62,-21v-6,7,-39,30,-51,37","w":127,"k":{"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e2":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58xm59,-258v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-18,-19,-23,-28v0,0,-21,27,-27,27v-10,0,-17,-3,-20,-8","w":127,"k":{"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e3":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58xm11,-225v12,-20,28,-27,41,-27v15,0,16,17,31,17v17,0,18,-13,24,-13v23,17,1,41,-29,41v-19,0,-19,-17,-32,-17v-13,0,-16,14,-21,14v-8,0,-14,-15,-14,-15","w":127,"k":{"\u201d":30,"\u201c":30,"y":3,"x":3,"f":3,"]":9,")":9,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,"t":6}},"\u00e4":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58xm22,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-17,-6,-17,-18xm73,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":127,"k":{"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e5":{"d":"15,-147v-14,-36,13,-34,54,-37v39,-2,45,23,45,63v0,41,0,85,-2,112v-33,16,-105,32,-102,-42v2,-63,35,-65,75,-54v1,-24,4,-50,-23,-50v-18,0,-37,4,-47,8xm85,-85v-24,-6,-42,-7,-44,33v-2,37,25,34,43,25v1,-12,1,-39,1,-58xm29,-237v0,-24,14,-36,36,-36v23,0,33,8,33,35v0,23,-12,36,-35,36v-22,0,-34,-8,-34,-35xm50,-237v0,9,4,15,13,15v9,0,15,-5,15,-16v0,-10,-5,-14,-13,-14v-10,0,-15,4,-15,15","w":127,"k":{"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,")":9,"]":9}},"\u00e6":{"d":"15,-148v-13,-36,11,-36,56,-36v19,0,30,7,35,21v29,-39,90,-25,90,37v0,16,-1,34,-4,47v-24,3,-57,2,-75,-2v-6,78,39,57,74,45v11,32,-3,37,-47,39v-15,0,-26,-2,-35,-10v-35,13,-102,30,-99,-47v2,-64,35,-68,75,-56v2,-25,1,-47,-25,-47v-18,0,-33,3,-45,9xm85,-27r0,-63v-25,-7,-42,-5,-44,36v-2,42,25,36,44,27xm147,-158v-14,0,-27,12,-30,54v12,3,33,6,49,3v2,-23,4,-63,-19,-57","w":209,"k":{"\u201d":22,"\u201c":22,"z":1,"y":3,"x":3,"t":1,"f":3,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-2,"'":22,"w":1,"e":4}},"\u00e7":{"d":"76,-184v25,0,36,12,27,33v-37,-13,-58,-16,-61,65v-2,69,27,72,60,55v9,22,-1,30,-29,34r-3,18v15,-1,22,3,24,23v3,28,-32,35,-49,26v0,0,1,-13,4,-15v0,0,31,11,28,-9v4,-16,-21,-10,-26,-10r6,-33v-30,-2,-46,-19,-46,-89v0,-86,35,-98,65,-98","w":112,"k":{"\u201d":16,"\u201c":16,"\u00f8":4,"y":-1,"w":-1,"t":-2,"o":4,"e":6,"d":6,"c":5,"]":3,"-":13,")":3,"\"":16,"\u2019":16,"\u2018":16,"\u2014":13,"\u2013":13,"\u00ff":-1,"\u00fd":-1,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"q":6,"\/":-6,"'":16,"\u00ab":10}},"\u00e8":{"d":"75,-184v47,0,52,61,42,105v-25,5,-59,6,-76,6v-2,61,41,53,75,37v10,31,-9,40,-47,40v-33,0,-58,-15,-58,-85v0,-90,32,-103,64,-103xm72,-158v-15,0,-28,12,-30,61v14,0,35,0,48,-4v4,-22,3,-62,-18,-57xm80,-206v-3,0,-44,-29,-50,-36v1,-9,6,-22,13,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":129,"k":{"\u201d":22,"\u201c":22,"e":4,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22,"t":1,"w":1,"x":3}},"\u00e9":{"d":"75,-184v47,0,52,61,42,105v-25,5,-59,6,-76,6v-2,61,41,53,75,37v10,31,-9,40,-47,40v-33,0,-58,-15,-58,-85v0,-90,32,-103,64,-103xm72,-158v-15,0,-28,12,-30,61v14,0,35,0,48,-4v4,-22,3,-62,-18,-57xm66,-205v-6,0,-11,-16,-11,-16v27,-25,53,-69,61,-21v-6,7,-38,30,-50,37","w":129,"k":{"\u201d":22,"\u201c":22,"x":3,"w":1,"t":1,"e":4,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22}},"\u00ea":{"d":"75,-184v47,0,52,61,42,105v-25,5,-59,6,-76,6v-2,61,41,53,75,37v10,31,-9,40,-47,40v-33,0,-58,-15,-58,-85v0,-90,32,-103,64,-103xm72,-158v-15,0,-28,12,-30,61v14,0,35,0,48,-4v4,-22,3,-62,-18,-57xm67,-258v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-19,-19,-24,-28v0,0,-21,27,-27,27v-10,0,-16,-3,-19,-8","w":129,"k":{"\u201d":22,"\u201c":22,"y":3,"x":3,"w":1,"t":1,"e":4,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22}},"\u00eb":{"d":"75,-184v47,0,52,61,42,105v-25,5,-59,6,-76,6v-2,61,41,53,75,37v10,31,-9,40,-47,40v-33,0,-58,-15,-58,-85v0,-90,32,-103,64,-103xm72,-158v-15,0,-28,12,-30,61v14,0,35,0,48,-4v4,-22,3,-62,-18,-57xm29,-230v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm81,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":129,"k":{"\u201d":22,"\u201c":22,"y":3,"x":3,"w":1,"t":1,"e":4,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22}},"\u00ec":{"d":"46,-180r0,174v0,6,1,6,-29,6r0,-167v0,-13,5,-13,29,-13xm40,-206v-3,0,-44,-29,-50,-36v1,-9,6,-22,13,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":63,"k":{"\u201d":5,"\u201c":5,"]":6,")":6,"\"":5,"\u2019":5,"\u2018":5,"\/":-8,"'":5}},"\u00ed":{"d":"46,-180r0,174v0,6,1,6,-29,6r0,-167v0,-13,5,-13,29,-13xm26,-205v-6,0,-11,-16,-11,-16v28,-25,52,-68,62,-21v-6,7,-39,30,-51,37","w":63,"k":{"\u201d":-13,"\u201c":-13,"k":-2,"h":-2,"]":-5,")":-5,"\"":-13,"\u2019":-13,"\u2018":-13,"\/":-8,"'":-13}},"\u00ee":{"d":"46,-180r0,174v0,6,1,6,-29,6r0,-167v0,-13,5,-13,29,-13xm27,-258v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-18,-19,-23,-28v0,0,-21,27,-27,27v-10,0,-17,-3,-20,-8","w":63,"k":{"\u201d":-15,"\u201c":-15,"y":3,"x":3,"k":-5,"h":-5,"\"":-15,"\u2019":-15,"\u2018":-15,"\u00ff":3,"\u00fd":3,"\/":-8,"'":-15}},"\u00ef":{"d":"46,-180r0,174v0,6,1,6,-29,6r0,-167v0,-13,5,-13,29,-13xm-10,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-17,-6,-17,-18xm41,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":63,"k":{"\u201d":-21,"\u201c":-21,"y":3,"x":3,"k":-7,"h":-7,"]":-5,")":-5,"\"":-21,"\u2019":-21,"\u2018":-21,"\u00ff":3,"\u00fd":3,"\/":-8,"'":-21}},"\u00f1":{"d":"16,0r0,-171v36,-17,108,-26,108,36r0,129v0,6,0,6,-30,6r0,-127v4,-37,-26,-34,-49,-25r0,146v0,6,-1,6,-29,6xm18,-225v12,-20,28,-27,41,-27v15,0,16,17,31,17v17,0,18,-13,24,-13v23,17,1,41,-29,41v-19,0,-18,-17,-31,-17v-13,0,-17,14,-22,14v-8,0,-14,-15,-14,-15","w":137,"k":{"\u201d":32,"\u201c":32,"y":3,"x":1,"]":10,")":10,"\"":32,"\u2019":32,"\u2018":32,"\u00ff":3,"\u00fd":3,"\/":-11,"'":32}},"\u00f2":{"d":"9,-90v0,-66,21,-94,59,-94v38,0,56,20,56,93v0,67,-20,95,-59,95v-37,0,-56,-13,-56,-94xm40,-89v0,59,9,68,26,68v15,0,27,-14,27,-70v0,-57,-9,-67,-26,-67v-16,0,-27,13,-27,69xm76,-206v-3,0,-45,-29,-51,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":132,"k":{"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\"":30,"\u2026":7,"\u2019":30,"\u2018":30,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f3":{"d":"9,-90v0,-66,21,-94,59,-94v38,0,56,20,56,93v0,67,-20,95,-59,95v-37,0,-56,-13,-56,-94xm40,-89v0,59,9,68,26,68v15,0,27,-14,27,-70v0,-57,-9,-67,-26,-67v-16,0,-27,13,-27,69xm62,-205v-6,0,-11,-16,-11,-16v27,-25,53,-69,61,-21v-6,7,-38,30,-50,37","w":132,"k":{"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\"":30,"\u2026":7,"\u2019":30,"\u2018":30,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f4":{"d":"9,-90v0,-66,21,-94,59,-94v38,0,56,20,56,93v0,67,-20,95,-59,95v-37,0,-56,-13,-56,-94xm40,-89v0,59,9,68,26,68v15,0,27,-14,27,-70v0,-57,-9,-67,-26,-67v-16,0,-27,13,-27,69xm63,-258v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-19,-19,-24,-28v0,0,-21,27,-27,27v-10,0,-16,-3,-19,-8","w":132,"k":{"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\"":30,"\u2026":7,"\u2019":30,"\u2018":30,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f5":{"d":"9,-90v0,-66,21,-94,59,-94v38,0,56,20,56,93v0,67,-20,95,-59,95v-37,0,-56,-13,-56,-94xm40,-89v0,59,9,68,26,68v15,0,27,-14,27,-70v0,-57,-9,-67,-26,-67v-16,0,-27,13,-27,69xm15,-225v12,-20,27,-27,40,-27v15,0,17,17,32,17v17,0,17,-13,23,-13v6,0,11,16,11,16v-2,4,-18,25,-40,25v-19,0,-18,-17,-31,-17v-13,0,-16,14,-21,14v-8,0,-14,-15,-14,-15","w":132,"k":{"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\"":30,"\u2026":7,"\u2019":30,"\u2018":30,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f6":{"d":"9,-90v0,-66,21,-94,59,-94v38,0,56,20,56,93v0,67,-20,95,-59,95v-37,0,-56,-13,-56,-94xm40,-89v0,59,9,68,26,68v15,0,27,-14,27,-70v0,-57,-9,-67,-26,-67v-16,0,-27,13,-27,69xm25,-230v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm77,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":132,"k":{"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\"":30,"\u2026":7,"\u2019":30,"\u2018":30,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f7":{"d":"132,-89r-120,0v0,-18,0,-25,6,-25r120,0v0,18,0,25,-6,25xm57,-47v0,-10,7,-19,18,-19v13,0,18,8,18,19v0,10,-6,18,-18,18v-13,0,-18,-7,-18,-18xm57,-154v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-6,19,-18,19v-13,0,-18,-7,-18,-19"},"\u00f8":{"d":"22,9v-26,-5,-12,-22,0,-42v-4,-14,-5,-32,-5,-57v0,-66,22,-94,60,-94v17,0,30,5,39,16v9,-19,16,-27,29,-8v0,3,-9,21,-17,34v3,13,5,30,5,51v0,67,-20,95,-58,95v-18,0,-32,-3,-42,-14v-5,9,-10,17,-11,19xm101,-91v0,-10,0,-19,-1,-27r-46,82v4,13,12,15,21,15v15,0,26,-14,26,-70xm49,-89v0,10,0,18,1,25r45,-81v-4,-10,-10,-13,-19,-13v-16,0,-27,13,-27,69","w":148,"k":{"\u201d":30,"\u201c":30,"y":7,"x":9,"w":4,"t":5,"g":5,"f":4,"a":2,"]":12,")":12,"\"":30,"\u2026":7,"\u2019":30,"\u2018":30,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"_":16,"\/":-6,",":7,"*":4,"'":30,"v":4,"\u00ff":7,".":7,"z":3}},"\u00f9":{"d":"123,-180r0,171v-14,8,-34,13,-53,13v-85,4,-45,-108,-54,-178v0,-6,0,-6,30,-6r0,126v-3,35,24,38,48,26r0,-146v0,-6,0,-6,29,-6xm79,-206v-3,0,-45,-29,-51,-36v1,-9,7,-22,14,-22v3,0,40,31,48,42v0,0,-4,16,-11,16","w":140,"k":{"\u201d":23,"\u201c":23,"]":11,")":11,"\"":23,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"\u00fa":{"d":"123,-180r0,171v-14,8,-34,13,-53,13v-85,4,-45,-108,-54,-178v0,-6,0,-6,30,-6r0,126v-3,35,24,38,48,26r0,-146v0,-6,0,-6,29,-6xm65,-205v-6,0,-11,-16,-11,-16v28,-25,52,-68,62,-21v-6,7,-39,30,-51,37","w":140,"k":{"\u201d":23,"\u201c":23,"]":11,")":11,"\"":23,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"\u00fb":{"d":"123,-180r0,171v-14,8,-34,13,-53,13v-85,4,-45,-108,-54,-178v0,-6,0,-6,30,-6r0,126v-3,35,24,38,48,26r0,-146v0,-6,0,-6,29,-6xm66,-258v18,-9,40,33,50,44v0,5,-11,9,-21,9v0,0,-18,-19,-23,-28v0,0,-21,27,-27,27v-10,0,-17,-3,-20,-8","w":140,"k":{"\u201d":23,"\u201c":23,"y":3,"x":3,"]":11,")":11,"\"":23,"\u2019":23,"\u2018":23,"\u00ff":3,"\u00fd":3,"\/":-6,"'":23}},"\u00fc":{"d":"123,-180r0,171v-14,8,-34,13,-53,13v-85,4,-45,-108,-54,-178v0,-6,0,-6,30,-6r0,126v-3,35,24,38,48,26r0,-146v0,-6,0,-6,29,-6xm28,-230v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-18,-6,-18,-18xm80,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-17,-6,-17,-18","w":140,"k":{"\u201d":23,"\u201c":23,"y":3,"x":3,"]":11,")":11,"\"":23,"\u2019":23,"\u2018":23,"\u00ff":3,"\u00fd":3,"\/":-6,"'":23}},"\u00fd":{"d":"52,6r-43,-178v-2,-8,-3,-8,28,-8v10,39,26,112,29,149v2,-27,18,-107,25,-140v2,-9,1,-9,31,-9r-44,190v-11,46,-24,59,-50,59v-32,0,-33,-12,-25,-30v26,11,42,10,49,-33xm60,-205v-6,0,-11,-16,-11,-16v27,-24,54,-69,62,-21v-6,7,-39,30,-51,37","w":128,"k":{"\u201d":22,"\u201c":22,"z":3,"x":3,"u":5,"t":3,"s":4,"p":5,"o":7,"g":9,"e":8,"d":6,"c":9,"a":4,".":20,"-":10,"\"":22,"\u2026":20,"\u2019":22,"\u2018":22,"\u2014":10,"\u2013":10,"\u00ff":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":9,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":19,"\/":11,",":20,"'":22,")":13,"]":13,":":3,";":3}},"\u00ff":{"d":"52,6r-43,-178v-2,-8,-3,-8,28,-8v10,39,26,112,29,149v2,-27,18,-107,25,-140v2,-9,1,-9,31,-9r-44,190v-11,46,-24,59,-50,59v-32,0,-33,-12,-25,-30v26,11,42,10,49,-33xm24,-230v0,-10,6,-18,17,-18v13,0,18,7,18,18v0,10,-7,18,-18,18v-13,0,-17,-6,-17,-18xm75,-230v0,-10,7,-18,18,-18v13,0,18,7,18,18v0,10,-6,18,-18,18v-13,0,-18,-6,-18,-18","w":128,"k":{"\u201d":22,"\u201c":22,"z":3,"y":3,"x":3,"u":5,"t":3,"s":4,"p":5,"o":7,"g":9,"e":8,"d":6,"c":9,"a":4,"]":13,".":20,"-":10,")":13,"\"":22,"\u2026":20,"\u2019":22,"\u2018":22,"\u2014":10,"\u2013":10,"\u00ff":3,"\u00fd":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":9,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":19,"\/":11,",":20,"'":22,":":3,";":3}},"\u2013":{"d":"133,-89r-120,0v0,-18,0,-25,6,-25r120,0v0,18,0,25,-6,25","w":152,"k":{"\u00bb":11,"z":22,"y":12,"x":27,"w":7,"v":9,"t":10,"f":11,"]":11,"Z":17,"Y":23,"X":23,"W":10,"V":13,"T":38,"S":33,"J":44,"A":12,")":11,"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00dc":9,"\u00db":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d1":9,"\u00cb":9,"\u00ca":9,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30}},"\u2014":{"d":"244,-89r-242,0v0,-18,0,-25,6,-25r242,0v0,18,0,25,-6,25","w":252,"k":{"\u00bb":11,"z":22,"y":12,"x":27,"w":7,"v":9,"t":10,"f":11,"]":11,"Z":17,"Y":23,"X":23,"W":10,"V":13,"T":38,"S":33,"J":44,"A":12,")":11,"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00dc":9,"\u00db":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d1":9,"\u00cb":9,"\u00ca":9,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30}},"\u2018":{"d":"42,-243v14,9,9,37,-10,36v-13,0,-20,-7,-20,-21v0,-31,21,-76,39,-50v-8,14,-8,25,-9,35","w":63,"k":{"z":25,"y":26,"x":23,"w":25,"v":25,"u":26,"t":6,"s":33,"p":36,"o":33,"n":35,"g":39,"f":16,"e":37,"d":40,"c":34,"a":26,"]":-7,"[":28,"Y":-7,"W":-6,"V":-6,"T":-5,"O":7,"J":48,"G":13,"C":20,"A":43,")":-7,"(":28,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8}},"\u2019":{"d":"21,-249v-15,-8,-8,-36,10,-36v13,0,20,6,20,21v0,31,-21,76,-39,50v8,-14,8,-25,9,-35","w":63,"k":{"z":25,"y":26,"x":23,"w":25,"v":25,"u":26,"t":6,"s":33,"p":36,"o":33,"n":35,"g":39,"f":16,"e":37,"d":40,"c":34,"a":26,"]":-7,"[":28,"Y":-7,"W":-6,"V":-6,"T":-5,"O":7,"J":48,"G":13,"C":20,"A":43,")":-7,"(":28,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8}},"\u201c":{"d":"42,-243v14,9,9,37,-10,36v-13,0,-20,-7,-20,-21v0,-31,21,-76,39,-50v-8,14,-8,25,-9,35xm96,-243v15,9,8,37,-10,36v-13,0,-20,-7,-20,-21v0,-31,22,-76,39,-50v-8,14,-8,25,-9,35","w":117,"k":{"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8,"C":20,"G":13,"T":-5,"V":-6,"W":-6,"Y":-7,"d":40,"f":16,"t":6,"u":26,"v":25,"w":25,"y":26,"c":34,"e":37,"o":33,"O":7,")":-7,"]":-7,"A":43,"J":48,"x":23,"a":26,"z":25,"g":39,"n":35,"p":36,"s":33,"(":28,"[":28}},"\u201d":{"d":"75,-249v-14,-8,-9,-36,10,-36v13,0,20,6,20,21v0,30,-22,76,-38,50v7,-14,7,-25,8,-35xm21,-249v-15,-8,-8,-36,10,-36v13,0,20,6,20,21v0,31,-21,76,-39,50v8,-14,8,-25,9,-35","w":117,"k":{"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8,"C":20,"G":13,"T":-5,"V":-6,"W":-6,"Y":-7,"d":40,"f":16,"t":6,"u":26,"v":25,"w":25,"y":26,"c":34,"e":37,"o":33,"O":7,")":-7,"]":-7,"A":43,"J":48,"x":23,"a":26,"z":25,"g":39,"n":35,"p":36,"s":33,"(":28,"[":28}},"\u2026":{"d":"13,-18v0,-11,7,-21,20,-21v15,0,20,9,20,21v0,12,-7,20,-20,20v-15,0,-20,-7,-20,-20xm74,-18v0,-11,7,-21,20,-21v15,0,20,9,20,21v0,12,-7,20,-20,20v-15,0,-20,-7,-20,-20xm135,-18v0,-11,7,-21,20,-21v15,0,20,9,20,21v0,12,-7,20,-20,20v-15,0,-20,-7,-20,-20","w":187,"k":{"\u00f8":7,"y":17,"w":12,"v":16,"u":9,"t":17,"o":7,"f":14,"e":7,"d":7,"c":3,"Y":22,"W":11,"V":17,"U":3,"T":32,"O":10,"G":5,"C":11,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"\/":-3}},"\u2122":{"d":"91,-138r0,-111v0,-4,9,-3,14,-3r23,65v8,-21,12,-47,23,-65r12,0r0,111v0,3,0,3,-15,3r3,-81v-7,19,-12,40,-21,57r-8,0r-19,-59v2,11,4,59,3,80v0,3,-1,3,-15,3xm82,-252v4,21,-15,13,-27,14r0,97v0,3,0,3,-15,3r0,-100r-29,0v0,-5,-1,-14,3,-14r68,0","w":181,"k":{"\/":28}},"\u00d0":{"d":"16,-245v1,-13,30,-7,44,-7v47,0,71,25,71,110v0,133,-23,148,-115,142r0,-119r-15,0v1,-23,-1,-28,15,-26r0,-100xm98,-142v0,-77,-8,-85,-53,-83r0,80r28,0v4,33,-5,25,-28,26r0,91r16,0v19,0,37,-14,37,-114","w":141},"\u00b9":{"d":"21,-216v-19,-34,48,-40,68,-39r0,123r31,0v2,11,3,28,-7,28r-95,0v-3,-12,-5,-28,8,-28r33,0r0,-92","w":137},"\u00b3":{"d":"92,-150v-2,-19,-23,-21,-46,-20v-3,-6,-9,-24,6,-23v6,0,13,0,19,1v18,-13,21,-36,-10,-37v-14,0,-27,5,-37,12v-17,-33,14,-38,49,-39v53,-2,54,46,25,70v48,22,16,95,-39,86v-35,1,-53,-14,-36,-36v13,13,72,13,69,-14","w":137},"\u00b2":{"d":"14,-114v14,-43,69,-65,69,-93v0,-28,-46,-19,-59,-5v-21,-30,15,-44,50,-44v35,0,44,16,44,39v0,34,-37,61,-59,85r63,0v2,11,2,29,-8,28r-97,0v-1,-4,-3,-7,-3,-10","w":138},"\u00bd":{"d":"21,-216v-19,-34,48,-40,68,-39r0,123r31,0v2,11,3,28,-7,28r-95,0v-3,-12,-5,-28,8,-28r33,0r0,-92xm240,-245r-121,243v-6,12,-21,4,-29,-5r120,-242v5,-12,22,-6,30,4xm208,-108v-19,-30,16,-44,50,-44v35,0,45,16,45,39v0,34,-38,61,-60,85r63,0v4,11,3,29,-8,28r-97,0v-3,-9,-4,-18,2,-25v28,-35,64,-54,64,-78v0,-28,-46,-19,-59,-5","w":324},"\u00bc":{"d":"21,-216v-19,-34,48,-40,68,-39r0,123r31,0v2,11,3,28,-7,28r-95,0v-3,-12,-5,-28,8,-28r33,0r0,-92xm273,-150r0,97r22,0v5,15,0,35,-22,28v3,20,-2,32,-27,26r0,-26r-62,0v-6,-8,-6,-16,-2,-26v10,-29,35,-69,54,-89v12,-12,22,-14,37,-10xm206,-51r41,0r1,-67v-15,12,-35,43,-42,67xm240,-245r-121,243v-6,12,-21,4,-29,-5r120,-242v5,-12,22,-6,30,4","w":312},"\u00be":{"d":"92,-150v-2,-19,-23,-21,-46,-20v-3,-6,-9,-24,6,-23v6,0,13,0,19,1v18,-13,21,-36,-10,-37v-14,0,-27,5,-37,12v-17,-33,14,-38,49,-39v53,-2,54,46,25,70v48,22,16,95,-39,86v-35,1,-53,-14,-36,-36v13,13,72,13,69,-14xm272,-150r0,97r22,0v5,15,0,35,-22,28v3,20,-2,32,-27,26r0,-26r-62,0v-6,-8,-6,-16,-2,-26v10,-29,35,-69,54,-89v12,-12,22,-14,37,-10xm205,-51r41,0r1,-67v-15,12,-35,43,-42,67xm239,-245r-121,243v-6,12,-21,4,-29,-5r120,-242v5,-12,22,-6,30,4","w":311},"\u00a6":{"d":"55,-265r0,138v3,13,-18,11,-29,8r0,-137v-3,-14,18,-11,29,-9xm55,-79r0,140v3,14,-18,10,-29,8r0,-138v-3,-15,18,-13,29,-10","w":81},"<":{"d":"123,-127r-71,35r78,35v-2,18,-8,27,-23,20r-88,-39v-7,-11,-8,-27,4,-33r95,-46v8,9,18,21,5,28","w":144},">":{"d":"22,-59r71,-35r-78,-35v3,-17,9,-27,24,-20r87,39v7,10,8,27,-4,33r-95,46v-8,-9,-17,-22,-5,-28","w":144},"^":{"d":"76,-105v-15,9,-27,24,-45,30v-8,0,-14,-7,-14,-15r63,-53r52,45v11,9,3,22,-9,24","w":154},"{":{"d":"17,-94v-10,-36,20,-21,20,-60v0,-26,-5,-50,-5,-71v0,-30,24,-43,56,-43v6,7,8,25,0,29v-59,0,7,112,-42,131v49,12,-18,134,45,135v3,12,0,26,-9,27v-67,3,-47,-66,-45,-120v0,-19,-7,-25,-20,-28","w":99},"}":{"d":"82,-120v12,33,-19,22,-19,60v0,26,5,51,5,72v0,30,-24,42,-56,42v-6,-7,-10,-24,0,-28v58,0,-7,-112,41,-132v-48,-13,19,-134,-44,-135v-2,-12,-1,-26,9,-27v67,-3,47,66,45,120v0,19,6,25,19,28","w":99},"~":{"d":"4,-96v6,-10,24,-22,46,-22v30,0,51,28,72,2v9,-6,18,4,19,17v-7,10,-23,23,-46,23v-26,0,-29,-16,-47,-16v-22,0,-38,30,-44,-4","w":144},"\u00b0":{"d":"30,-234v0,-24,14,-35,36,-35v23,0,33,8,33,35v0,24,-12,35,-35,35v-22,0,-34,-7,-34,-35xm50,-233v0,11,5,16,14,16v10,0,16,-5,16,-17v0,-12,-5,-16,-14,-16v-10,0,-16,5,-16,17","w":128},"\u00a3":{"d":"104,-125v7,41,-22,20,-47,25v0,26,1,49,3,71r56,2v6,15,1,27,-16,27r-68,0v-3,-33,-4,-69,-4,-100r-23,0v-2,-29,3,-25,23,-25v2,-66,24,-89,58,-89v28,0,42,13,32,37v-34,-16,-60,-12,-61,52r47,0","w":131},"\u00a7":{"d":"75,-46v-6,-36,-61,-50,-62,-94v0,-12,5,-26,20,-36v-33,-29,-12,-79,38,-77v36,2,46,15,34,39v-12,-11,-58,-12,-55,8v5,36,62,49,62,94v0,12,-5,26,-20,36v31,30,14,79,-38,77v-36,-2,-48,-16,-34,-39v12,12,58,11,55,-8xm54,-156v-30,17,-3,48,16,61v33,-18,1,-50,-16,-61","w":125},"\u00b6":{"d":"127,-246r0,237v0,14,-22,10,-30,8r0,-73v-48,16,-84,2,-85,-77v-2,-96,52,-121,115,-95xm97,-97r0,-130v-38,-12,-55,13,-55,73v0,63,20,69,55,57xm179,-246r0,237v3,14,-19,10,-30,8r0,-236v-2,-14,18,-12,30,-9","w":194},"\u00b1":{"d":"139,-130v7,43,-25,21,-50,26v-5,25,16,58,-26,50r0,-50r-50,0v-7,-43,25,-21,50,-26v5,-25,-16,-58,26,-50r0,50r50,0xm132,-5r-120,0v0,-18,0,-26,6,-26r120,0v0,18,0,26,-6,26"},"\u00b5":{"d":"126,-180r0,171v-18,8,-63,23,-81,4r0,64v0,14,-18,12,-29,9r0,-237v-2,-14,16,-15,29,-11r0,133v-3,28,34,25,51,18r0,-140v-2,-14,17,-15,30,-11","w":141},"\u03bc":{"d":"126,-180r0,171v-18,8,-63,23,-81,4r0,64v0,14,-18,12,-29,9r0,-237v-2,-14,16,-15,29,-11r0,133v-3,28,34,25,51,18r0,-140v-2,-14,17,-15,30,-11","w":141},"\u00aa":{"d":"21,-222v-12,-26,9,-33,42,-34v60,-3,34,89,39,142v-29,11,-88,28,-88,-34v0,-44,30,-49,63,-41v2,-23,-3,-45,-23,-41v-13,0,-24,4,-33,8xm77,-129r0,-39v-18,-4,-39,-8,-39,21v0,27,24,24,39,18","w":115},"\u00ba":{"d":"13,-180v0,-54,20,-76,50,-76v31,0,46,17,46,76v0,52,-18,76,-50,76v-30,0,-46,-16,-46,-76xm37,-178v0,40,8,50,23,50v15,0,24,-15,24,-52v0,-40,-7,-50,-21,-50v-16,0,-26,13,-26,52","w":121},"\u00ac":{"d":"129,-111r0,71v-9,5,-28,4,-28,-7r0,-37r-87,0v-3,-10,-3,-27,8,-27r107,0","w":144},"\u00a0":{"w":56},"\u00af":{"d":"85,-213r-83,0v-5,-12,-2,-28,10,-28r82,0v5,11,2,28,-9,28","w":96},"\u00f0":{"d":"50,-255v13,-24,38,-7,48,7r24,-10v12,26,7,25,-8,31v19,31,28,70,28,123v0,58,-9,108,-61,108v-44,0,-65,-26,-65,-97v0,-75,40,-108,89,-80v-4,-17,-10,-30,-19,-43r-34,13v-16,-31,0,-26,17,-34v-6,-6,-12,-12,-19,-18xm80,-21v39,0,32,-73,31,-118v-33,-42,-65,-7,-65,51v0,46,12,67,34,67","w":153},"\u00fe":{"d":"46,-265r0,84v51,-7,81,2,82,73v0,96,-34,112,-55,112v-13,0,-21,-5,-27,-10r0,76v-10,1,-33,8,-29,-10r0,-311v0,-13,6,-14,29,-14xm46,-150r0,118v4,8,11,10,18,10v11,0,31,-9,31,-83v0,-59,-21,-60,-49,-45","w":137},"\u00de":{"d":"15,0r0,-245v0,-6,5,-7,21,-7r9,0r0,45v52,-3,79,16,78,71v-1,64,-31,81,-78,79r0,51v0,6,-2,6,-30,6xm91,-139v1,-34,-13,-46,-46,-42r0,96v33,5,45,-6,46,-54","w":129}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2010, Yanone (http://yanone.de/typedesign/). All rights reserved.
 * This Font Software is licensed under the SIL Open Font License, Version 1.1.
 * This license is available with a FAQ at: http://scripts.sil.org/OFL
 * 
 * Trademark:
 * Yanone Kaffeesatz is a trademark of Yanone
 * 
 * Description:
 * Yanone Kaffeesatz was first published in 2004 and is Yanone's first ever
 * finished typeface. Its Bold is reminiscent of 1920s coffee house typography,
 * while the rather thin fonts bridge the gap to present times. Lacking self
 * confidence and knowledge about the type scene Yanone decided to publish the
 * family for free under a Creative Commons License. A decision that should turn
 * out one of the best he ever made. It has been downloaded over 100,000 times to
 * date from this website alone, and you can witness Kaffeesatz use on German
 * fresh-water gyms, Dubai mall promos and New Zealand McDonald's ads. And of
 * course on coffee and foodstuff packaging and cafe design around the globe. In
 * 2009 he reworked much of the typeface and it got published in FontShop's
 * FontFont Library under the new name FF Kava. You can read more about it in an
 * extensive article by Yves Peters on the FontFeed.
 * 
 * Manufacturer:
 * Yanone
 * 
 * Designer:
 * Yanone
 * 
 * Vendor URL:
 * http://yanone.de/typedesign/
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":144,"face":{"font-family":"Yanone Kaffeesatz","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"2 0 0 0 0 0 0 0 0 0","ascent":"288","descent":"-72","x-height":"4","bbox":"-32.3114 -345 310.042 79.4923","underline-thickness":"34.56","underline-position":"6.12","stemh":"31","stemv":"49","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":50},"!":{"d":"11,-23v0,-14,9,-26,25,-26v19,0,26,10,26,26v0,14,-10,26,-26,26v-20,0,-25,-10,-25,-26xm17,-87r-8,-155v0,-11,7,-12,57,-12r-9,149v-1,18,-8,18,-40,18","w":72},"\"":{"d":"38,-211r-22,1v0,0,-10,-68,-6,-71v7,-3,29,-2,38,-1v-1,21,-7,68,-10,71xm86,-211r-22,1v0,0,-10,-68,-6,-71v7,-3,29,-2,37,-1v-1,21,-6,68,-9,71","w":104,"k":{"\u00ff":25,"\u00fd":25,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":34,"\u00ef":-23,"\u00ee":-14,"\u00ec":-20,"\u00eb":38,"\u00ea":38,"\u00e9":38,"\u00e8":38,"\u00e7":31,"\u00e6":25,"\u00e5":25,"\u00e4":25,"\u00e3":25,"\u00e2":25,"\u00e1":25,"\u00e0":25,"\u00dd":-7,"\u00dc":3,"\u00db":3,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-11,"\u00ce":-17,"\u00cb":9,"\u00ca":3,"\u00c7":23,"\u00c6":45,"\u00c5":45,"\u00c4":45,"\u00c3":45,"\u00c2":45,"\u00c1":45,"\u00c0":45,"\u00bf":40,"\u00a2":31,"r":34,"q":37,"m":34,"\\":-14,"Q":7,"@":28,"?":-7,"9":19,"6":11,"4":39,"2":9,"1":14,"0":14,"\/":51,"C":23,"G":14,"T":-4,"V":-7,"W":-7,"Y":-7,"d":37,"f":17,"t":5,"u":26,"v":25,"w":26,"y":25,"e":38,"o":34,"O":7,")":-7,"]":-7,"A":45,"J":50,"x":22,"a":25,"c":31,"g":36,"z":25,"n":34,"p":34,"s":31,"(":28,"[":28}},"#":{"d":"139,-96v0,33,0,32,-21,31v0,25,2,27,-36,26r1,-26r-26,0v-2,23,3,28,-36,26r1,-26r-17,0v1,-31,-1,-32,18,-31r2,-30r-20,0v0,-33,0,-32,22,-31v0,-24,-1,-27,36,-26r-2,26r27,0v0,-24,-1,-27,36,-26r-2,26r17,0v-1,31,1,32,-18,31r-2,30r20,0xm60,-126r-2,30r27,0r1,-30r-26,0"},"$":{"d":"49,44r0,-41v-47,-5,-38,-19,-27,-50v13,11,65,19,62,-11v-4,-43,-70,-66,-71,-114v0,-27,16,-44,44,-49v-1,-31,-4,-48,36,-45r0,45v45,5,41,12,26,40v-8,-6,-64,-12,-61,8v8,47,71,59,71,115v0,26,-10,50,-43,58v1,32,5,48,-37,44"},"%":{"d":"9,-189v0,-45,18,-66,51,-66v33,0,48,14,48,65v0,48,-18,68,-51,68v-33,0,-48,-11,-48,-67xm48,-189v0,32,3,36,11,36v6,0,12,-4,12,-36v0,-30,-2,-36,-11,-36v-7,0,-12,6,-12,36xm132,-64v0,-45,18,-66,51,-66v33,0,48,14,48,65v0,48,-18,68,-51,68v-33,0,-48,-11,-48,-67xm170,-63v0,32,4,37,12,37v6,0,12,-5,12,-37v0,-30,-2,-35,-11,-35v-8,0,-13,5,-13,35xm63,3v0,0,-25,-7,-25,-15r138,-243v0,0,22,8,22,17v0,7,-135,241,-135,241","w":240},"&":{"d":"146,-181v15,2,28,-7,25,14v2,13,-6,21,-23,19v6,21,6,67,-4,95v12,13,22,22,30,25v-11,35,-27,43,-51,12v-12,12,-28,20,-50,20v-92,2,-79,-105,-29,-133v-31,-56,-49,-121,34,-125v53,-3,68,16,46,48v-15,-11,-27,-13,-41,-13v-14,0,-22,2,-22,20v0,19,24,65,51,105v3,-34,-3,-70,-10,-84v12,-3,38,-3,44,-3xm98,-47v-12,-16,-24,-34,-36,-53v-18,12,-26,67,9,66v12,0,21,-5,27,-13","w":176},"'":{"d":"38,-211r-22,1v0,0,-10,-68,-6,-71v7,-3,29,-2,38,-1v-1,21,-7,68,-10,71","w":56,"k":{"z":25,"y":25,"x":22,"w":26,"v":25,"u":26,"t":5,"s":31,"p":34,"o":34,"n":34,"g":36,"f":17,"e":38,"d":37,"c":31,"a":25,"]":-7,"[":28,"Y":-7,"W":-7,"V":-7,"T":-4,"O":7,"J":50,"G":14,"C":23,"A":45,")":-7,"(":28,"\u00ff":25,"\u00fd":25,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":34,"\u00ef":-23,"\u00ee":-14,"\u00ec":-20,"\u00eb":38,"\u00ea":38,"\u00e9":38,"\u00e8":38,"\u00e7":31,"\u00e6":25,"\u00e5":25,"\u00e4":25,"\u00e3":25,"\u00e2":25,"\u00e1":25,"\u00e0":25,"\u00dd":-7,"\u00dc":3,"\u00db":3,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-11,"\u00ce":-17,"\u00cb":9,"\u00ca":3,"\u00c7":23,"\u00c6":45,"\u00c5":45,"\u00c4":45,"\u00c3":45,"\u00c2":45,"\u00c1":45,"\u00c0":45,"\u00bf":40,"\u00a2":31,"r":34,"q":37,"m":34,"\\":-14,"Q":7,"@":28,"?":-7,"9":19,"6":11,"4":39,"2":9,"1":14,"0":14,"\/":51}},"(":{"d":"98,-263v-48,53,-43,258,0,302v-4,19,-8,30,-22,30v-7,0,-55,-48,-55,-183v0,-122,48,-175,54,-175v13,0,19,6,23,26","w":104,"k":{"\u2019":-7,"\u2018":-7,"\u2014":8,"\u2013":8,"\u00ff":-7,"\u00fd":-7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":11,"\u00f5":11,"\u00f4":11,"\u00f3":11,"\u00f2":11,"\u00f1":7,"\u00ef":-7,"\u00ed":4,"\u00ec":-11,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"\u00e6":7,"\u00e3":7,"\u00e2":7,"\u00e1":7,"\u00e0":7,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00ce":-23,"\u00c7":11,"\u00c6":7,"\u00c5":7,"\u00c4":7,"\u00c3":7,"\u00c2":7,"\u00c1":7,"\u00c0":7,"\u00a2":19,"r":7,"q":11,"m":7,"]":-17,"\\":-6,"[":14,"Q":7,"\/":7,"+":11,"*":9,"'":-7,"C":11,"G":7,"d":11,"t":4,"u":7,"\u00fc":7,"v":13,"w":11,"y":-7,"e":11,"o":11,"\u00f8":11,"\"":-7,"-":8,"\u201c":-7,"\u201d":-7,"O":7,"A":7,"x":7,"a":7,"\u00e4":7,"\u00e5":7,"c":11,"\u00ab":4,"z":7,"Z":4,"n":7,"j":-41}},")":{"d":"7,39v43,-51,51,-242,0,-302v4,-20,10,-26,23,-26v6,0,53,49,53,175v0,124,-48,183,-55,183v-14,0,-17,-11,-21,-30","w":104,"k":{"\u2019":28,"\u2018":28,"'":28,"\"":28,"\u201c":28,"\u201d":28}},"*":{"d":"106,-244r-10,54v-1,7,-4,10,-18,7r-10,-56v0,-16,28,-9,38,-5xm104,-180r50,-32v10,8,17,33,4,40r-55,10v-8,-11,-5,-14,1,-18xm4,-176v6,-61,44,-16,67,-1v0,12,-5,15,-12,13xm114,-86r-24,-55v-3,-6,-3,-10,10,-15r43,45v9,12,-15,23,-29,25xm20,-111r44,-40v6,-5,11,-5,18,4r-28,56v-9,13,-27,-7,-34,-20","w":168,"k":{"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"o":4,"g":11,"e":7,"d":7,"c":7,"]":8,"J":45,"A":17,")":8,"\u00e7":11,"\u00c6":36,"\u00c5":17,"\u00c4":17,"\u00c3":17,"\u00c2":17,"\u00c1":17,"\u00c0":17,"q":4,"4":9,"\/":23}},"+":{"d":"135,-119v6,49,-15,32,-46,35v-3,30,14,52,-34,45r0,-45r-46,0v-6,-49,15,-32,46,-35v3,-30,-14,-52,34,-46r0,46r46,0","k":{"]":8,")":8}},",":{"d":"21,-3v-20,-10,-11,-46,12,-45v17,0,26,9,26,26v0,30,-25,57,-33,57v-7,0,-13,-2,-15,-11v8,-14,9,-18,10,-27","w":67,"k":{"\u00f8":7,"y":14,"w":9,"v":16,"u":7,"t":17,"o":7,"j":-14,"f":14,"e":7,"d":7,"Y":25,"W":11,"V":17,"U":4,"T":34,"O":6,"G":5,"C":9,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00dd":25,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":7,"\\":48,"Q":6}},"-":{"d":"84,-119v10,60,-38,27,-73,35v-10,-60,38,-27,73,-35","w":95,"k":{"\u00ff":9,"\u00fd":9,"\u00dd":22,"\u00c5":10,"\u00c4":10,"\u00c3":10,"\u00c2":10,"\u00c1":10,"\u00c0":10,"\\":31,"T":37,"V":11,"W":8,"Y":22,"f":9,"t":9,"v":7,"w":5,"y":9,")":8,"]":8,"A":10,"\u00c6":10,"J":45,"X":22,"x":19,"z":13,"Z":17,"S":28}},".":{"d":"8,-23v0,-14,10,-26,26,-26v19,0,25,10,25,26v0,14,-9,26,-25,26v-20,0,-26,-10,-26,-26","w":67,"k":{"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00dd":25,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":7,"\\":48,"Q":6,"C":9,"G":5,"T":34,"V":17,"W":11,"Y":25,"d":7,"f":14,"t":17,"u":7,"v":16,"w":9,"y":14,"e":7,"o":7,"\u00f8":7,"O":6,"U":4}},"\/":{"d":"129,-275r-81,273v-3,9,-3,9,-44,9r80,-272v3,-9,4,-10,45,-10","w":132,"k":{"\u201d":-9,"\u201c":-9,"\u00ff":9,"\u00ee":3,"\u00df":6,"\u00d3":6,"\u00bb":14,"\u00ab":22,"z":11,"y":9,"x":17,"w":8,"v":8,"u":14,"t":6,"s":23,"p":22,"o":25,"n":20,"j":6,"i":3,"g":23,"f":9,"e":28,"d":26,"c":28,"a":17,"Z":5,"X":9,"O":6,"J":34,"G":9,"C":14,"A":20,":":26,".":62,")":-11,"\"":-9,"\u2026":62,"\u2019":-9,"\u2018":-9,"\u2014":17,"\u2013":22,"\u00fd":8,"\u00fc":17,"\u00fb":17,"\u00fa":14,"\u00f9":17,"\u00f8":25,"\u00f7":22,"\u00f6":14,"\u00f5":11,"\u00f4":11,"\u00f3":19,"\u00f2":11,"\u00f1":5,"\u00ef":-23,"\u00ed":8,"\u00ec":-14,"\u00eb":19,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":28,"\u00e6":19,"\u00e5":11,"\u00e4":9,"\u00e3":8,"\u00e2":14,"\u00e1":17,"\u00e0":14,"\u00d8":17,"\u00d7":20,"\u00d6":5,"\u00d5":12,"\u00d4":5,"\u00d2":6,"\u00d1":8,"\u00ce":-14,"\u00cb":3,"\u00ca":3,"\u00c7":14,"\u00c6":59,"\u00c5":20,"\u00c4":17,"\u00c3":20,"\u00c2":17,"\u00c1":28,"\u00c0":14,"\u00bf":20,"\u00b7":22,"\u00a2":34,"\u00a1":20,"r":20,"q":31,"m":20,"_":51,"]":-6,"[":11,"Q":5,"@":17,"?":-11,"=":23,";":23,"9":14,"8":8,"7":3,"6":14,"5":8,"4":34,"3":19,"2":19,"1":17,"0":20,"\/":54,",":62,"'":-9,"%":9}},"0":{"d":"7,-107v0,-72,20,-109,65,-109v46,0,65,33,65,96v0,82,-14,123,-66,123v-53,0,-64,-42,-64,-110xm51,-105v0,54,2,72,21,72v15,0,22,-22,22,-87v0,-39,-3,-61,-20,-61v-19,0,-23,30,-23,76","k":{"\u201d":17,"\u201c":17,"\u00dd":14,"Y":14,"X":11,"W":6,"V":5,"T":20,"J":14,"\"":17,"\u2019":17,"\u2018":17,"_":25,"]":20,"\\":14,"'":17}},"1":{"d":"22,-171v-4,-8,-7,-14,-7,-24v3,-8,64,-26,84,-19r-4,176r42,-1v0,31,0,39,-9,39r-120,0v-3,-34,-6,-39,45,-38r3,-137v-19,1,-34,4,-34,4","k":{"\u201d":31,"\u201c":31,"\"":31,"\u2019":31,"\u2018":31,"*":17,"'":31}},"2":{"d":"9,0v-8,-68,84,-122,78,-158v-5,-30,-47,-17,-68,-9v-19,-43,10,-49,60,-49v41,0,55,18,55,51v0,43,-40,73,-73,127v20,1,79,-3,76,-4v0,33,-1,42,-10,42r-118,0","k":{"\u201d":9,"\u201c":9,"\"":9,"\u2019":9,"\u2018":9,"'":9}},"3":{"d":"90,-108v25,3,43,21,43,54v0,65,-38,90,-82,90v-44,0,-39,-26,-32,-49v28,22,70,7,70,-39v0,-26,-26,-34,-55,-33r-1,-24v30,-12,45,-31,45,-49v0,-28,-44,-19,-61,-9v-16,-42,3,-47,58,-49v75,-3,53,90,15,108","k":{"\u201d":9,"\u201c":9,"\"":9,"\u2019":9,"\u2018":9,"_":11,"'":9}},"4":{"d":"6,-75v13,-21,48,-176,110,-138r-1,139v23,2,24,-13,24,12v0,19,-6,28,-24,25v-4,31,17,40,-40,37r0,-37r-56,0v-11,-11,-13,-26,-13,-38xm40,-74r35,0r5,-89v-13,16,-35,67,-40,89","k":{"\u201d":8,"\u201c":8,"\"":8,"\u2019":8,"\u2018":8,"*":9,"'":8}},"5":{"d":"23,-216r111,0v0,29,-3,36,-21,36v-18,0,-55,-3,-55,-3r-5,45v41,-3,81,-2,81,68v0,64,-31,106,-84,106v-51,0,-41,-20,-36,-48v8,7,18,11,31,11v31,0,45,-33,45,-59v0,-51,-39,-51,-78,-42","k":{"_":17}},"6":{"d":"124,-210v-49,-14,-76,-2,-78,70v32,-36,92,-24,92,51v0,64,-25,92,-68,92v-58,0,-62,-44,-62,-119v0,-107,33,-137,81,-137v19,0,39,2,39,14v0,7,-1,18,-4,29xm98,-81v0,-47,-30,-52,-52,-23v0,51,12,77,26,71v17,0,26,-23,26,-48","k":{"_":14}},"7":{"d":"13,-216r130,0v-46,104,-74,183,-74,249v-34,0,-42,-2,-42,-11v0,-55,37,-159,63,-204v-21,1,-40,2,-66,2v-9,0,-11,-19,-11,-36","k":{"\u00c6":26,"q":19,"g":17,"e":17,"d":19,"a":11,"]":7,"X":9,"J":40,"A":26,";":14,":":14,")":7,"\u00ff":11,"\u00fc":11,"\u00fb":11,"\u00f6":11,"\u00f5":11,"\u00f4":11,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"\u00dc":26,"\u00db":26,"\u00d6":26,"\u00d5":26,"\u00d4":26,"\u00d1":26,"\u00cb":26,"\u00ca":26,"\u00c5":26,"\u00c4":26,"\u00c3":26,"\u00c2":26,"\u00c1":26,"\u00c0":26,"_":48,"@":8,"\/":22}},"8":{"d":"43,-135v-18,-15,-32,-27,-33,-56v0,-42,27,-63,61,-63v38,0,66,14,66,58v0,32,-16,51,-34,65v49,30,50,132,-28,134v-85,2,-82,-108,-32,-138xm98,-67v-1,-29,-14,-30,-27,-45v-31,12,-36,74,1,76v14,0,26,-11,26,-31xm77,-216v-27,0,-32,31,-18,45v4,5,11,11,18,17v14,-12,23,-23,23,-40v0,-10,-8,-22,-23,-22","k":{"_":8}},"9":{"d":"16,-5v51,16,83,-18,81,-69v-33,39,-91,16,-91,-55v0,-63,25,-90,68,-90v52,0,63,23,63,115v0,95,-26,141,-90,141v-35,0,-38,-15,-31,-42xm46,-134v0,45,33,54,52,23v0,-55,-5,-73,-23,-73v-17,0,-29,16,-29,50","k":{"\u201d":8,"\u201c":8,"\"":8,"\u2019":8,"\u2018":8,"_":14,"'":8}},":":{"d":"9,-139v0,-14,9,-26,25,-26v19,0,26,10,26,26v0,14,-10,26,-26,26v-20,0,-25,-10,-25,-26xm9,-23v0,-14,9,-26,25,-26v19,0,26,10,26,26v0,14,-10,26,-26,26v-20,0,-25,-10,-25,-26","w":67,"k":{"T":19}},";":{"d":"7,-139v0,-14,9,-26,25,-26v19,0,26,10,26,26v0,14,-10,26,-26,26v-20,0,-25,-10,-25,-26xm18,-3v-19,-11,-9,-45,13,-45v17,0,26,9,26,26v0,30,-25,57,-33,57v-7,0,-13,-2,-15,-11v8,-14,8,-18,9,-27","w":67,"k":{"j":-14,"T":19}},"=":{"d":"128,-120r-119,0v0,-24,0,-35,7,-35r119,0v0,24,0,35,-7,35xm128,-48r-119,0v0,-24,0,-35,7,-35r119,0v0,24,0,35,-7,35"},"?":{"d":"22,-23v0,-14,9,-26,25,-26v19,0,26,10,26,26v0,14,-10,26,-26,26v-20,0,-25,-10,-25,-26xm29,-80v-24,-37,29,-93,29,-115v0,-12,-5,-20,-22,-20v-17,0,-25,8,-25,8v-4,-12,-6,-22,-6,-33v0,-10,26,-16,47,-16v35,0,50,22,50,50v0,45,-23,60,-37,86v-5,22,15,45,-23,41v-5,0,-9,-1,-13,-1","w":105,"k":{"\u201d":-7,"\u201c":-7,"\u00c6":17,"J":14,"A":17,"\"":-7,"\u2019":-7,"\u2018":-7,"\u00dc":17,"\u00db":17,"\u00d6":17,"\u00d5":17,"\u00d4":17,"\u00d1":17,"\u00cb":17,"\u00ca":17,"\u00c5":17,"\u00c4":17,"\u00c3":17,"\u00c2":17,"\u00c1":17,"\u00c0":17,"'":-7}},"@":{"d":"93,-136v-12,-38,2,-40,46,-42v61,-5,32,84,36,142v28,7,28,-29,28,-83v0,-70,-13,-90,-66,-90v-57,0,-81,26,-81,120v0,89,17,118,70,118v34,0,59,-2,84,-11v7,10,11,19,11,27v0,15,-34,24,-91,24v-66,0,-116,-20,-116,-164v0,-104,48,-150,123,-150v68,0,108,27,108,114v0,116,-33,131,-58,131v-9,0,-16,-3,-22,-8v-32,13,-87,21,-82,-49v4,-58,23,-68,56,-55v-1,-15,4,-33,-13,-33v-14,0,-22,3,-33,9xm130,-30v13,2,7,-44,9,-59v-17,-1,-16,1,-18,33v0,19,1,26,9,26","w":258,"k":{"\u201d":14,"\u201c":14,"\u00dd":9,"j":-11,"Y":9,"X":6,"V":3,"T":8,"J":9,"\"":14,"\u2019":14,"\u2018":14,"7":6,"'":14}},"A":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0","w":157,"k":{"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-5,"*":20,"'":39}},"B":{"d":"11,0r0,-245v2,-14,31,-7,45,-7v30,0,61,10,61,57v0,37,-17,55,-33,57v18,2,41,10,41,52v0,48,-18,86,-67,86r-47,0xm52,-217r0,64v18,2,20,-9,20,-34v0,-30,-3,-31,-20,-30xm52,-119r0,84v21,3,25,-13,25,-47v0,-37,-4,-38,-25,-37","w":128,"k":{"\u2026":7,"\u2019":8,"\u2018":8,"\u00ff":3,"\u00fd":3,"\u00dd":9,"\u00dc":9,"\u00db":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d1":9,"\u00cb":9,"\u00ca":9,"\u00c6":9,"\u00c5":9,"\u00c4":9,"\u00c3":9,"\u00c2":9,"\u00c1":9,"\u00c0":9,"_":22,",":7,"'":8,"T":6,"V":3,"Y":9,"t":5,"v":6,"y":3,"\"":8,"\u201c":8,"\u201d":8,"A":9,".":7,"J":11,"X":11,"x":8}},"C":{"d":"80,-257v46,-1,35,24,28,45v-39,-17,-57,2,-58,91v-1,82,11,89,57,76v13,27,1,50,-39,50v-41,0,-60,-22,-60,-123v0,-118,40,-139,72,-139","w":116,"k":{"\u2026":-3,"\u2019":-4,"\u2018":-4,"\u2014":28,"\u2013":28,"\u00ff":21,"\u00fd":21,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":3,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":6,"q":3,"Q":6,"0":8,"\/":-5,",":-3,"'":-4,"C":6,"G":3,"d":3,"f":7,"t":7,"u":6,"v":17,"w":15,"y":21,"e":6,"o":3,"\u00f8":3,"\"":-4,"-":28,"\u201c":-4,"\u201d":-4,"O":6,".":-3,"x":4,"a":3,"c":3,"\u00ab":5}},"D":{"d":"11,-245v1,-13,30,-7,44,-7v48,0,71,20,71,113v0,121,-21,148,-115,139r0,-245xm80,-143v0,-69,-4,-73,-29,-72r0,177v27,1,29,-9,29,-105","w":133,"k":{"\u2026":11,"\u2019":11,"\u2018":11,"\u00ff":3,"\u00fc":3,"\u00fb":3,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":3,"\u00ea":3,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00dd":11,"\u00dc":14,"\u00db":14,"\u00d6":14,"\u00d5":14,"\u00d4":14,"\u00d1":14,"\u00cb":14,"\u00ca":14,"\u00c6":14,"\u00c5":14,"\u00c4":14,"\u00c3":14,"\u00c2":14,"\u00c1":14,"\u00c0":14,"_":25,",":11,"'":11,"T":8,"V":5,"W":6,"Y":11,"\"":11,"\u201c":11,"\u201d":11,")":7,"]":7,"A":14,".":11,"J":19,"a":3}},"E":{"d":"51,-36r51,0v0,34,0,36,-7,36r-84,0r0,-245v0,0,0,-7,7,-7r86,0v8,61,-20,28,-53,36r0,61r44,0v5,55,-12,32,-44,37r0,82","w":108,"k":{"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fd":4,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"r":4,"q":6,"'":-4,"d":6,"u":4,"w":4,"y":4,"e":5,"o":7,"\u00f8":7,"\"":-4,"-":7,"\u201c":-4,"\u201d":-4,"a":3}},"F":{"d":"51,-7v1,11,-28,6,-40,7r0,-245v0,0,0,-7,7,-7r86,0v0,32,0,34,-7,34r-46,0r0,63r44,0v5,55,-12,32,-44,37r0,111","w":106,"k":{"\u2026":40,"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":6,"\u00fd":6,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":9,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":9,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00dc":23,"\u00db":23,"\u00d6":23,"\u00d5":23,"\u00d4":23,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"r":7,"q":11,"_":42,"@":6,"0":6,"\/":20,",":40,"'":-4,"d":11,"u":7,"v":5,"w":4,"y":6,"e":11,"o":9,"\"":-4,"-":7,"\u201c":-4,"\u201d":-4,"A":23,".":40,"J":34,"x":15,"a":6,"c":9,"\u00ab":9,"g":6,"z":4,"\u00bb":8}},"G":{"d":"85,-255v41,0,44,19,34,45v-50,-21,-73,5,-70,89v3,81,5,90,37,82r0,-81r-17,0v2,-12,-6,-34,9,-33r46,0r-1,145v-12,8,-28,11,-49,11v-54,0,-69,-25,-69,-121v0,-116,30,-137,80,-137","w":132,"k":{"\u00ff":6,"\u00fd":6,"\u00dd":4,"Y":4,"v":3,"y":6}},"H":{"d":"86,0r0,-116r-35,0r0,109v0,7,1,7,-40,7r0,-245v0,-7,-1,-7,40,-7r0,99r35,0r0,-92v0,-7,-1,-7,40,-7r0,245v0,7,1,7,-40,7","w":137},"I":{"d":"10,0r0,-234v0,-18,1,-18,41,-18r0,245v0,7,0,7,-41,7","w":62},"J":{"d":"60,-66r0,-168v0,-18,0,-18,41,-18r0,194v0,40,-15,61,-54,61v-49,0,-43,-23,-34,-46v19,13,47,24,47,-23","w":111,"k":{"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":11,",":6,"A":8,"J":6,"x":4}},"K":{"d":"10,0r0,-245v0,-7,0,-7,41,-7r0,103r39,-100v16,-4,50,-6,44,7r-41,98v26,24,38,72,38,136v0,13,-31,9,-45,8v0,-50,-3,-100,-35,-118r0,111v0,7,0,7,-41,7","w":141,"k":{"\u2014":11,"\u2013":11,"\u00ff":8,"\u00fd":8,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"Q":6,"*":14,"C":9,"d":6,"f":12,"t":12,"u":6,"v":14,"w":8,"y":8,"e":8,"o":5,"\u00f8":5,"-":11,"O":6,"J":5,"a":6,"c":5}},"L":{"d":"51,-252r0,214r51,0v-2,12,6,37,-7,38r-84,0r0,-242v0,-10,0,-10,40,-10","w":109,"k":{"\u2019":45,"\u2018":45,"\u2014":37,"\u2013":37,"\u00ff":21,"\u00fd":21,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":8,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00dd":25,"\u00d8":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d3":9,"\u00d2":9,"\u00c7":11,"r":14,"q":9,"Q":9,"?":12,"0":6,"*":42,"'":45,"C":11,"G":9,"T":28,"V":25,"W":26,"Y":25,"d":9,"f":14,"t":4,"u":5,"v":11,"w":18,"y":21,"e":8,"o":7,"\u00f8":7,"\"":45,"-":37,"\u201c":45,"\u201d":45,"O":9,")":7,"]":7,"a":6,"c":8,"\u00ab":17}},"M":{"d":"11,0r0,-245v2,-15,25,-4,38,-7r38,125v4,-30,24,-86,33,-118v4,-14,27,-4,41,-7r0,245v0,7,0,7,-41,7v-4,-47,11,-175,11,-177v-12,51,-21,75,-36,114v-3,6,-13,2,-20,3r-17,-51v-4,-10,-12,-42,-18,-66v2,0,13,123,11,170v0,7,-3,7,-40,7","w":171},"N":{"d":"105,0v-22,-57,-47,-107,-59,-175v7,58,5,108,5,168v0,7,0,7,-40,7r0,-245v1,-14,26,-4,39,-7v20,54,45,106,58,168v-6,-57,-3,-102,-4,-161v0,-7,0,-7,40,-7r0,245v-1,13,-26,5,-39,7","w":154},"O":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,101,-21,132,-68,132v-47,0,-65,-23,-65,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96","w":146,"k":{"\u2026":9,"\u2019":4,"\u2018":4,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":20,",":9,"'":4,"T":5,"V":5,"W":5,"Y":9,"\"":4,"\u201c":4,"\u201d":4,")":7,"]":7,"A":8,".":9,"J":12,"X":8,"x":6}},"P":{"d":"11,0r0,-245v1,-14,28,-4,41,-7v45,0,70,15,70,74v-1,66,-34,82,-71,81r0,90v0,7,0,7,-40,7xm77,-183v0,-28,-4,-36,-26,-34r0,83v22,1,26,-5,26,-49","w":125,"k":{"\u2026":57,"\u2014":14,"\u2013":14,"\u00ff":3,"\u00fc":3,"\u00fb":3,"\u00f8":5,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00dd":6,"\u00dc":25,"\u00db":25,"\u00d6":25,"\u00d5":25,"\u00d4":25,"\u00d1":25,"\u00cb":25,"\u00ca":25,"\u00c6":25,"\u00c5":25,"\u00c4":25,"\u00c3":25,"\u00c2":25,"\u00c1":25,"\u00c0":25,"\u00b7":11,"q":5,"_":65,"@":8,",":57,"Y":6,"d":5,"e":8,"o":5,"-":14,")":11,"]":11,"A":25,".":57,"J":39,"X":14,"a":3,"c":5,"\u00ab":11,"Z":11}},"Q":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,72,-10,108,-33,123v2,28,17,28,38,18v4,6,5,16,5,21v0,15,-24,18,-35,18v-28,0,-44,-15,-54,-48v-39,-4,-54,-32,-54,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96","w":146,"k":{"\u201d":4,"\u201c":4,"x":9,"Y":12,"X":9,"T":6,"J":12,".":10,"\"":4,"\u2026":10,"\u2019":4,"\u2018":4,"\u00dd":12,"\u00c6":17,"_":-14,",":10,"'":4}},"R":{"d":"18,-252v64,-2,105,0,104,74v0,36,-10,56,-25,68v12,15,29,46,31,102v0,12,-28,9,-45,8v-1,-56,-14,-84,-23,-97r-9,0r0,90v0,7,0,7,-40,7r0,-245v0,0,0,-7,7,-7xm77,-180v0,-32,-4,-39,-26,-37r0,83v21,1,26,-5,26,-46","w":132,"k":{"\u2014":14,"\u2013":14,"\u00ff":3,"\u00fd":3,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00dd":12,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00c7":5,"\u00c6":31,"C":5,"T":6,"V":6,"W":5,"Y":12,"d":3,"q":3,"y":3,"e":6,"o":3,"\u00f8":3,"-":14,"O":3,"Q":3,"X":3}},"S":{"d":"69,-256v51,0,59,16,40,43v-10,-8,-64,-13,-60,11v7,49,69,80,69,135v0,36,-13,71,-65,71v-50,0,-56,-23,-38,-54v16,17,64,18,60,-16v-5,-45,-70,-87,-70,-135v0,-32,22,-55,64,-55","w":123,"k":{"\u2019":-9,"\u2018":-9,"\u00ff":11,"\u00fd":11,"\u00c6":17,"_":11,"'":-9,"f":11,"v":9,"w":13,"y":11,"\"":-9,"\u201c":-9,"\u201d":-9,"J":6,"x":11}},"T":{"d":"133,-222v-3,15,-31,4,-45,7r0,208v0,7,0,7,-40,7r0,-215r-44,0v2,-12,-6,-37,7,-37r122,0r0,30","w":136,"k":{"\u2026":37,"\u2019":-4,"\u2018":-4,"\u2014":37,"\u2013":37,"\u00ff":37,"\u00fd":37,"\u00fc":34,"\u00fb":34,"\u00fa":34,"\u00f9":34,"\u00f8":36,"\u00f6":36,"\u00f5":36,"\u00f4":36,"\u00f3":36,"\u00f2":36,"\u00f1":34,"\u00ef":9,"\u00ee":9,"\u00ed":9,"\u00ec":9,"\u00eb":39,"\u00ea":39,"\u00e9":39,"\u00e8":39,"\u00e7":34,"\u00e6":37,"\u00e5":37,"\u00e4":37,"\u00e3":37,"\u00e2":37,"\u00e1":37,"\u00e0":37,"\u00dc":25,"\u00db":25,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00d1":25,"\u00cb":25,"\u00ca":25,"\u00c7":14,"\u00c6":25,"\u00c5":25,"\u00c4":25,"\u00c3":25,"\u00c2":25,"\u00c1":25,"\u00c0":25,"r":34,"q":34,"m":34,"_":34,"Q":6,"@":17,";":25,"0":20,"\/":25,",":37,"'":-4,"C":14,"G":11,"d":34,"f":17,"t":12,"u":34,"v":34,"w":35,"y":37,"e":39,"o":36,"\"":-4,"-":37,"\u201c":-4,"\u201d":-4,"O":6,"A":25,".":37,"J":34,"x":34,"a":37,"c":34,"\u00ab":25,"g":36,"z":35,"\u00bb":34,":":25,"n":34,"p":39,"s":36,"h":6,"k":6,"i":9,"j":9}},"U":{"d":"53,-252r0,184v-5,34,21,41,43,30r0,-206v0,-8,0,-8,41,-8r0,242v-9,6,-31,14,-62,14v-57,0,-64,-33,-64,-73r0,-175v0,-8,0,-8,42,-8","w":147},"V":{"d":"3,-242v-4,-19,28,-7,42,-10r32,219r27,-208v1,-20,28,-8,45,-11r-47,252v-23,3,-54,6,-58,-19","w":151,"k":{"\u2026":17,"\u2019":-7,"\u2018":-7,"\u2014":17,"\u2013":17,"\u00ff":5,"\u00fd":5,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":16,"\u00f6":16,"\u00f5":16,"\u00f4":16,"\u00f3":16,"\u00f2":16,"\u00f1":11,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e7":17,"\u00e6":14,"\u00e5":14,"\u00e4":14,"\u00e3":14,"\u00e2":14,"\u00e1":14,"\u00e0":14,"\u00dc":26,"\u00db":26,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":26,"\u00cb":26,"\u00ca":26,"\u00c7":8,"\u00c6":26,"\u00c5":26,"\u00c4":26,"\u00c3":26,"\u00c2":26,"\u00c1":26,"\u00c0":26,"r":11,"q":17,"m":11,"_":25,"@":11,"0":12,"\/":19,",":17,"'":-7,"C":8,"G":6,"d":17,"f":6,"t":6,"u":14,"v":11,"w":5,"y":5,"e":17,"o":16,"\"":-7,"-":17,"\u201c":-7,"\u201d":-7,"O":5,"Q":5,"A":26,".":17,"J":33,"x":9,"a":14,"c":17,"\u00ab":12,"g":17,"z":11,"\u00bb":12,":":11,";":11,"n":11,"p":14,"s":14,"i":5,"j":6}},"W":{"d":"3,-242v-4,-19,28,-7,42,-10r18,117v5,36,9,70,10,94r3,0v2,-69,24,-126,24,-189v0,-18,24,-9,39,-11r18,106v6,36,8,70,10,94r3,0v3,-65,17,-137,24,-200v2,-20,28,-8,45,-11r-43,252v-28,3,-52,7,-57,-21v-8,-40,-16,-85,-20,-131r-21,152v-25,2,-53,8,-58,-21v-9,-58,-37,-221,-37,-221","w":240,"k":{"\u2026":14,"\u2019":-7,"\u2018":-7,"\u2014":11,"\u2013":11,"\u00ff":8,"\u00fd":8,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":14,"\u00f6":14,"\u00f5":14,"\u00f4":14,"\u00f3":14,"\u00f2":14,"\u00f1":14,"\u00ef":14,"\u00ee":14,"\u00ec":-20,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e7":14,"\u00e6":14,"\u00e5":14,"\u00e4":14,"\u00e3":14,"\u00e2":14,"\u00e1":14,"\u00e0":14,"\u00dc":21,"\u00db":21,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":21,"\u00cb":21,"\u00ca":21,"\u00c7":9,"\u00c6":21,"\u00c5":21,"\u00c4":21,"\u00c3":21,"\u00c2":21,"\u00c1":21,"\u00c0":21,"r":14,"q":14,"m":14,"_":25,"@":6,"0":6,"\/":14,",":14,"'":-7,"C":9,"G":6,"d":14,"u":11,"v":6,"w":8,"y":8,"e":17,"o":14,"\"":-7,"-":11,"\u201c":-7,"\u201d":-7,"O":5,"Q":5,"A":21,".":14,"J":31,"x":12,"a":14,"c":14,"\u00ab":8,"g":14,"z":11,"\u00bb":5,"Z":8,":":11,";":11,"n":14,"p":12,"s":11}},"X":{"d":"143,-252r-40,118r44,128v2,4,1,6,-4,6r-44,0r-26,-84r-27,79v-7,10,-28,3,-43,5r48,-129r-39,-116v-2,-7,1,-7,48,-7r21,78v4,-22,13,-49,19,-72v2,-6,2,-6,43,-6","w":151,"k":{"\u2019":-4,"\u2018":-4,"\u2014":17,"\u2013":17,"\u00ff":23,"\u00fd":23,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00f1":8,"\u00ef":8,"\u00ee":8,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":5,"\u00e6":8,"\u00e5":8,"\u00e4":8,"\u00e3":8,"\u00e2":8,"\u00e1":8,"\u00e0":8,"\u00d8":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d3":9,"\u00d2":9,"\u00c7":8,"\u00c6":36,"Q":9,"@":3,"0":9,"'":-4,"C":8,"G":8,"d":8,"q":8,"f":11,"t":7,"u":14,"v":14,"w":19,"y":23,"e":11,"o":6,"\u00f8":6,"\"":-4,"-":17,"\u201c":-4,"\u201d":-4,"O":9,"a":8,"c":5,"\u00ab":9,"p":11}},"Y":{"d":"47,0r0,-103r-45,-143v-2,-6,-1,-6,46,-6v8,34,18,78,21,116v2,-34,11,-78,19,-109v2,-7,2,-7,43,-7r-44,146r0,99v0,7,1,7,-40,7","w":132,"k":{"\u2026":25,"\u2019":-7,"\u2018":-7,"\u2014":22,"\u2013":22,"\u00ff":14,"\u00fd":14,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":29,"\u00f5":29,"\u00f4":29,"\u00f3":29,"\u00f2":29,"\u00f1":21,"\u00ef":7,"\u00ee":7,"\u00ed":7,"\u00ec":7,"\u00eb":28,"\u00ea":28,"\u00e9":28,"\u00e8":28,"\u00e7":28,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":29,"\u00db":29,"\u00d8":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d3":9,"\u00d2":9,"\u00d1":29,"\u00cb":29,"\u00ca":29,"\u00c7":14,"\u00c5":29,"\u00c4":29,"\u00c3":29,"\u00c2":29,"\u00c1":29,"\u00c0":29,"r":21,"q":28,"m":21,"_":25,"Q":9,"@":8,"0":17,"\/":23,",":25,"'":-7,"C":14,"G":12,"d":28,"f":11,"t":13,"u":18,"v":14,"w":15,"y":14,"e":28,"o":29,"\u00f8":29,"\"":-7,"-":22,"\u201c":-7,"\u201d":-7,"O":9,"A":29,"\u00c6":29,".":25,"J":33,"x":16,"a":22,"c":28,"\u00ab":20,"g":26,"z":18,"\u00bb":17,":":20,";":20,"n":21,"p":26,"s":23,"i":7,"j":11,"S":4}},"Z":{"d":"13,-215v2,-13,-5,-37,8,-37r108,0v4,8,4,21,0,30r-83,186v27,-1,58,3,80,-3v-3,13,7,39,-7,39r-111,0v-6,-6,-7,-21,-2,-32r80,-184","w":135,"k":{"\u2019":-7,"\u2018":-7,"\u2014":33,"\u2013":33,"\u00ff":11,"\u00fd":11,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"r":11,"q":8,"0":3,"'":-7,"d":8,"f":7,"t":4,"u":11,"w":7,"y":11,"e":9,"o":7,"\u00f8":7,"\"":-7,"-":33,"\u201c":-7,"\u201d":-7,")":4,"]":4,"x":7,"a":6,"c":6,"g":5,"p":7}},"[":{"d":"62,-296r61,0v6,58,-17,32,-51,38r0,292r51,0v0,37,0,38,-11,38r-81,0r0,-356v0,-10,0,-12,31,-12","w":126,"k":{")":-14,"\u2019":-7,"\u2018":-7,"\u2014":8,"\u2013":8,"\u00ff":-7,"\u00fd":-7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":11,"\u00f5":11,"\u00f4":11,"\u00f3":11,"\u00f2":11,"\u00f1":7,"\u00ef":-7,"\u00ed":4,"\u00ec":-11,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"\u00e6":7,"\u00e3":7,"\u00e2":7,"\u00e1":7,"\u00e0":7,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00ce":-23,"\u00c7":11,"\u00c6":7,"\u00c5":7,"\u00c4":7,"\u00c3":7,"\u00c2":7,"\u00c1":7,"\u00c0":7,"\u00a2":19,"r":7,"q":11,"m":7,"]":-17,"\\":-6,"[":14,"Q":7,"0":22,"\/":8,"+":11,"*":9,"'":-7,"C":11,"G":7,"d":11,"t":4,"u":7,"\u00fc":7,"v":13,"w":11,"y":-7,"e":11,"o":11,"\u00f8":11,"\"":-7,"-":8,"\u201c":-7,"\u201d":-7,"O":7,"A":7,"x":7,"a":7,"\u00e4":7,"\u00e5":7,"c":11,"\u00ab":4,"z":7,"Z":4,"n":7,"j":-41}},"\\":{"d":"44,-275r81,276v3,9,1,10,-40,10r-81,-276v-3,-9,-1,-10,40,-10","w":129,"k":{"\u201d":48,"\u201c":48,"\u00c6":-14,"]":5,"A":-14,".":-12,")":5,"\"":48,"\u2026":-12,"\u2019":48,"\u2018":48,"\u00dc":-14,"\u00db":-14,"\u00d6":-14,"\u00d5":-14,"\u00d4":-14,"\u00d1":-14,"\u00cb":-14,"\u00ca":-14,"\u00c5":-14,"\u00c4":-14,"\u00c3":-14,"\u00c2":-14,"\u00c1":-14,"\u00c0":-14,",":-12,"'":48}},"]":{"d":"64,72r-61,0v-6,-58,17,-32,51,-38r0,-292r-51,0v0,-37,0,-38,11,-38r81,0r0,356v0,10,0,12,-31,12","w":126,"k":{"]":8,")":8,"\u2019":28,"\u2018":28,"'":28,"\"":28,"\u201c":28,"\u201d":28}},"_":{"d":"122,46r-118,0v0,-24,0,-35,7,-35r119,0v0,24,-1,35,-8,35","w":133,"k":{"\u00ff":-11,"\u00fd":-11,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":11,"\u00f6":11,"\u00f5":11,"\u00f4":11,"\u00f3":11,"\u00f2":11,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":14,"\u00dd":28,"\u00d8":14,"\u00d6":14,"\u00d5":14,"\u00d4":14,"\u00d3":14,"\u00d2":14,"\u00c7":14,"y":-11,"w":17,"v":23,"u":11,"t":19,"o":11,"j":-42,"g":-5,"f":8,"e":5,"d":5,"c":14,"Y":28,"W":20,"V":23,"T":25,"O":14,"G":11,"C":14,"q":11,"Q":14,"9":-8,"8":14,"6":17,"5":-6,"4":45,"0":17,"\/":-20}},"`":{"d":"50,-200v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,36,26,48,43v0,0,-6,22,-16,22","w":65},"a":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47","w":121,"k":{"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,"f":3,"t":4,"y":3,"\"":30,"\u201c":30,"\u201d":30,")":7,"]":7,"x":4}},"b":{"d":"13,-7r0,-240v0,-18,6,-18,40,-18r0,92v38,-24,71,-11,71,62v0,102,-38,115,-69,115v-19,0,-34,-5,-42,-11xm53,-143r0,108v2,2,5,3,8,3v7,0,17,-10,17,-71v-1,-41,-5,-53,-25,-40","w":130,"k":{"\u2026":7,"\u2019":28,"\u2018":28,"_":14,"\/":6,",":7,"'":28,"w":2,"\"":28,"\u201c":28,"\u201d":28,")":11,"]":11,".":7}},"c":{"d":"72,-184v29,1,36,15,26,40v-35,-8,-46,-13,-48,57v-2,55,14,62,47,50v9,29,-1,41,-36,41v-37,0,-53,-15,-53,-90v0,-86,34,-98,64,-98","w":105,"k":{"\u2019":14,"\u2018":14,"\u2014":8,"\u2013":8,"\u00ff":-2,"\u00fd":-2,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"q":6,"\/":-5,"'":14,"d":6,"t":-4,"w":-2,"y":-2,"e":6,"o":6,"\u00f8":6,"\"":14,"-":8,"\u201c":14,"\u201d":14,")":4,"]":4,"c":5,"\u00ab":8}},"d":{"d":"79,-36r0,-111v-20,-5,-25,-5,-25,60v0,52,2,62,25,51xm79,-177v8,-41,-27,-99,40,-88r0,258v-53,16,-114,31,-111,-75v2,-85,26,-116,71,-95","w":131,"k":{"\u00ef":-7,"\u00ee":-7,"\u00ec":-7}},"e":{"d":"71,-184v48,0,53,66,41,110v-18,4,-44,6,-62,6v-2,44,36,34,62,22v11,35,-5,50,-48,50v-33,0,-56,-17,-56,-85v0,-87,29,-103,63,-103xm66,-149v-11,0,-15,16,-16,49v10,0,21,0,26,-3v3,-13,4,-53,-10,-46","w":124,"k":{"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"'":22,"w":2,"e":4,"\"":22,"\u201c":22,"\u201d":22,")":7,"]":7,"x":4}},"f":{"d":"25,-147r-21,0v0,-40,-2,-32,21,-33v-7,-59,27,-93,63,-86v34,-1,42,15,32,41v-24,-9,-54,-10,-54,20r0,25r25,0v1,44,0,30,-25,33r0,140v-1,10,-28,7,-41,7r0,-147","w":94,"k":{"\u2122":-31,"\u2026":19,"\u2019":-42,"\u2018":-42,"\u2014":17,"\u2013":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00ae":-23,"\u00a9":-22,"r":4,"q":8,"m":2,"_":17,"]":-39,"\\":-31,"?":-40,"8":-11,",":19,"*":-12,"'":-42,"&":-20,"!":-34,"d":8,"u":4,"w":4,"e":8,"o":7,"\"":-42,"-":17,"\u201c":-42,"\u201d":-42,")":-39,".":19,"c":5,"\u00ab":9,"g":7,"p":18}},"g":{"d":"10,-117v-1,-58,35,-75,79,-63r42,0v8,10,6,42,-15,33v21,42,1,105,-60,91v-3,4,-4,7,-4,10v0,6,14,5,31,8v31,5,47,16,47,44v0,35,-19,65,-68,65v-76,-1,-68,-55,-34,-81v-31,-11,-21,-34,3,-54v-15,-10,-21,-30,-21,-53xm69,-155v-10,0,-16,9,-16,37v0,26,3,33,15,33v11,0,16,-7,16,-40v0,-23,-4,-30,-15,-30xm89,12v0,-11,-2,-15,-30,-18v-14,10,-26,41,7,40v18,0,23,-13,23,-22","w":137,"k":{"\u2019":22,"\u2018":22,"\u00ff":-4,"\u00fd":-4,"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":3,"\u00ea":3,"\u00e9":3,"\u00e8":3,"\u00e7":4,"q":3,"'":22,"d":3,"y":-4,"e":3,"o":4,"\"":22,"\u201c":22,"\u201d":22,"x":4,"c":4,"j":-27,"\u00df":4}},"h":{"d":"12,0r0,-247v0,-18,7,-18,40,-18r0,94v26,-23,68,-17,68,34r0,130v0,7,-3,7,-42,7r0,-125v3,-19,-12,-28,-26,-17r0,135v0,7,0,7,-40,7","w":129,"k":{"\u201d":31,"\u201c":31,"y":4,"\"":31,"\u2019":31,"\u2018":31,"\u00ff":4,"\u00fd":4,"\/":-8,"'":31,")":7,"]":7}},"i":{"d":"53,-180r0,173v0,7,0,7,-41,7r0,-162v0,-18,8,-18,41,-18xm14,-233v0,-17,7,-28,22,-28v15,0,19,8,19,27v0,19,-8,31,-22,31v-12,0,-19,-7,-19,-30","w":64,"k":{"\/":-8}},"j":{"d":"55,-180r0,193v0,30,-9,58,-50,58v-39,0,-43,-19,-32,-41v20,6,42,13,42,-22r0,-170v0,-18,7,-18,40,-18xm15,-233v0,-17,7,-28,22,-28v15,0,20,8,20,27v0,19,-8,31,-22,31v-12,0,-20,-7,-20,-30","w":67,"k":{"\/":-9,"j":-18}},"k":{"d":"12,0r0,-247v0,-18,8,-18,41,-18r0,91v20,-16,75,-12,68,21v0,27,-13,45,-21,54v24,18,28,54,25,93v-1,6,-2,6,-47,6v4,-31,6,-101,-25,-75r0,68v0,7,0,7,-41,7xm75,-138v0,-16,-17,-10,-22,0r0,36v15,-8,22,-18,22,-36","w":132,"k":{"\u2019":28,"\u2018":28,"\u2014":7,"\u2013":7,"\u00ff":7,"\u00fd":7,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\u00e7":4,"q":4,"'":28,"w":4,"y":7,"e":4,"o":4,"\u00f8":4,"\"":28,"-":7,"\u201c":28,"\u201d":28,"c":4,"p":4}},"l":{"d":"52,-265r0,258v0,7,0,7,-40,7r0,-247v0,-18,7,-18,40,-18","w":64},"m":{"d":"76,0r0,-135v2,-20,-15,-15,-24,-10r0,138v0,7,-1,7,-40,7r0,-172v20,-9,66,-20,85,-2v35,-18,95,-13,83,39r0,128v0,7,-1,7,-40,7r0,-134v2,-19,-14,-15,-24,-11r0,138v0,7,1,7,-40,7","w":190,"k":{"\u201d":31,"\u201c":31,"y":2,"x":2,"]":7,")":7,"\"":31,"\u2019":31,"\u2018":31,"\u00ff":2,"\u00fd":2,"\/":-6,"'":31}},"n":{"d":"12,0r0,-172v34,-15,108,-27,108,35r0,130v0,7,-1,7,-42,7r0,-125v2,-28,-11,-27,-26,-20r0,138v0,7,0,7,-40,7","w":129,"k":{"\u2019":31,"\u2018":31,"\/":-11,"'":31,"\"":31,"\u201c":31,"\u201d":31,")":7,"]":7}},"o":{"d":"5,-90v0,-65,22,-94,60,-94v39,0,56,19,56,92v0,69,-20,96,-59,96v-39,0,-57,-13,-57,-94xm50,-91v0,56,4,61,13,61v7,0,14,-6,14,-61v0,-52,-3,-58,-13,-58v-8,0,-14,7,-14,58","w":126,"k":{"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"_":17,"\/":-6,",":7,"*":4,"'":33,"f":4,"t":4,"v":4,"w":4,"y":7,"\"":33,"\u201c":33,"\u201d":33,")":11,"]":11,".":7,"x":7,"z":4}},"p":{"d":"12,53r0,-223v48,-24,114,-27,111,59v-4,112,-21,126,-71,108r0,71v-16,4,-40,8,-40,-15xm52,-145r0,106v3,5,6,7,10,7v8,0,16,-8,16,-76v0,-43,-7,-46,-26,-37","w":131,"k":{"\u2026":7,"\u2019":36,"\u2018":36,"\u00ff":11,"\u00fd":11,"\u00fc":4,"\u00fb":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":4,"\u00ea":4,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"_":22,",":7,"*":4,"'":36,"f":4,"t":4,"v":4,"w":4,"y":11,"\"":36,"\u201c":36,"\u201d":36,")":11,"]":11,".":7,"x":4,"a":4,"z":4,"j":2}},"q":{"d":"121,-173r0,227v5,21,-23,17,-41,16r0,-79v-5,8,-14,13,-27,13v-23,0,-45,-13,-45,-81v1,-105,54,-122,113,-96xm80,-44r0,-101v-2,-3,-4,-4,-8,-4v-11,0,-18,14,-18,70v0,52,13,59,26,35","w":132,"k":{"\u201d":23,"\u201c":23,"\"":23,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"r":{"d":"12,0r0,-167v13,-9,30,-17,50,-17v31,0,25,19,20,42v-12,-6,-19,-3,-29,3r0,132v0,7,0,7,-41,7","w":89,"k":{"\u2026":25,"\u2019":20,"\u2018":20,"\u2014":23,"\u2013":23,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":7,"q":7,"_":25,",":25,"'":20,"d":7,"e":7,"o":7,"\"":20,"-":23,"\u201c":20,"\u201d":20,")":7,"]":7,".":25,"x":4,"c":7,"\u00ab":14,"g":6}},"s":{"d":"66,-184v54,0,49,20,36,43v-22,-15,-69,-8,-37,21v18,17,44,41,44,72v0,32,-23,52,-60,52v-35,1,-53,-16,-36,-44v16,9,52,15,50,-8v-3,-34,-58,-55,-57,-91v0,-25,15,-45,60,-45","w":114,"k":{"\u2019":20,"\u2018":20,"\u2014":8,"\u2013":8,"'":20,"\"":20,"-":8,"\u201c":20,"\u201d":20,")":4,"]":4,"x":4}},"t":{"d":"62,4v-62,-4,-29,-95,-37,-150r-22,0v1,-40,-1,-33,22,-34v6,-37,-21,-74,40,-65r0,65r30,0v2,46,-3,31,-30,34r0,98v-3,19,14,20,28,13v9,23,-7,40,-31,39","w":102,"k":{"\u2026":-4,"\u2019":11,"\u2018":11,"\u2014":19,"\u2013":19,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"q":7,"0":3,",":-4,"'":11,"d":7,"t":18,"u":4,"e":11,"o":7,"\u00f8":7,"\"":11,"-":19,"\u201c":11,"\u201d":11,".":-4,"c":11,"\u00ab":14,"g":4}},"u":{"d":"118,-180r0,170v-12,7,-31,14,-53,14v-88,3,-45,-106,-55,-177v0,-7,0,-7,42,-7r0,132v-3,19,16,21,26,12r0,-137v0,-7,-1,-7,40,-7","w":129,"k":{"\u2019":23,"\u2018":23,"\/":-5,"'":23,"\"":23,"\u201c":23,"\u201d":23,")":7,"]":7}},"v":{"d":"34,-16r-30,-152v-3,-12,-2,-12,44,-12r14,138v0,-10,8,-102,12,-130v1,-8,1,-8,42,-8r-36,180v-20,3,-42,6,-46,-16","w":118,"k":{"\u2026":18,"\u2019":22,"\u2018":22,"\u2014":7,"\u2013":7,"\u00ff":3,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":6,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"r":7,"q":8,"m":4,"k":4,"_":26,"@":5,"0":3,"\/":8,",":18,"'":22,"d":8,"u":4,"e":9,"o":7,"\u00f8":7,"\"":22,"-":7,"\u201c":22,"\u201d":22,")":7,"]":7,".":18,"a":3,"c":6,"g":7,"p":4,"s":4}},"w":{"d":"2,-172v-1,-8,3,-8,45,-8v6,30,15,124,14,136r3,0v1,-36,14,-87,14,-124v0,-14,26,-6,39,-8r13,80v6,16,-1,55,7,52v1,-43,6,-90,12,-128v1,-8,3,-8,39,-8v0,0,-33,180,-36,180v-5,1,-51,8,-47,-16v-4,-25,-7,-47,-9,-77v-2,36,-6,62,-11,93v0,0,-21,2,-35,2v-10,0,-15,-8,-17,-18v-10,-43,-31,-156,-31,-156","w":189,"k":{"\u2026":13,"\u2019":23,"\u2018":23,"\u2014":5,"\u2013":5,"\u00ff":3,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":7,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"r":7,"q":6,"m":2,"k":4,"_":20,"\/":3,",":13,"'":23,"d":6,"u":4,"e":9,"o":7,"\"":23,"-":5,"\u201c":23,"\u201d":23,")":11,"]":11,".":13,"a":3,"c":7,"g":7,"z":4,"p":4,"s":4}},"x":{"d":"133,-180r-40,84r39,87v4,9,4,9,-45,9r-23,-59v-5,17,-10,37,-17,51v-3,8,-7,8,-44,8r42,-93r-37,-81v-3,-6,-3,-6,42,-6r21,57r18,-50v3,-7,4,-7,44,-7","w":136,"k":{"\u2019":20,"\u2018":20,"\u2014":22,"\u2013":22,"\u00ff":5,"\u00fc":5,"\u00fb":5,"\u00fa":7,"\u00f9":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":5,"\u00ef":5,"\u00ee":5,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":7,"\u00e6":5,"\u00e5":5,"\u00e4":5,"\u00e3":5,"\u00e2":5,"\u00e1":5,"\u00e0":5,"r":7,"q":9,"k":4,"0":3,"\/":-8,"'":20,"d":9,"t":4,"w":7,"e":9,"o":7,"\u00f8":7,"\"":20,"-":22,"\u201c":20,"\u201d":20,")":7,"]":7,"a":5,"c":7,"g":4,"p":4,"s":4}},"y":{"d":"44,6r-40,-176v-3,-10,-2,-10,40,-10r19,134v1,-15,11,-95,15,-123v1,-11,2,-11,43,-11r-41,188v-10,47,-22,61,-51,61v-40,1,-36,-18,-28,-39v18,8,42,14,43,-24","w":122,"k":{"\u2026":19,"\u2019":23,"\u2018":23,"\u2014":6,"\u2013":6,"\u00ff":2,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":2,"\u00ef":3,"\u00ee":3,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":11,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"r":7,"q":6,"m":2,"k":4,"_":17,"\/":14,",":19,"'":23,"d":6,"u":4,"e":8,"o":7,"\"":23,"-":6,"\u201c":23,"\u201d":23,")":11,"]":11,".":19,"a":2,"c":11,"g":7,"p":4,"s":4}},"z":{"d":"18,-180r82,0v4,4,6,18,0,31r-49,112v17,0,44,0,51,-5v4,17,4,42,-15,42r-77,0v-3,0,-10,-25,-3,-34r52,-113v-17,0,-39,-1,-53,2v-2,-18,-3,-35,12,-35","w":108,"k":{"\u2019":17,"\u2018":17,"\u2014":8,"\u2013":8,"\u00ff":3,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"q":5,"'":17,"d":5,"u":4,"e":5,"o":4,"\u00f8":4,"\"":17,"-":8,"\u201c":17,"\u201d":17,")":7,"]":7,"x":4,"c":5,"g":4}},"|":{"d":"72,-293r0,356v0,9,0,9,-41,9r0,-355v0,-10,0,-10,41,-10","w":103},"\u00a1":{"d":"64,-157v0,14,-9,26,-25,26v-19,0,-26,-10,-26,-26v0,-14,10,-26,26,-26v20,0,25,10,25,26xm59,-95r7,154v0,11,-7,12,-57,12r9,-147v1,-18,9,-19,41,-19","w":72,"k":{"j":-33,"\/":-9}},"\u00a2":{"d":"105,-220r0,39v21,7,16,14,11,39v-33,-10,-47,-13,-50,56v-2,65,17,56,49,47v6,24,5,38,-20,42v1,31,3,45,-37,42r0,-44v-21,-6,-32,-25,-32,-85v0,-64,20,-88,42,-96v-2,-30,-1,-42,37,-40","k":{"\u201d":14,"\u201c":14,"]":11,")":11,"\"":14,"\u2019":14,"\u2018":14,"'":14}},"\u00a5":{"d":"53,0r0,-62r-45,0v-4,-41,15,-32,45,-33v1,-12,-5,-19,-7,-28r-38,0v0,-31,4,-35,28,-33r-28,-90v-2,-6,-1,-6,46,-6v7,33,17,70,19,105v3,-32,13,-69,20,-98v2,-7,2,-7,43,-7r-28,96r30,0v3,38,-12,33,-40,33v-2,9,-6,16,-5,28r45,0v4,41,-15,32,-45,33r0,55v0,7,1,7,-40,7","k":{"\/":8}},"\u00a8":{"d":"0,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm52,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22","w":95},"\u00a9":{"d":"91,-238v15,0,19,6,14,19v-18,-1,-23,-8,-25,27v-1,26,10,22,24,19v5,14,2,20,-14,20v-22,0,-31,-5,-31,-39v0,-40,17,-46,32,-46xm12,-195v0,-54,28,-78,77,-78v50,0,72,21,72,77v0,51,-26,81,-76,81v-50,0,-73,-26,-73,-80xm41,-196v0,40,16,53,45,53v23,0,45,-12,45,-53v0,-33,-12,-51,-43,-51v-27,0,-47,12,-47,51","w":172,"k":{"\/":36}},"\u00ab":{"d":"2,-90v0,-16,51,-90,51,-90v15,0,24,21,24,21v0,18,-37,69,-37,69v0,0,37,48,37,67v0,0,-9,23,-24,23v0,0,-51,-73,-51,-90xm68,-90v0,-15,50,-81,50,-81v15,0,23,19,23,19v0,17,-35,62,-35,62v0,0,36,41,36,59v0,0,-9,21,-24,21v0,0,-50,-65,-50,-80","w":149,"k":{"T":22,"V":8,"W":9,"Y":11,"\u00dd":11}},"\u00ae":{"d":"12,-195v0,-54,28,-78,77,-78v50,0,72,21,72,77v0,51,-26,81,-76,81v-50,0,-73,-26,-73,-80xm41,-196v0,40,16,53,45,53v23,0,45,-12,45,-53v0,-33,-12,-51,-43,-51v-27,0,-47,12,-47,51xm66,-152v2,-28,-3,-65,2,-87v37,-9,54,27,33,49v5,4,11,13,12,34v1,6,-12,4,-18,4v-2,-21,-1,-32,-13,-32v-5,16,15,37,-16,32xm92,-214v0,-8,-2,-12,-10,-11r0,26v8,0,9,0,10,-15","w":172,"k":{"\/":34}},"\u00b4":{"d":"15,-201v-10,0,-15,-22,-15,-22v25,-29,57,-69,66,-13v-9,10,-47,35,-51,35","w":65},"\u00b7":{"d":"17,-96v0,-14,9,-27,25,-27v19,0,26,11,26,27v0,14,-10,25,-26,25v-20,0,-25,-9,-25,-25","w":84},"\u00b8":{"d":"14,-1r20,0r-4,22v15,-1,21,4,24,25v4,29,-37,41,-54,28v0,0,3,-15,6,-18v3,-1,29,11,26,-7v6,-17,-24,-11,-25,-9","w":54},"\u00bb":{"d":"147,-90v0,17,-51,90,-51,90v0,0,-24,-7,-24,-23v0,-19,37,-67,37,-67v0,0,-37,-51,-37,-69v0,-14,24,-21,24,-21v0,0,51,74,51,90xm80,-90v0,17,-51,82,-51,82v0,0,-22,-7,-22,-23v0,-19,35,-59,35,-59v3,0,-34,-44,-34,-62v0,-14,21,-21,21,-21v0,0,51,67,51,83","w":149,"k":{"T":22,"V":8,"W":11,"Y":20,"\u00dd":20,")":4,"]":4,"J":17,"X":9,"z":5}},"\u00bf":{"d":"86,-157v0,14,-10,27,-26,27v-19,0,-25,-11,-25,-27v0,-14,9,-25,25,-25v20,0,26,9,26,25xm85,-76v-3,38,-36,64,-36,86v0,12,6,20,23,20v17,0,24,-8,24,-8v4,12,7,22,7,33v0,10,-27,16,-48,16v-35,0,-50,-22,-50,-50v0,-45,23,-60,37,-86v5,-23,-13,-41,24,-41v18,0,15,6,19,30","w":112,"k":{"\u201d":26,"\u201c":26,"j":-34,"\"":26,"\u2019":26,"\u2018":26,"'":26}},"\u00c0":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0xm86,-272v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":157,"k":{"\u201d":39,"\u201c":39,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":11,")":7,"\"":39,"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-3,"*":17,"'":39}},"\u00c1":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0xm75,-273v-10,0,-16,-22,-16,-22v25,-28,58,-70,66,-13v-9,10,-46,35,-50,35","w":157,"k":{"\u201d":39,"\u201c":39,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":11,")":7,"\"":39,"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-5,"*":17,"'":39}},"\u00c2":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0xm72,-333v25,-8,43,34,55,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-22,-2,-27,-10","w":157,"k":{"\u201d":39,"\u201c":39,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":11,")":7,"\"":39,"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-3,"*":17,"'":39}},"\u00c3":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0xm24,-297v13,-21,32,-30,45,-30v15,0,17,16,30,16v15,0,15,-11,22,-11v8,0,13,22,13,22v0,0,-20,27,-43,27v-18,0,-14,-15,-28,-15v-11,0,-15,11,-20,11v-11,0,-19,-20,-19,-20","w":157,"k":{"\u201d":39,"\u201c":39,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":11,")":7,"\"":39,"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-8,"*":17,"'":39}},"\u00c4":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0xm32,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm85,-298v0,-12,7,-22,21,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-21,-8,-21,-22","w":157,"k":{"\u201d":39,"\u201c":39,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":11,")":7,"\"":39,"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-5,"*":17,"'":39}},"\u00c5":{"d":"115,0r-12,-57r-48,0r-10,50v0,11,-28,8,-44,6r60,-244v1,-10,25,-8,35,-6r60,245v0,10,-24,7,-41,6xm79,-195r-16,101r32,0xm41,-307v0,-26,15,-38,39,-38v25,0,36,8,36,37v0,26,-14,38,-39,38v-24,0,-36,-8,-36,-37xm68,-307v0,8,4,11,10,11v6,0,11,-2,11,-11v0,-8,-3,-12,-9,-12v-7,0,-12,4,-12,12","w":157,"k":{"\u201d":39,"\u201c":39,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":11,")":7,"\"":39,"\u2019":39,"\u2018":39,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-3,"*":17,"'":39}},"\u00c6":{"d":"153,-36r50,0v0,34,0,36,-7,36r-84,0r0,-57r-45,0r-17,50v-3,11,-27,8,-44,6r90,-244v2,-5,7,-7,13,-7r97,0v8,61,-20,28,-53,36r0,61r43,0v5,54,-11,33,-43,37r0,82xm112,-210v-9,41,-20,81,-33,116r33,0r0,-116","w":209,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"y":4,"w":4,"u":4,"o":7,"g":4,"e":5,"d":6,"c":6,"a":3,"-":7,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fd":4,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":6,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"r":4,"q":6,"'":-4}},"\u00c7":{"d":"80,-257v46,-1,35,24,28,45v-39,-17,-57,2,-58,91v-1,82,11,89,57,76v11,24,4,50,-29,50r-2,16v15,-1,21,5,24,25v4,28,-37,42,-54,28v0,0,2,-15,5,-18v4,-1,30,11,27,-7v6,-17,-24,-11,-25,-9r5,-35v-34,-4,-50,-30,-50,-123v0,-118,40,-139,72,-139","w":116,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":3,"y":21,"x":4,"w":15,"v":17,"u":6,"t":7,"o":3,"f":7,"e":6,"d":3,"c":3,"a":3,"O":6,"G":3,"C":6,".":-3,"-":28,"\"":-4,"\u2026":-3,"\u2019":-4,"\u2018":-4,"\u2014":28,"\u2013":28,"\u00ff":21,"\u00fd":21,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":3,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":6,"q":3,"Q":6,"0":8,"\/":-5,",":-3,"'":-4,"\u00ab":5}},"\u00c8":{"d":"51,-36r51,0v0,34,0,36,-7,36r-84,0r0,-245v0,0,0,-7,7,-7r86,0v8,61,-20,28,-53,36r0,61r44,0v5,55,-12,32,-44,37r0,82xm68,-272v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":108,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"y":4,"w":4,"u":4,"o":7,"e":5,"d":6,"a":3,"-":7,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fd":4,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"r":4,"q":6,"'":-4}},"\u00c9":{"d":"51,-36r51,0v0,34,0,36,-7,36r-84,0r0,-245v0,0,0,-7,7,-7r86,0v8,61,-20,28,-53,36r0,61r44,0v5,55,-12,32,-44,37r0,82xm57,-273v-10,0,-16,-22,-16,-22v25,-28,58,-70,66,-13v-9,10,-46,35,-50,35","w":108,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"y":4,"w":4,"u":4,"o":7,"e":5,"d":6,"a":3,"-":7,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fd":4,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"r":4,"q":6,"'":-4}},"\u00ca":{"d":"51,-36r51,0v0,34,0,36,-7,36r-84,0r0,-245v0,0,0,-7,7,-7r86,0v8,61,-20,28,-53,36r0,61r44,0v5,55,-12,32,-44,37r0,82xm54,-333v25,-8,43,34,55,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-22,-2,-27,-10","w":108,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"y":4,"w":4,"v":17,"u":4,"t":14,"o":7,"f":8,"e":5,"d":6,"a":3,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":7,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fd":4,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"r":4,"q":6,"\\":28,"7":11,"\/":-6,"'":-4}},"\u00cb":{"d":"51,-36r51,0v0,34,0,36,-7,36r-84,0r0,-245v0,0,0,-7,7,-7r86,0v8,61,-20,28,-53,36r0,61r44,0v5,55,-12,32,-44,37r0,82xm14,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm67,-298v0,-12,7,-22,21,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-21,-8,-21,-22","w":108,"k":{"\u201d":-4,"\u201c":-4,"\u00f8":7,"y":4,"w":4,"v":17,"u":4,"t":14,"o":7,"f":8,"e":5,"d":6,"a":3,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"-":7,"\"":-4,"\u2019":-4,"\u2018":-4,"\u2014":7,"\u2013":7,"\u00ff":4,"\u00fd":4,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"r":4,"q":6,"\\":28,"7":11,"\/":-14,"'":-4}},"\u00cc":{"d":"10,0r0,-234v0,-18,1,-18,41,-18r0,245v0,7,0,7,-41,7xm38,-272v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,36,26,48,43v0,0,-6,22,-16,22","w":62},"\u00cd":{"d":"10,0r0,-234v0,-18,1,-18,41,-18r0,245v0,7,0,7,-41,7xm27,-273v-10,0,-15,-22,-15,-22v25,-29,57,-69,65,-13v-9,10,-46,35,-50,35","w":62},"\u00ce":{"d":"10,0r0,-234v0,-18,1,-18,41,-18r0,245v0,7,0,7,-41,7xm25,-333v25,-8,42,33,54,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-21,-2,-26,-10","w":62,"k":{"\u201d":-20,"\u201c":-20,"]":-24,")":-24,"\"":-20,"\u2019":-20,"\u2018":-20,"'":-20}},"\u00cf":{"d":"10,0r0,-234v0,-18,1,-18,41,-18r0,245v0,7,0,7,-41,7xm-15,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm37,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22","w":62,"k":{"\u201d":-11,"\u201c":-11,"\"":-11,"\u2019":-11,"\u2018":-11,"'":-11}},"\u00d1":{"d":"105,0v-22,-57,-47,-107,-59,-175v7,58,5,108,5,168v0,7,0,7,-40,7r0,-245v1,-14,26,-4,39,-7v20,54,45,106,58,168v-6,-57,-3,-102,-4,-161v0,-7,0,-7,40,-7r0,245v-1,13,-26,5,-39,7xm25,-297v13,-21,32,-30,45,-30v15,0,16,16,29,16v15,0,15,-11,22,-11v8,0,13,22,13,22v0,0,-20,27,-43,27v-18,0,-14,-15,-28,-15v-11,0,-14,11,-19,11v-11,0,-19,-20,-19,-20","w":154,"k":{"\u201d":-3,"\u201c":-3,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"\"":-3,"\u2019":-3,"\u2018":-3,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-14,"'":-3}},"\u00d2":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,101,-21,132,-68,132v-47,0,-65,-23,-65,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96xm82,-272v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":146,"k":{"\u201d":4,"\u201c":4,"x":6,"]":7,"Y":9,"X":8,"W":5,"V":5,"T":5,"J":12,"A":8,".":9,")":7,"\"":4,"\u2026":9,"\u2019":4,"\u2018":4,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":20,",":9,"'":4}},"\u00d3":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,101,-21,132,-68,132v-47,0,-65,-23,-65,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96xm71,-273v-10,0,-16,-22,-16,-22v25,-28,58,-70,66,-13v-9,10,-46,35,-50,35","w":146,"k":{"\u201d":4,"\u201c":4,"x":6,"]":7,"Y":9,"X":8,"W":5,"V":5,"T":5,"J":12,"A":8,".":9,")":7,"\"":4,"\u2026":9,"\u2019":4,"\u2018":4,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":20,",":9,"'":4}},"\u00d4":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,101,-21,132,-68,132v-47,0,-65,-23,-65,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96xm68,-333v25,-8,43,34,55,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-22,-2,-27,-10","w":146,"k":{"\u201d":4,"\u201c":4,"\u00f8":5,"y":18,"x":6,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":9,"X":8,"W":5,"V":5,"T":5,"Q":6,"O":6,"J":12,"G":6,"C":11,"A":8,".":9,")":7,"\"":4,"\u2026":9,"\u2019":4,"\u2018":4,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d8":6,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":6,"\u00d2":6,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":11,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":20,"\\":28,"7":11,"\/":3,",":9,"'":4}},"\u00d5":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,101,-21,132,-68,132v-47,0,-65,-23,-65,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96xm21,-297v13,-21,32,-30,45,-30v15,0,16,16,29,16v15,0,15,-11,22,-11v8,0,13,22,13,22v0,0,-20,27,-43,27v-18,0,-14,-15,-28,-15v-11,0,-15,11,-20,11v-11,0,-18,-20,-18,-20","w":146,"k":{"\u201d":4,"\u201c":4,"\u00f8":5,"y":18,"x":6,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":9,"X":8,"W":5,"V":5,"T":5,"Q":6,"O":6,"J":12,"G":6,"C":11,"A":8,".":9,")":7,"\"":4,"\u2026":9,"\u2019":4,"\u2018":4,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d8":6,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":6,"\u00d2":6,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":11,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":20,"\\":28,"7":11,"\/":3,",":9,"'":4}},"\u00d6":{"d":"7,-127v0,-98,23,-128,69,-128v47,0,64,27,64,126v0,101,-21,132,-68,132v-47,0,-65,-23,-65,-130xm53,-118v0,56,3,79,21,79v18,0,22,-24,22,-88v0,-63,-2,-87,-21,-87v-17,0,-22,25,-22,96xm28,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm81,-298v0,-12,7,-22,21,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-21,-8,-21,-22","w":146,"k":{"\u201d":4,"\u201c":4,"\u00f8":5,"y":18,"x":6,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"]":7,"Y":9,"X":8,"W":5,"V":5,"T":5,"Q":6,"O":6,"J":12,"G":6,"C":11,"A":8,".":9,")":7,"\"":4,"\u2026":9,"\u2019":4,"\u2018":4,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d8":6,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":6,"\u00d2":6,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":11,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":20,"\\":28,"7":11,"\/":3,",":9,"'":4}},"\u00d7":{"d":"125,-69v-30,39,-32,11,-53,-7v-20,18,-23,46,-53,7r29,-33r-29,-32v30,-39,32,-11,53,7v20,-18,23,-46,53,-7r-30,32"},"\u00d8":{"d":"30,5v-39,0,-18,-28,-8,-55v-4,-19,-5,-44,-5,-77v0,-98,21,-129,67,-129v19,0,34,5,44,18v4,-9,7,-18,9,-21v0,0,23,3,25,12v1,5,-11,38,-17,55v3,17,4,38,4,63v0,101,-21,133,-68,133v-19,0,-34,-4,-44,-16xm63,-118r0,20r35,-108v-3,-5,-8,-8,-14,-8v-17,0,-21,25,-21,96xm105,-127r0,-22v-13,39,-27,84,-35,107v28,10,32,5,35,-85","w":165,"k":{"\u201d":4,"\u201c":4,"z":11,"y":11,"x":6,"w":11,"u":7,"t":7,"s":7,"p":7,"h":4,"g":11,"e":11,"d":11,"c":8,"a":9,"Y":9,"X":8,"W":5,"V":5,"T":5,"J":12,"A":8,".":9,"-":11,"\"":4,"\u2026":9,"\u2019":4,"\u2018":4,"\u2014":11,"\u2013":11,"\u00ff":11,"\u00fd":11,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f1":9,"\u00ef":9,"\u00ee":9,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":8,"\u00e6":9,"\u00e5":9,"\u00e4":9,"\u00e3":9,"\u00e2":9,"\u00e1":9,"\u00e0":9,"\u00dd":9,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"r":11,"q":7,"k":4,"_":20,"0":9,",":9,"'":4,")":7,"]":7}},"\u00d9":{"d":"53,-252r0,184v-5,34,21,41,43,30r0,-206v0,-8,0,-8,41,-8r0,242v-9,6,-31,14,-62,14v-57,0,-64,-33,-64,-73r0,-175v0,-8,0,-8,42,-8xm80,-272v-4,0,-41,-25,-50,-35v2,-13,10,-30,19,-30v4,0,35,26,47,43v0,0,-6,22,-16,22","w":147},"\u00da":{"d":"53,-252r0,184v-5,34,21,41,43,30r0,-206v0,-8,0,-8,41,-8r0,242v-9,6,-31,14,-62,14v-57,0,-64,-33,-64,-73r0,-175v0,-8,0,-8,42,-8xm69,-273v-10,0,-15,-22,-15,-22v25,-29,57,-69,66,-13v-9,10,-47,35,-51,35","w":147},"\u00db":{"d":"53,-252r0,184v-5,34,21,41,43,30r0,-206v0,-8,0,-8,41,-8r0,242v-9,6,-31,14,-62,14v-57,0,-64,-33,-64,-73r0,-175v0,-8,0,-8,42,-8xm67,-333v25,-8,42,33,54,50v0,8,-13,9,-27,9v0,0,-12,-10,-19,-24v0,0,-14,24,-23,24v-13,0,-21,-2,-26,-10","w":147,"k":{"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"\/":-5}},"\u00dc":{"d":"53,-252r0,184v-5,34,21,41,43,30r0,-206v0,-8,0,-8,41,-8r0,242v-9,6,-31,14,-62,14v-57,0,-64,-33,-64,-73r0,-175v0,-8,0,-8,42,-8xm27,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm79,-298v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22","w":147,"k":{"\u201d":3,"\u201c":3,"\u00f8":5,"y":18,"w":14,"v":17,"u":3,"t":14,"o":5,"f":8,"e":5,"d":6,"Y":29,"W":21,"V":26,"T":23,"Q":6,"O":6,"G":6,"C":11,"\"":3,"\u2019":3,"\u2018":3,"\u2014":11,"\u2013":11,"\u00ff":18,"\u00fd":18,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":29,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":11,"q":6,"\\":28,"7":11,"'":3}},"\u00dd":{"d":"47,0r0,-103r-45,-143v-2,-6,-1,-6,46,-6v8,34,18,78,21,116v2,-34,11,-78,19,-109v2,-7,2,-7,43,-7r-44,146r0,99v0,7,1,7,-40,7xm64,-273v-10,0,-15,-22,-15,-22v25,-29,57,-69,65,-13v-9,10,-46,35,-50,35","w":132,"k":{"\u201d":-7,"\u201c":-7,"\u00f8":29,"\u00c6":29,"z":18,"y":14,"x":16,"w":15,"v":14,"u":18,"t":13,"s":23,"p":26,"o":29,"n":21,"j":11,"i":7,"g":26,"f":11,"e":28,"d":28,"c":28,"a":22,"S":4,"O":9,"J":33,"G":12,"C":14,"A":29,";":20,":":20,".":25,"-":22,"\"":-7,"\u2026":25,"\u2019":-7,"\u2018":-7,"\u2014":22,"\u2013":22,"\u00ff":14,"\u00fd":14,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":29,"\u00f5":29,"\u00f4":29,"\u00f3":29,"\u00f2":29,"\u00f1":21,"\u00ef":7,"\u00ee":7,"\u00ed":7,"\u00ec":7,"\u00eb":28,"\u00ea":28,"\u00e9":28,"\u00e8":28,"\u00e7":28,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":29,"\u00db":29,"\u00d8":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d3":9,"\u00d2":9,"\u00d1":29,"\u00cb":29,"\u00ca":29,"\u00c7":14,"\u00c5":29,"\u00c4":29,"\u00c3":29,"\u00c2":29,"\u00c1":29,"\u00c0":29,"r":21,"q":28,"m":21,"_":25,"Q":9,"@":8,"0":17,"\/":20,",":25,"'":-7,"\u00ab":20,"\u00bb":17}},"\u00df":{"d":"9,-1v10,-47,4,-138,4,-197v0,-38,24,-56,60,-56v53,0,74,24,74,53v0,32,-30,31,-30,53v0,20,47,45,47,97v0,32,-19,54,-53,54v-50,0,-50,-24,-34,-44v2,6,48,15,41,-10v0,-31,-46,-57,-46,-95v0,-32,32,-37,32,-55v0,-10,-11,-15,-29,-15v-19,0,-21,12,-21,40r1,153v10,31,-36,29,-46,22","w":164,"k":{"]":4,")":4}},"\u00e0":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47xm68,-200v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":121,"k":{"\u201d":30,"\u201c":30,"y":3,"x":4,"t":4,"f":3,"]":7,")":7,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e1":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47xm57,-201v-10,0,-16,-22,-16,-22v25,-28,58,-70,66,-13v-9,10,-46,35,-50,35","w":121,"k":{"\u201d":30,"\u201c":30,"y":3,"x":4,"t":4,"f":3,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,")":7,"]":7}},"\u00e2":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47xm54,-261v25,-8,43,34,55,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-22,-2,-27,-10","w":121,"k":{"\u201d":30,"\u201c":30,"y":3,"x":4,"t":4,"f":3,"]":7,")":7,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e3":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47xm6,-225v13,-21,32,-30,45,-30v15,0,17,16,30,16v15,0,15,-11,22,-11v8,0,13,22,13,22v0,0,-20,27,-43,27v-18,0,-14,-15,-28,-15v-11,0,-15,11,-20,11v-11,0,-19,-20,-19,-20","w":121,"k":{"\u201d":30,"\u201c":30,"y":3,"x":4,"f":3,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,"t":4,")":7,"]":7}},"\u00e4":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47xm14,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm67,-226v0,-12,7,-22,21,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-21,-8,-21,-22","w":121,"k":{"\u201d":30,"\u201c":30,"y":3,"x":4,"t":4,"f":3,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,")":7,"]":7}},"\u00e5":{"d":"13,-137v-14,-39,4,-45,54,-47v40,-2,45,21,45,61v0,41,0,88,-2,115v-38,15,-106,31,-103,-45v2,-61,28,-65,65,-54v-1,-17,6,-39,-15,-38v-13,0,-32,4,-44,8xm72,-80v-16,-5,-21,-3,-22,26v-1,23,7,29,21,21v1,-8,1,-32,1,-47xm23,-235v0,-26,15,-38,39,-38v25,0,36,8,36,37v0,26,-14,38,-39,38v-24,0,-36,-8,-36,-37xm50,-235v0,8,4,11,10,11v6,0,11,-2,11,-11v0,-8,-3,-12,-9,-12v-7,0,-12,4,-12,12","w":121,"k":{"\u201d":30,"\u201c":30,"y":3,"x":4,"t":4,"f":3,"\"":30,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,")":7,"]":7}},"\u00e6":{"d":"13,-139v-15,-43,4,-43,56,-45v16,0,25,5,30,14v33,-28,84,-16,84,45v0,17,-1,37,-5,51v-22,2,-44,3,-62,0v-6,60,35,35,61,28v2,7,4,24,4,36v0,10,-66,21,-82,6v-40,11,-94,25,-92,-52v2,-62,27,-71,65,-58v1,-18,2,-34,-18,-34v-15,0,-29,3,-41,9xm72,-33r0,-54v-17,-8,-21,1,-22,30v-1,32,6,29,22,24xm132,-149v-10,0,-15,15,-16,44v8,2,16,3,26,2v3,-13,4,-53,-10,-46","w":192,"k":{"\u201d":22,"\u201c":22,"y":3,"x":4,"t":4,"f":3,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"'":22,"w":2,"e":4}},"\u00e7":{"d":"72,-184v29,1,36,15,26,40v-35,-8,-46,-13,-48,57v-2,55,14,62,47,50v7,25,3,36,-25,40r-4,18v15,-1,22,5,25,25v4,28,-37,42,-54,28v0,0,2,-15,5,-18v4,-1,30,11,27,-7v6,-17,-25,-11,-26,-9r6,-37v-31,-3,-43,-21,-43,-89v0,-86,34,-98,64,-98","w":105,"k":{"\u201d":14,"\u201c":14,"\u00f8":6,"y":-2,"w":-2,"t":-4,"o":6,"e":6,"d":6,"c":5,"]":4,"-":8,")":4,"\"":14,"\u2019":14,"\u2018":14,"\u2014":8,"\u2013":8,"\u00ff":-2,"\u00fd":-2,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"q":6,"\/":-5,"'":14,"\u00ab":8}},"\u00e8":{"d":"71,-184v48,0,53,66,41,110v-18,4,-44,6,-62,6v-2,44,36,34,62,22v11,35,-5,50,-48,50v-33,0,-56,-17,-56,-85v0,-87,29,-103,63,-103xm66,-149v-11,0,-15,16,-16,49v10,0,21,0,26,-3v3,-13,4,-53,-10,-46xm74,-200v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,36,26,48,43v0,0,-6,22,-16,22","w":124,"k":{"\u201d":22,"\u201c":22,"e":4,"]":7,")":7,"\"":22,"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"'":22,"w":2,"x":4}},"\u00e9":{"d":"71,-184v48,0,53,66,41,110v-18,4,-44,6,-62,6v-2,44,36,34,62,22v11,35,-5,50,-48,50v-33,0,-56,-17,-56,-85v0,-87,29,-103,63,-103xm66,-149v-11,0,-15,16,-16,49v10,0,21,0,26,-3v3,-13,4,-53,-10,-46xm63,-201v-10,0,-15,-22,-15,-22v25,-29,57,-69,65,-13v-9,10,-46,35,-50,35","w":124,"k":{"\u201d":22,"\u201c":22,"x":4,"w":2,"e":4,"\"":22,"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"'":22,")":7,"]":7}},"\u00ea":{"d":"71,-184v48,0,53,66,41,110v-18,4,-44,6,-62,6v-2,44,36,34,62,22v11,35,-5,50,-48,50v-33,0,-56,-17,-56,-85v0,-87,29,-103,63,-103xm66,-149v-11,0,-15,16,-16,49v10,0,21,0,26,-3v3,-13,4,-53,-10,-46xm61,-261v25,-8,42,33,54,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-21,-2,-26,-10","w":124,"k":{"\u201d":22,"\u201c":22,"y":3,"x":4,"w":2,"e":4,"\"":22,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"'":22,")":7,"]":7}},"\u00eb":{"d":"71,-184v48,0,53,66,41,110v-18,4,-44,6,-62,6v-2,44,36,34,62,22v11,35,-5,50,-48,50v-33,0,-56,-17,-56,-85v0,-87,29,-103,63,-103xm66,-149v-11,0,-15,16,-16,49v10,0,21,0,26,-3v3,-13,4,-53,-10,-46xm21,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm73,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22","w":124,"k":{"\u201d":22,"\u201c":22,"y":3,"x":4,"w":2,"e":4,"\"":22,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"'":22,")":7,"]":7}},"\u00ec":{"d":"53,-180r0,173v0,7,0,7,-41,7r0,-162v0,-18,8,-18,41,-18xm40,-200v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":64,"k":{"\u201d":8,"\u201c":8,"]":4,")":4,"\"":8,"\u2019":8,"\u2018":8,"\/":-8,"'":8}},"\u00ed":{"d":"53,-180r0,173v0,7,0,7,-41,7r0,-162v0,-18,8,-18,41,-18xm29,-201v-10,0,-15,-22,-15,-22v25,-29,57,-69,65,-13v-9,10,-46,35,-50,35","w":64,"k":{"\u201d":-11,"\u201c":-11,"k":-4,"h":-4,"]":-7,")":-7,"\"":-11,"\u2019":-11,"\u2018":-11,"\/":-8,"'":-11}},"\u00ee":{"d":"53,-180r0,173v0,7,0,7,-41,7r0,-162v0,-18,8,-18,41,-18xm27,-261v25,-8,42,33,54,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-21,-2,-26,-10","w":64,"k":{"\u201d":-14,"\u201c":-14,"y":3,"x":4,"k":-7,"h":-7,"\"":-14,"\u2019":-14,"\u2018":-14,"\u00ff":3,"\u00fd":3,"\/":-8,"'":-14}},"\u00ef":{"d":"53,-180r0,173v0,7,0,7,-41,7r0,-162v0,-18,8,-18,41,-18xm-13,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm39,-226v0,-12,7,-22,21,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-21,-8,-21,-22","w":64,"k":{"\u201d":-23,"\u201c":-23,"y":3,"x":4,"k":-11,"h":-11,"]":-7,")":-7,"\"":-23,"\u2019":-23,"\u2018":-23,"\u00ff":3,"\u00fd":3,"\/":-8,"'":-23}},"\u00f1":{"d":"12,0r0,-172v34,-15,108,-27,108,35r0,130v0,7,-1,7,-42,7r0,-125v2,-28,-11,-27,-26,-20r0,138v0,7,0,7,-40,7xm11,-225v13,-21,32,-30,45,-30v15,0,16,16,29,16v15,0,15,-11,22,-11v8,0,13,22,13,22v0,0,-20,27,-43,27v-18,0,-14,-15,-28,-15v-11,0,-14,11,-19,11v-11,0,-19,-20,-19,-20","w":129,"k":{"\u201d":31,"\u201c":31,"y":3,"x":4,"]":7,")":7,"\"":31,"\u2019":31,"\u2018":31,"\u00ff":3,"\u00fd":3,"\/":-11,"'":31}},"\u00f2":{"d":"5,-90v0,-65,22,-94,60,-94v39,0,56,19,56,92v0,69,-20,96,-59,96v-39,0,-57,-13,-57,-94xm50,-91v0,56,4,61,13,61v7,0,14,-6,14,-61v0,-52,-3,-58,-13,-58v-8,0,-14,7,-14,58xm71,-200v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":126,"k":{"\u201d":33,"\u201c":33,"z":4,"y":7,"x":7,"w":4,"v":4,"t":4,"f":4,"]":11,".":7,")":11,"\"":33,"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"k":4,"_":17,"\/":-6,",":7,"*":4,"'":33}},"\u00f3":{"d":"5,-90v0,-65,22,-94,60,-94v39,0,56,19,56,92v0,69,-20,96,-59,96v-39,0,-57,-13,-57,-94xm50,-91v0,56,4,61,13,61v7,0,14,-6,14,-61v0,-52,-3,-58,-13,-58v-8,0,-14,7,-14,58xm60,-201v-10,0,-16,-22,-16,-22v25,-29,57,-69,66,-13v-9,10,-46,35,-50,35","w":126,"k":{"\u201d":33,"\u201c":33,"z":4,"y":7,"x":7,"w":4,"v":4,"t":4,"f":4,"]":11,".":7,")":11,"\"":33,"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"k":4,"_":17,"\/":-6,",":7,"*":4,"'":33}},"\u00f4":{"d":"5,-90v0,-65,22,-94,60,-94v39,0,56,19,56,92v0,69,-20,96,-59,96v-39,0,-57,-13,-57,-94xm50,-91v0,56,4,61,13,61v7,0,14,-6,14,-61v0,-52,-3,-58,-13,-58v-8,0,-14,7,-14,58xm57,-261v25,-8,43,34,55,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-14,24,-23,24v-13,0,-21,-2,-26,-10","w":126,"k":{"\u201d":33,"\u201c":33,"z":4,"y":7,"x":7,"w":4,"v":4,"t":4,"f":4,"]":11,".":7,")":11,"\"":33,"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"k":4,"_":17,"\/":-6,",":7,"*":4,"'":33}},"\u00f5":{"d":"5,-90v0,-65,22,-94,60,-94v39,0,56,19,56,92v0,69,-20,96,-59,96v-39,0,-57,-13,-57,-94xm50,-91v0,56,4,61,13,61v7,0,14,-6,14,-61v0,-52,-3,-58,-13,-58v-8,0,-14,7,-14,58xm9,-225v13,-21,32,-30,45,-30v15,0,17,16,30,16v15,0,14,-11,21,-11v27,21,7,39,-29,49v-18,0,-14,-15,-28,-15v-11,0,-15,11,-20,11v-11,0,-19,-20,-19,-20","w":126,"k":{"\u201d":33,"\u201c":33,"z":4,"y":7,"x":7,"w":4,"v":4,"t":4,"f":4,".":7,"\"":33,"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"k":4,"_":17,"\/":-6,",":7,"*":4,"'":33,")":11,"]":11}},"\u00f6":{"d":"5,-90v0,-65,22,-94,60,-94v39,0,56,19,56,92v0,69,-20,96,-59,96v-39,0,-57,-13,-57,-94xm50,-91v0,56,4,61,13,61v7,0,14,-6,14,-61v0,-52,-3,-58,-13,-58v-8,0,-14,7,-14,58xm17,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm69,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22","w":126,"k":{"\u201d":33,"\u201c":33,"z":4,"y":7,"x":7,"w":4,"v":4,"t":4,"f":4,"]":11,".":7,")":11,"\"":33,"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"k":4,"_":17,"\/":-6,",":7,"*":4,"'":33}},"\u00f7":{"d":"128,-84r-119,0v0,-24,0,-35,7,-35r119,0v0,24,0,35,-7,35xm50,-44v0,-12,8,-22,22,-22v17,0,22,8,22,22v0,12,-8,23,-22,23v-17,0,-22,-9,-22,-23xm50,-158v0,-12,8,-22,22,-22v17,0,22,8,22,22v0,12,-8,23,-22,23v-17,0,-22,-9,-22,-23"},"\u00f8":{"d":"23,11v-32,-6,-21,-25,-5,-49v-3,-13,-4,-30,-4,-52v0,-86,48,-114,98,-80v5,-9,10,-15,12,-18v0,0,22,7,22,16v0,4,-10,24,-19,40v1,11,3,25,3,40v4,89,-43,113,-97,85xm72,-30v7,0,13,-6,13,-61r-25,47v2,13,7,14,12,14xm58,-91r0,2r25,-48v-2,-10,-5,-12,-11,-12v-8,0,-14,7,-14,58","w":143,"k":{"\u201d":33,"\u201c":33,"y":7,"w":4,"t":4,"g":7,"f":4,"]":11,")":11,"\"":33,"\u2026":7,"\u2019":33,"\u2018":33,"\u00ff":7,"\u00fd":7,"_":17,"\/":-6,",":7,"*":4,"'":33,"v":4,".":7,"x":7,"z":4}},"\u00f9":{"d":"118,-180r0,170v-12,7,-31,14,-53,14v-88,3,-45,-106,-55,-177v0,-7,0,-7,42,-7r0,132v-3,19,16,21,26,12r0,-137v0,-7,-1,-7,40,-7xm72,-200v-4,0,-41,-25,-50,-35v2,-13,9,-30,18,-30v4,0,35,26,47,43v0,0,-5,22,-15,22","w":129,"k":{"\u201d":23,"\u201c":23,"]":7,")":7,"\"":23,"\u2019":23,"\u2018":23,"\/":-5,"'":23}},"\u00fa":{"d":"118,-180r0,170v-12,7,-31,14,-53,14v-88,3,-45,-106,-55,-177v0,-7,0,-7,42,-7r0,132v-3,19,16,21,26,12r0,-137v0,-7,-1,-7,40,-7xm61,-201v-10,0,-16,-22,-16,-22v25,-28,58,-70,66,-13v-9,10,-46,35,-50,35","w":129,"k":{"\u201d":23,"\u201c":23,"\"":23,"\u2019":23,"\u2018":23,"\/":-5,"'":23,")":7,"]":7}},"\u00fb":{"d":"118,-180r0,170v-12,7,-31,14,-53,14v-88,3,-45,-106,-55,-177v0,-7,0,-7,42,-7r0,132v-3,19,16,21,26,12r0,-137v0,-7,-1,-7,40,-7xm58,-261v25,-8,43,34,55,50v0,8,-14,9,-28,9v0,0,-12,-10,-19,-24v0,0,-13,24,-22,24v-13,0,-22,-2,-27,-10","w":129,"k":{"\u201d":23,"\u201c":23,"y":3,"x":4,"]":7,")":7,"\"":23,"\u2019":23,"\u2018":23,"\u00ff":3,"\u00fd":3,"\/":-5,"'":23}},"\u00fc":{"d":"118,-180r0,170v-12,7,-31,14,-53,14v-88,3,-45,-106,-55,-177v0,-7,0,-7,42,-7r0,132v-3,19,16,21,26,12r0,-137v0,-7,-1,-7,40,-7xm18,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm71,-226v0,-12,7,-22,21,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-21,-8,-21,-22","w":129,"k":{"\u201d":23,"\u201c":23,"y":3,"x":4,"\"":23,"\u2019":23,"\u2018":23,"\u00ff":3,"\u00fd":3,"\/":-5,"'":23,")":7,"]":7}},"\u00fd":{"d":"44,6r-40,-176v-3,-10,-2,-10,40,-10r19,134v1,-15,11,-95,15,-123v1,-11,2,-11,43,-11r-41,188v-10,47,-22,61,-51,61v-40,1,-36,-18,-28,-39v18,8,42,14,43,-24xm59,-201v-10,0,-16,-22,-16,-22v25,-29,57,-69,66,-13v-9,10,-46,35,-50,35","w":122,"k":{"\u201d":23,"\u201c":23,"u":4,"s":4,"p":4,"o":7,"g":7,"e":8,"d":6,"c":11,"a":2,".":19,"-":6,"\"":23,"\u2026":19,"\u2019":23,"\u2018":23,"\u2014":6,"\u2013":6,"\u00ff":2,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":2,"\u00ef":3,"\u00ee":3,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":11,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"r":7,"q":6,"m":2,"k":4,"_":17,"\/":14,",":19,"'":23,")":11,"]":11}},"\u00ff":{"d":"44,6r-40,-176v-3,-10,-2,-10,40,-10r19,134v1,-15,11,-95,15,-123v1,-11,2,-11,43,-11r-41,188v-10,47,-22,61,-51,61v-40,1,-36,-18,-28,-39v18,8,42,14,43,-24xm16,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22xm68,-226v0,-12,8,-22,22,-22v17,0,22,9,22,22v0,12,-8,22,-22,22v-17,0,-22,-8,-22,-22","w":122,"k":{"\u201d":23,"\u201c":23,"y":3,"x":4,"u":4,"s":4,"p":4,"o":7,"g":7,"e":8,"d":6,"c":11,"a":2,"]":11,".":19,"-":6,")":11,"\"":23,"\u2026":19,"\u2019":23,"\u2018":23,"\u2014":6,"\u2013":6,"\u00ff":3,"\u00fd":3,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":2,"\u00ef":3,"\u00ee":3,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":11,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"r":7,"q":6,"m":2,"k":4,"_":17,"\/":14,",":19,"'":23}},"\u2013":{"d":"130,-84r-119,0v0,-24,0,-35,7,-35r119,0v0,24,0,35,-7,35","w":147,"k":{"\u00c6":10,"z":13,"y":9,"x":19,"w":5,"v":7,"t":9,"f":9,"]":8,"Z":17,"Y":22,"X":22,"W":8,"V":11,"T":37,"S":28,"J":45,"A":10,")":8,"\u00ff":9,"\u00fd":9,"\u00dd":22,"\u00dc":14,"\u00db":14,"\u00d6":14,"\u00d5":14,"\u00d4":14,"\u00d1":14,"\u00cb":14,"\u00ca":14,"\u00c5":10,"\u00c4":10,"\u00c3":10,"\u00c2":10,"\u00c1":10,"\u00c0":10,"\\":31}},"\u2014":{"d":"243,-84r-241,0v0,-24,0,-35,7,-35r241,0v0,24,0,35,-7,35","w":252,"k":{"\u00c6":10,"z":13,"y":9,"x":19,"w":5,"v":7,"t":9,"f":9,"]":8,"Z":17,"Y":22,"X":22,"W":8,"V":11,"T":37,"S":28,"J":45,"A":10,")":8,"\u00ff":9,"\u00fd":9,"\u00dd":22,"\u00dc":14,"\u00db":14,"\u00d6":14,"\u00d5":14,"\u00d4":14,"\u00d1":14,"\u00cb":14,"\u00ca":14,"\u00c5":10,"\u00c4":10,"\u00c3":10,"\u00c2":10,"\u00c1":10,"\u00c0":10,"\\":31}},"\u2018":{"d":"49,-250v19,11,9,45,-13,45v-17,0,-26,-9,-26,-26v0,-30,26,-57,34,-57v7,0,13,2,15,11v-8,14,-9,18,-10,27","w":69,"k":{"z":25,"y":25,"x":22,"w":26,"v":25,"u":26,"t":5,"s":31,"p":34,"o":34,"n":34,"g":36,"f":17,"e":38,"d":37,"c":31,"a":25,"]":-7,"[":28,"Y":-7,"W":-7,"V":-7,"T":-4,"O":7,"J":50,"G":14,"C":23,"A":45,")":-7,"(":28,"\u00ff":25,"\u00fd":25,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":34,"\u00ef":-23,"\u00ee":-14,"\u00ec":-20,"\u00eb":38,"\u00ea":38,"\u00e9":38,"\u00e8":38,"\u00e7":31,"\u00e6":25,"\u00e5":25,"\u00e4":25,"\u00e3":25,"\u00e2":25,"\u00e1":25,"\u00e0":25,"\u00dd":-7,"\u00dc":3,"\u00db":3,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-11,"\u00ce":-17,"\u00cb":9,"\u00ca":3,"\u00c7":23,"\u00c6":45,"\u00c5":45,"\u00c4":45,"\u00c3":45,"\u00c2":45,"\u00c1":45,"\u00c0":45,"\u00bf":40,"\u00a2":31,"r":34,"q":37,"m":34,"\\":-14,"Q":7,"@":28,"?":-7,"9":19,"6":11,"4":39,"2":9,"1":14,"0":14,"\/":51}},"\u2019":{"d":"21,-243v-19,-10,-12,-45,12,-45v17,0,26,9,26,26v0,30,-25,56,-33,56v-7,0,-13,-1,-15,-10v8,-14,9,-18,10,-27","w":69,"k":{"z":25,"y":25,"x":22,"w":26,"v":25,"u":26,"t":5,"s":31,"p":34,"o":34,"n":34,"g":36,"f":17,"e":38,"d":37,"c":31,"a":25,"]":-7,"[":28,"Y":-7,"W":-7,"V":-7,"T":-4,"O":7,"J":50,"G":14,"C":23,"A":45,")":-7,"(":28,"\u00ff":25,"\u00fd":25,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":34,"\u00ef":-23,"\u00ee":-14,"\u00ec":-20,"\u00eb":38,"\u00ea":38,"\u00e9":38,"\u00e8":38,"\u00e7":31,"\u00e6":25,"\u00e5":25,"\u00e4":25,"\u00e3":25,"\u00e2":25,"\u00e1":25,"\u00e0":25,"\u00dd":-7,"\u00dc":3,"\u00db":3,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-11,"\u00ce":-17,"\u00cb":9,"\u00ca":3,"\u00c7":23,"\u00c6":45,"\u00c5":45,"\u00c4":45,"\u00c3":45,"\u00c2":45,"\u00c1":45,"\u00c0":45,"\u00bf":40,"\u00a2":31,"r":34,"q":37,"m":34,"\\":-14,"Q":7,"@":28,"?":-7,"9":19,"6":11,"4":39,"2":9,"1":14,"0":14,"\/":51}},"\u201c":{"d":"49,-250v19,11,9,45,-13,45v-17,0,-26,-9,-26,-26v0,-30,26,-57,34,-57v7,0,13,2,15,11v-8,14,-9,18,-10,27xm108,-250v19,11,9,45,-13,45v-17,0,-26,-9,-26,-26v0,-30,26,-57,34,-57v7,0,13,2,15,11v-8,14,-9,18,-10,27","w":128,"k":{"\u00ff":25,"\u00fd":25,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":34,"\u00ef":-23,"\u00ee":-14,"\u00ec":-20,"\u00eb":38,"\u00ea":38,"\u00e9":38,"\u00e8":38,"\u00e7":31,"\u00e6":25,"\u00e5":25,"\u00e4":25,"\u00e3":25,"\u00e2":25,"\u00e1":25,"\u00e0":25,"\u00dd":-7,"\u00dc":3,"\u00db":3,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-11,"\u00ce":-17,"\u00cb":9,"\u00ca":3,"\u00c7":23,"\u00c6":45,"\u00c5":45,"\u00c4":45,"\u00c3":45,"\u00c2":45,"\u00c1":45,"\u00c0":45,"\u00bf":40,"\u00a2":31,"r":34,"q":37,"m":34,"\\":-14,"Q":7,"@":28,"?":-7,"9":19,"6":11,"4":39,"2":9,"1":14,"0":14,"\/":51,"C":23,"G":14,"T":-4,"V":-7,"W":-7,"Y":-7,"d":37,"f":17,"t":5,"u":26,"v":25,"w":26,"y":25,"e":38,"o":34,"O":7,")":-7,"]":-7,"A":45,"J":50,"x":22,"a":25,"c":31,"g":36,"z":25,"n":34,"p":34,"s":31,"(":28,"[":28}},"\u201d":{"d":"80,-243v-20,-11,-11,-45,13,-45v17,0,25,9,25,26v0,30,-25,56,-33,56v-7,0,-13,-1,-15,-10v8,-14,9,-18,10,-27xm21,-243v-19,-10,-12,-45,12,-45v17,0,26,9,26,26v0,30,-25,56,-33,56v-7,0,-13,-1,-15,-10v8,-14,9,-18,10,-27","w":128,"k":{"\u00ff":25,"\u00fd":25,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":34,"\u00ef":-23,"\u00ee":-14,"\u00ec":-20,"\u00eb":38,"\u00ea":38,"\u00e9":38,"\u00e8":38,"\u00e7":31,"\u00e6":25,"\u00e5":25,"\u00e4":25,"\u00e3":25,"\u00e2":25,"\u00e1":25,"\u00e0":25,"\u00dd":-7,"\u00dc":3,"\u00db":3,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-11,"\u00ce":-17,"\u00cb":9,"\u00ca":3,"\u00c7":23,"\u00c6":45,"\u00c5":45,"\u00c4":45,"\u00c3":45,"\u00c2":45,"\u00c1":45,"\u00c0":45,"\u00bf":40,"\u00a2":31,"r":34,"q":37,"m":34,"\\":-14,"Q":7,"@":28,"?":-7,"9":19,"6":11,"4":39,"2":9,"1":14,"0":14,"\/":51,"C":23,"G":14,"T":-4,"V":-7,"W":-7,"Y":-7,"d":37,"f":17,"t":5,"u":26,"v":25,"w":26,"y":25,"e":38,"o":34,"O":7,")":-7,"]":-7,"A":45,"J":50,"x":22,"a":25,"c":31,"g":36,"z":25,"n":34,"p":34,"s":31,"(":28,"[":28}},"\u2026":{"d":"9,-23v0,-14,10,-26,26,-26v19,0,25,10,25,26v0,14,-9,26,-25,26v-20,0,-26,-10,-26,-26xm76,-23v0,-14,10,-26,26,-26v19,0,25,10,25,26v0,14,-9,26,-25,26v-20,0,-26,-10,-26,-26xm143,-23v0,-14,9,-26,25,-26v19,0,26,10,26,26v0,14,-10,26,-26,26v-20,0,-25,-10,-25,-26","w":202,"k":{"\u00f8":7,"y":14,"w":9,"v":16,"u":7,"t":17,"o":7,"f":14,"e":7,"d":7,"Y":25,"W":11,"V":17,"U":4,"T":34,"O":6,"G":5,"C":9,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00dd":25,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":7,"\\":48,"Q":6}},"\u2122":{"d":"84,-137r0,-112v0,-4,13,-3,18,-3r17,57r15,-54v2,-6,12,-2,19,-3r0,112v0,3,0,3,-19,3v0,-20,3,-73,5,-80v-7,22,-8,37,-18,52v-20,-6,-12,-29,-23,-52v2,6,5,58,5,77v0,3,-2,3,-19,3xm75,-252v4,21,-10,17,-23,17r0,95v0,3,0,3,-19,3r0,-98r-24,0v0,-5,-2,-17,3,-17r63,0","w":170,"k":{"\/":31}},"\u00d0":{"d":"11,-245v1,-13,30,-7,44,-7v48,0,71,21,71,109v0,125,-20,151,-115,143r0,-113r-12,0v1,-27,-3,-37,12,-35r0,-97xm80,-143v0,-69,-4,-73,-29,-72r0,67r18,0v-1,31,3,37,-18,35r0,74v26,4,29,-8,29,-104","w":133},"\u00b9":{"d":"15,-206v-23,-41,45,-53,74,-48r0,112r27,0v2,15,4,38,-11,38r-94,0v-3,-17,-5,-37,11,-38r26,0r0,-69","w":126},"\u00b3":{"d":"75,-151v0,-13,-21,-14,-37,-14v-3,-8,-11,-31,7,-30v14,4,22,-6,22,-14v-2,-17,-38,-12,-48,-2v-22,-31,7,-45,50,-45v52,0,52,44,26,70v47,26,7,95,-42,86v-40,4,-54,-21,-35,-45v9,8,57,15,57,-6","w":125},"\u00b2":{"d":"13,-104v-15,-48,63,-77,54,-98v-1,-20,-36,-13,-48,-2v-22,-37,15,-52,52,-52v35,0,46,14,46,38v0,32,-30,57,-46,76r48,0v4,16,3,39,-11,38r-95,0","w":130},"\u00bd":{"d":"15,-206v-23,-41,45,-53,74,-48r0,112r27,0v2,15,4,38,-11,38r-94,0v-3,-17,-5,-37,11,-38r26,0r0,-69xm231,-242r-95,238v-8,15,-29,6,-41,-6r94,-236v6,-17,30,-10,42,4xm202,0v-15,-48,63,-77,54,-98v-1,-20,-36,-13,-48,-2v-22,-37,15,-52,52,-52v35,0,46,14,46,38v0,32,-30,57,-46,76r48,0v4,16,3,39,-11,38r-95,0","w":318},"\u00bc":{"d":"15,-206v-23,-41,45,-53,74,-48r0,112r27,0v2,15,4,38,-11,38r-94,0v-3,-17,-5,-37,11,-38r26,0r0,-69xm281,-149r0,87r17,0v6,14,5,46,-17,39v7,26,-17,30,-38,23r0,-23r-55,0v-22,-41,22,-89,40,-112v15,-20,31,-19,53,-14xm217,-59r28,0r2,-49v-13,9,-26,32,-30,49xm231,-242r-95,238v-8,15,-29,6,-41,-6r94,-236v6,-17,30,-10,42,4","w":309},"\u00be":{"d":"75,-151v0,-13,-21,-14,-37,-14v-3,-8,-11,-31,7,-30v14,4,22,-6,22,-14v-2,-17,-38,-12,-48,-2v-22,-31,7,-45,50,-45v52,0,52,44,26,70v47,26,7,95,-42,86v-40,4,-54,-21,-35,-45v9,8,57,15,57,-6xm280,-149r0,87r17,0v6,14,5,46,-17,39v7,26,-17,30,-38,23r0,-23r-55,0v-22,-41,21,-89,39,-112v15,-20,32,-19,54,-14xm216,-59r28,0r2,-49v-13,9,-26,32,-30,49xm226,-242r-95,238v-8,15,-29,6,-41,-6r94,-236v6,-17,30,-10,42,4","w":308},"\u00a6":{"d":"61,-265r0,135v4,19,-24,14,-40,12r0,-134v-4,-19,25,-18,40,-13xm61,-79r0,136v4,18,-24,15,-40,12r0,-135v-4,-19,25,-18,40,-13","w":82},"<":{"d":"125,-120r-61,29r68,32v-3,21,-10,36,-29,28r-85,-38v-8,-15,-10,-37,6,-45r93,-44v12,11,24,30,8,38"},">":{"d":"21,-61r61,-30r-68,-31v3,-21,10,-36,29,-28r85,37v8,15,10,38,-7,45r-93,45v-11,-11,-23,-30,-7,-38"},"^":{"d":"76,-96v-17,11,-57,41,-63,3r67,-55r54,45v14,11,5,29,-12,31","w":154},"{":{"d":"13,-89v-13,-40,18,-27,18,-67v0,-24,-5,-50,-5,-69v0,-29,24,-43,56,-43v5,8,8,17,8,25v0,22,-22,14,-22,40v0,27,12,89,-14,95v40,12,-11,115,33,125v3,16,1,37,-12,37v-65,1,-44,-64,-44,-115v0,-18,-5,-25,-18,-28","w":95},"}":{"d":"82,-125v15,38,-18,28,-18,67v0,24,5,50,5,69v0,29,-23,43,-55,43v-7,-10,-13,-32,-2,-39v39,-9,-9,-103,30,-122v-37,-11,10,-115,-33,-124v-3,-17,-1,-37,13,-37v65,0,44,65,42,115v0,18,5,25,18,28","w":95},"~":{"d":"3,-98v7,-11,28,-23,50,-23v31,0,42,24,65,3v12,-7,23,5,23,23v-7,10,-25,23,-48,23v-24,0,-26,-13,-43,-13v-22,7,-45,26,-47,-13"},"\u00b0":{"d":"24,-232v0,-26,15,-38,39,-38v25,0,36,8,36,37v0,26,-13,38,-38,38v-24,0,-37,-8,-37,-37xm50,-232v0,9,4,13,12,13v7,0,12,-3,12,-14v0,-9,-3,-13,-11,-13v-8,0,-13,5,-13,14","w":123},"\u00a3":{"d":"103,-134v5,45,-9,34,-39,35v0,24,0,41,2,59r45,3v5,17,6,38,-14,37r-69,0v-3,-28,-5,-68,-5,-99r-18,0v1,-31,-2,-37,19,-35v4,-56,23,-80,58,-80v31,0,44,20,31,46v-25,-12,-45,-8,-49,34r39,0","w":124},"\u00a7":{"d":"57,-53v-9,-34,-81,-75,-32,-119v-28,-35,-7,-81,43,-81v42,0,45,24,32,49v-9,-8,-42,-10,-42,5v12,33,82,76,32,120v31,33,6,80,-42,80v-42,0,-44,-23,-32,-48v9,8,44,7,41,-6xm55,-146v-20,9,-4,29,5,40v22,-8,5,-30,-5,-40","w":117},"\u00b6":{"d":"124,-245r0,232v1,21,-30,13,-40,11r0,-71v-46,12,-75,-1,-76,-77v-2,-104,54,-121,116,-95xm84,-104r0,-115v-26,-11,-34,12,-34,64v0,56,8,61,34,51xm182,-246r0,233v4,19,-25,15,-41,12r0,-232v-4,-19,26,-18,41,-13","w":192},"\u00b1":{"d":"136,-143v6,49,-15,32,-46,35v-3,31,14,53,-35,46r0,-46r-45,0v-6,-48,14,-32,45,-35v3,-30,-13,-52,35,-45r0,45r46,0xm128,-6r-119,0v0,-24,0,-35,7,-35r119,0v0,24,0,35,-7,35"},"\u00b5":{"d":"121,-180r0,171v-15,6,-51,21,-70,8v0,36,9,88,-41,69r0,-233v-2,-19,24,-19,41,-15r0,132v-2,16,19,16,30,11r0,-128v-4,-20,23,-19,40,-15","w":131},"\u03bc":{"d":"121,-180r0,171v-15,6,-51,21,-70,8v0,36,9,88,-41,69r0,-233v-2,-19,24,-19,41,-15r0,132v-2,16,19,16,30,11r0,-128v-4,-20,23,-19,40,-15","w":131},"\u00aa":{"d":"18,-214v-14,-27,4,-42,43,-42v61,0,33,88,39,142v-33,10,-89,29,-89,-35v0,-41,24,-51,56,-42v6,-36,-25,-34,-49,-23xm56,-131v17,2,9,-20,11,-33v-12,-4,-25,-3,-25,16v0,13,6,17,14,17","w":110},"\u00ba":{"d":"10,-180v0,-53,18,-76,50,-76v32,0,48,16,48,75v0,53,-18,77,-51,77v-31,0,-47,-17,-47,-76xm43,-178v0,34,5,42,15,42v10,0,16,-10,16,-43v0,-34,-4,-41,-14,-41v-11,0,-17,10,-17,42","w":117},"\u00ac":{"d":"130,-116r0,76v-13,4,-37,6,-38,-9r0,-29r-77,0v-4,-13,-6,-37,9,-38r106,0"},"\u00a0":{"w":50},"\u00af":{"d":"97,-242v22,58,-56,34,-94,38v-7,-16,-3,-38,13,-38r81,0","w":101},"\u00f0":{"d":"45,-250v12,-23,44,-22,54,-1r22,-8v11,29,13,32,-3,38v26,52,48,226,-38,225v-44,0,-65,-24,-65,-97v1,-69,29,-106,76,-85v-3,-11,-6,-20,-11,-29r-33,13v-16,-34,-11,-35,12,-41v-4,-5,-9,-10,-14,-15xm99,-100v0,-21,1,-48,-19,-48v-18,0,-23,33,-23,63v0,38,7,55,21,55v19,0,21,-28,21,-70","w":148},"\u00fe":{"d":"52,-265r0,82v46,-2,71,7,71,72v0,96,-26,115,-47,115v-11,0,-18,-2,-24,-7r0,72v-13,3,-46,10,-40,-15r0,-301v0,-18,7,-18,40,-18xm52,-143r0,106v2,6,6,7,10,7v8,0,16,-10,16,-78v0,-46,-9,-46,-26,-35","w":131},"\u00de":{"d":"11,0r0,-242v0,-9,4,-10,27,-10r13,0v1,14,-2,31,1,43v45,0,70,15,70,74v-1,66,-34,82,-71,81r0,47v0,7,-2,7,-40,7xm77,-140v1,-28,-8,-37,-26,-33r0,80v18,6,25,-3,26,-47","w":125}}});
