<?php global $cssPath, $jsPath, $themePath, $theLayout; ?>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"><?php // Force latest IE rendering engine ?>

<title>
<?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyeleven' ), max( $paged, $page ) );

	?>
</title>
<?php // Feed link / Pingback link ?>
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php // Favorites and mobile bookmark icons ?>
<?php /*?><link rel="shortcut icon" href="<?php theme_var('options,favorites_icon','/wp-content/themes/mingle/assets/images/favicon.ico'); ?>">
<link rel="apple-touch-icon-precomposed" href="<?php theme_var('options,apple_touch_icon','/wp-content/themes/mingle/assets/images/favicon.png'); ?>">
<?php */?>
<link rel="shortcut icon" href="/wp-content/themes/mingle/assets/images/favicon.ico">
<link rel="apple-touch-icon-precomposed" href="/wp-content/themes/mingle/assets/images/favicon.png">
<?php // CSS - Primary style sheets ?>
<link rel="stylesheet" href="<?php echo $cssPath; ?>base.css">
<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/style-default.css">
<link rel="stylesheet" type="text/css" href="<?php echo $cssPath; ?>ddsmoothmenu.css" /><?php // Drop down menu  ?>
<link rel="stylesheet" type="text/css" href="<?php echo $cssPath; ?>colorbox.css" /><?php // Lightbox (colorbox) ?>

<?php theme_skin(); // Skin CSS file. To retrieve the file name only you can use "get_theme_skin()" ?>

<?php // JS variables needed to trigger theme functionality ?>
<script type="text/javascript"> var fadeContent = '<?php theme_var('options,fade_in_content','none'); ?>'; </script>

<?php wp_head(); ?>

<?php // jQuery fallback. Will load a local copy if WP Head fails to load. ?>
<script>!window.jQuery && document.write(unescape('%3Cscript src="<?php echo $jsPath; ?>libs/jquery-1.5.min.js"%3E%3C/script%3E'))</script>

<!--[if lte IE 8]>
<?php 
// IE (6-8) only - PIE.htc styles for rounded corners, gradients, etc.
if (get_theme_var('options,advanced_ie_styles',false)) : ?>
<style type="text/css">
.wp-caption, .boxLink, .btn, .btn span, .messageBox, .insetBox, textarea, input, .textInput, #Bottom footer .main, #MainMenu .inner-1, #MainMenu .inner-2, .slideMenu a, .framedImage img, .styled-image, .the-post-image figure, .gallery-icon a, .styled-image img, .the-post-image figure img, .gallery-icon img, .the-post-container, .the-comment-container, .avatar, .pagination a {
	position: relative;
	behavior: url(<?php echo THEME_URL; ?>assets/css/PIE.htc);}
.invisibleMiddle #Middle, .invisibleAll #Top, .invisibleAll #Middle, .invisibleAll #Bottom { visibility: visible; }
</style>
<?php endif; ?>
<link rel="stylesheet" type="text/css" href="<?php echo $cssPath; ?>ie.css" />
<![endif]-->

<style type="text/css">
<?php 
// Body font
if ($theLayout['body_font']) : 
	echo 'body, select, input, textarea {  font-family: '. $theLayout['body_font'] .'; } ';
endif;
	
// Heading font
if ($theLayout['heading_font']['standard']) : 
	echo 'h1, h2, h3, h4, h5, h6 {  font-family: '. $theLayout['heading_font']['standard'] .'; } ';
endif;

// Custom CSS entered in design settings
if ($customCSS = get_theme_var('design_setting,css_custom')) :
	echo prep_content($customCSS); 
endif;
?>
</style> <?php 

 
// Custom JavaScript entered in design settings
if ($customJS = get_theme_var('design_setting,js_custom')) : ?>

<script type="text/javascript">
	<?php echo prep_content($customJS); ?>
</script>
<?php endif; ?>